/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.codec.CCITTG4Encoder;
import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.QRCodeWriter;
import com.itextpdf.text.pdf.qrcode.WriterException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.MemoryImageSource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcodeQRCode {
    ByteMatrix bm;

    public BarcodeQRCode(String content, int width, int height, Map<EncodeHintType, Object> hints) {
        try {
            QRCodeWriter qc = new QRCodeWriter();
            this.bm = qc.encode(content, width, height, hints);
        }
        catch (WriterException ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private byte[] getBitMatrix() {
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int stride = (width + 7) / 8;
        byte[] b2 = new byte[stride * height];
        byte[][] mt = this.bm.getArray();
        for (int y = 0; y < height; ++y) {
            byte[] line = mt[y];
            for (int x = 0; x < width; ++x) {
                int offset;
                if (line[x] == 0) continue;
                int n2 = offset = stride * y + x / 8;
                b2[n2] = (byte)(b2[n2] | (byte)(128 >> x % 8));
            }
        }
        return b2;
    }

    public Image getImage() throws BadElementException {
        byte[] b2 = this.getBitMatrix();
        byte[] g4 = CCITTG4Encoder.compress(b2, this.bm.getWidth(), this.bm.getHeight());
        return Image.getInstance(this.bm.getWidth(), this.bm.getHeight(), false, 256, 1, g4, null);
    }

    public java.awt.Image createAwtImage(Color foreground, Color background) {
        int f2 = foreground.getRGB();
        int g2 = background.getRGB();
        Canvas canvas = new Canvas();
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int[] pix = new int[width * height];
        byte[][] mt = this.bm.getArray();
        for (int y = 0; y < height; ++y) {
            byte[] line = mt[y];
            for (int x = 0; x < width; ++x) {
                pix[y * width + x] = line[x] == 0 ? f2 : g2;
            }
        }
        java.awt.Image img = canvas.createImage(new MemoryImageSource(width, height, pix, 0, width));
        return img;
    }
}

