/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Image;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfFont;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfLine {
    protected ArrayList<PdfChunk> line;
    protected float left;
    protected float width;
    protected int alignment;
    protected float height;
    protected boolean newlineSplit = false;
    protected float originalWidth;
    protected boolean isRTL = false;
    protected ListItem listItem = null;

    PdfLine(float left, float right, int alignment, float height) {
        this.left = left;
        this.originalWidth = this.width = right - left;
        this.alignment = alignment;
        this.height = height;
        this.line = new ArrayList();
    }

    PdfLine(float left, float originalWidth, float remainingWidth, int alignment, boolean newlineSplit, ArrayList<PdfChunk> line, boolean isRTL) {
        this.left = left;
        this.originalWidth = originalWidth;
        this.width = remainingWidth;
        this.alignment = alignment;
        this.line = line;
        this.newlineSplit = newlineSplit;
        this.isRTL = isRTL;
    }

    PdfChunk add(PdfChunk chunk) {
        if (chunk == null || chunk.toString().equals("")) {
            return null;
        }
        PdfChunk overflow = chunk.split(this.width);
        boolean bl = this.newlineSplit = chunk.isNewlineSplit() || overflow == null;
        if (chunk.isTab()) {
            Object[] tab = (Object[])chunk.getAttribute("TAB");
            float tabPosition = ((Float)tab[1]).floatValue();
            boolean newline = (Boolean)tab[2];
            if (newline && tabPosition < this.originalWidth - this.width) {
                return chunk;
            }
            this.width = this.originalWidth - tabPosition;
            chunk.adjustLeft(this.left);
            this.addToLine(chunk);
        } else if (chunk.isTabSpace()) {
            if (!this.line.isEmpty()) {
                Float module = (Float)chunk.getAttribute("TABSPACE");
                float decrement = module.floatValue() - (this.originalWidth - this.width) % module.floatValue();
                if (this.width < decrement) {
                    return chunk;
                }
                this.width -= decrement;
                this.addToLine(chunk);
            }
        } else if (chunk.length() > 0 || chunk.isImage()) {
            if (overflow != null) {
                chunk.trimLastSpace();
            }
            this.width -= chunk.width();
            this.addToLine(chunk);
        } else {
            if (this.line.size() < 1) {
                chunk = overflow;
                overflow = chunk.truncate(this.width);
                this.width -= chunk.width();
                if (chunk.length() > 0) {
                    this.addToLine(chunk);
                    return overflow;
                }
                if (overflow != null) {
                    this.addToLine(overflow);
                }
                return null;
            }
            this.width += this.line.get(this.line.size() - 1).trimLastSpace();
        }
        return overflow;
    }

    private void addToLine(PdfChunk chunk) {
        if (chunk.changeLeading) {
            float f2;
            if (chunk.isImage()) {
                Image img = chunk.getImage();
                f2 = chunk.getImageHeight() + chunk.getImageOffsetY() + img.getBorderWidthTop() + img.getSpacingBefore();
            } else {
                f2 = chunk.getLeading();
            }
            if (f2 > this.height) {
                this.height = f2;
            }
        }
        this.line.add(chunk);
    }

    public int size() {
        return this.line.size();
    }

    public Iterator<PdfChunk> iterator() {
        return this.line.iterator();
    }

    float height() {
        return this.height;
    }

    float indentLeft() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 0: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
            return this.left;
        }
        if (this.getSeparatorCount() <= 0) {
            switch (this.alignment) {
                case 2: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return (this.alignment == 3 && !this.newlineSplit || this.alignment == 8) && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    void setExtraIndent(float extra) {
        this.left += extra;
        this.width -= extra;
        this.originalWidth -= extra;
    }

    float widthLeft() {
        return this.width;
    }

    int numberOfSpaces() {
        String string = this.toString();
        int length = string.length();
        int numberOfSpaces = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (string.charAt(i2) != ' ') continue;
            ++numberOfSpaces;
        }
        return numberOfSpaces;
    }

    public void setListItem(ListItem listItem) {
        this.listItem = listItem;
    }

    public Chunk listSymbol() {
        return this.listItem != null ? this.listItem.getListSymbol() : null;
    }

    public float listIndent() {
        return this.listItem != null ? this.listItem.getIndentationLeft() : 0.0f;
    }

    public ListItem listItem() {
        return this.listItem;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        for (PdfChunk pdfChunk : this.line) {
            tmp.append(pdfChunk.toString());
        }
        return tmp.toString();
    }

    public int getLineLengthUtf32() {
        int total = 0;
        for (PdfChunk element : this.line) {
            total += element.lengthUtf32();
        }
        return total;
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit && this.alignment != 8;
    }

    public int getLastStrokeChunk() {
        PdfChunk chunk;
        int lastIdx;
        for (lastIdx = this.line.size() - 1; lastIdx >= 0 && !(chunk = this.line.get(lastIdx)).isStroked(); --lastIdx) {
        }
        return lastIdx;
    }

    public PdfChunk getChunk(int idx) {
        if (idx < 0 || idx >= this.line.size()) {
            return null;
        }
        return this.line.get(idx);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    float[] getMaxSize(float fixedLeading, float multipliedLeading) {
        float normal_leading = 0.0f;
        float image_leading = -10000.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk chunk = this.line.get(k2);
            if (chunk.isImage()) {
                Image img = chunk.getImage();
                if (!chunk.changeLeading()) continue;
                float height = chunk.getImageHeight() + chunk.getImageOffsetY() + img.getSpacingBefore();
                image_leading = Math.max(height, image_leading);
                continue;
            }
            normal_leading = chunk.changeLeading() ? Math.max(chunk.getLeading(), normal_leading) : Math.max(fixedLeading + multipliedLeading * chunk.font().size(), normal_leading);
        }
        return new float[]{normal_leading > 0.0f ? normal_leading : fixedLeading, image_leading};
    }

    boolean isRTL() {
        return this.isRTL;
    }

    int getSeparatorCount() {
        int s = 0;
        for (PdfChunk element : this.line) {
            PdfChunk ck = element;
            if (ck.isTab()) {
                return -1;
            }
            if (!ck.isHorizontalSeparator()) continue;
            ++s;
        }
        return s;
    }

    public float getWidthCorrected(float charSpacing, float wordSpacing) {
        float total = 0.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk ck = this.line.get(k2);
            total += ck.getWidthCorrected(charSpacing, wordSpacing);
        }
        return total;
    }

    public float getAscender() {
        float ascender = 0.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk ck = this.line.get(k2);
            if (ck.isImage()) {
                ascender = Math.max(ascender, ck.getImageHeight() + ck.getImageOffsetY());
                continue;
            }
            PdfFont font = ck.font();
            float textRise = ck.getTextRise();
            ascender = Math.max(ascender, (textRise > 0.0f ? textRise : 0.0f) + font.getFont().getFontDescriptor(1, font.size()));
        }
        return ascender;
    }

    public float getDescender() {
        float descender = 0.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk ck = this.line.get(k2);
            if (ck.isImage()) {
                descender = Math.min(descender, ck.getImageOffsetY());
                continue;
            }
            PdfFont font = ck.font();
            float textRise = ck.getTextRise();
            descender = Math.min(descender, (textRise < 0.0f ? textRise : 0.0f) + font.getFont().getFontDescriptor(3, font.size()));
        }
        return descender;
    }
}

