/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.codec.TIFFField;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TIFFDirectory
implements Serializable {
    private static final long serialVersionUID = -168636766193675380L;
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Hashtable<Integer, Integer> fieldIndex = new Hashtable();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int endian) {
        return endian == 18761 || endian == 19789;
    }

    public TIFFDirectory(RandomAccessFileOrArray stream, int directory) throws IOException {
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bad.endianness.tag.not.0x4949.or.0x4d4d", new Object[0]));
        }
        this.isBigEndian = endian == 19789;
        int magic = this.readUnsignedShort(stream);
        if (magic != 42) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bad.magic.number.should.be.42", new Object[0]));
        }
        long ifd_offset = this.readUnsignedInt(stream);
        for (int i2 = 0; i2 < directory; ++i2) {
            if (ifd_offset == 0L) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("directory.number.too.large", new Object[0]));
            }
            stream.seek(ifd_offset);
            int entries = this.readUnsignedShort(stream);
            stream.skip(12 * entries);
            ifd_offset = this.readUnsignedInt(stream);
        }
        stream.seek(ifd_offset);
        this.initialize(stream);
        stream.seek(global_save_offset);
    }

    public TIFFDirectory(RandomAccessFileOrArray stream, long ifd_offset, int directory) throws IOException {
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bad.endianness.tag.not.0x4949.or.0x4d4d", new Object[0]));
        }
        this.isBigEndian = endian == 19789;
        stream.seek(ifd_offset);
        for (int dirNum = 0; dirNum < directory; ++dirNum) {
            int numEntries = this.readUnsignedShort(stream);
            stream.seek(ifd_offset + (long)(12 * numEntries));
            ifd_offset = this.readUnsignedInt(stream);
            stream.seek(ifd_offset);
        }
        this.initialize(stream);
        stream.seek(global_save_offset);
    }

    private void initialize(RandomAccessFileOrArray stream) throws IOException {
        long nextTagOffset = 0L;
        long maxOffset = stream.length();
        this.IFDOffset = stream.getFilePointer();
        this.numEntries = this.readUnsignedShort(stream);
        this.fields = new TIFFField[this.numEntries];
        for (int i2 = 0; i2 < this.numEntries && nextTagOffset < maxOffset; ++i2) {
            int tag = this.readUnsignedShort(stream);
            int type = this.readUnsignedShort(stream);
            int count = (int)this.readUnsignedInt(stream);
            boolean processTag = true;
            nextTagOffset = stream.getFilePointer() + 4L;
            try {
                if (count * sizeOfType[type] > 4) {
                    long valueOffset = this.readUnsignedInt(stream);
                    if (valueOffset < maxOffset) {
                        stream.seek(valueOffset);
                    } else {
                        processTag = false;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                processTag = false;
            }
            if (processTag) {
                this.fieldIndex.put(tag, i2);
                Object obj = null;
                switch (type) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        byte[] bvalues = new byte[count];
                        stream.readFully(bvalues, 0, count);
                        if (type == 2) {
                            int index = 0;
                            int prevIndex = 0;
                            ArrayList<String> v = new ArrayList<String>();
                            while (index < count) {
                                while (index < count && bvalues[index++] != 0) {
                                }
                                v.add(new String(bvalues, prevIndex, index - prevIndex));
                                prevIndex = index;
                            }
                            count = v.size();
                            String[] strings = new String[count];
                            for (int c2 = 0; c2 < count; ++c2) {
                                strings[c2] = (String)v.get(c2);
                            }
                            obj = strings;
                            break;
                        }
                        obj = bvalues;
                        break;
                    }
                    case 3: {
                        int j2;
                        char[] cvalues = new char[count];
                        for (j2 = 0; j2 < count; ++j2) {
                            cvalues[j2] = (char)this.readUnsignedShort(stream);
                        }
                        obj = cvalues;
                        break;
                    }
                    case 4: {
                        int j2;
                        long[] lvalues = new long[count];
                        for (j2 = 0; j2 < count; ++j2) {
                            lvalues[j2] = this.readUnsignedInt(stream);
                        }
                        obj = lvalues;
                        break;
                    }
                    case 5: {
                        int j2;
                        long[][] llvalues = new long[count][2];
                        for (j2 = 0; j2 < count; ++j2) {
                            llvalues[j2][0] = this.readUnsignedInt(stream);
                            llvalues[j2][1] = this.readUnsignedInt(stream);
                        }
                        obj = llvalues;
                        break;
                    }
                    case 8: {
                        int j2;
                        short[] svalues = new short[count];
                        for (j2 = 0; j2 < count; ++j2) {
                            svalues[j2] = this.readShort(stream);
                        }
                        obj = svalues;
                        break;
                    }
                    case 9: {
                        int j2;
                        int[] ivalues = new int[count];
                        for (j2 = 0; j2 < count; ++j2) {
                            ivalues[j2] = this.readInt(stream);
                        }
                        obj = ivalues;
                        break;
                    }
                    case 10: {
                        int j2;
                        int[][] iivalues = new int[count][2];
                        for (j2 = 0; j2 < count; ++j2) {
                            iivalues[j2][0] = this.readInt(stream);
                            iivalues[j2][1] = this.readInt(stream);
                        }
                        obj = iivalues;
                        break;
                    }
                    case 11: {
                        int j2;
                        float[] fvalues = new float[count];
                        for (j2 = 0; j2 < count; ++j2) {
                            fvalues[j2] = this.readFloat(stream);
                        }
                        obj = fvalues;
                        break;
                    }
                    case 12: {
                        int j2;
                        double[] dvalues = new double[count];
                        for (j2 = 0; j2 < count; ++j2) {
                            dvalues[j2] = this.readDouble(stream);
                        }
                        obj = dvalues;
                        break;
                    }
                }
                this.fields[i2] = new TIFFField(tag, type, count, obj);
            }
            stream.seek(nextTagOffset);
        }
        try {
            this.nextIFDOffset = this.readUnsignedInt(stream);
        }
        catch (Exception e2) {
            this.nextIFDOffset = 0L;
        }
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int tag) {
        Integer i2 = this.fieldIndex.get(tag);
        if (i2 == null) {
            return null;
        }
        return this.fields[i2];
    }

    public boolean isTagPresent(int tag) {
        return this.fieldIndex.containsKey(tag);
    }

    public int[] getTags() {
        int[] tags = new int[this.fieldIndex.size()];
        Enumeration<Integer> e2 = this.fieldIndex.keys();
        int i2 = 0;
        while (e2.hasMoreElements()) {
            tags[i2++] = e2.nextElement();
        }
        return tags;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int tag, int index) {
        Integer i2 = this.fieldIndex.get(tag);
        byte[] b2 = this.fields[i2].getAsBytes();
        return b2[index];
    }

    public byte getFieldAsByte(int tag) {
        return this.getFieldAsByte(tag, 0);
    }

    public long getFieldAsLong(int tag, int index) {
        Integer i2 = this.fieldIndex.get(tag);
        return this.fields[i2].getAsLong(index);
    }

    public long getFieldAsLong(int tag) {
        return this.getFieldAsLong(tag, 0);
    }

    public float getFieldAsFloat(int tag, int index) {
        Integer i2 = this.fieldIndex.get(tag);
        return this.fields[i2].getAsFloat(index);
    }

    public float getFieldAsFloat(int tag) {
        return this.getFieldAsFloat(tag, 0);
    }

    public double getFieldAsDouble(int tag, int index) {
        Integer i2 = this.fieldIndex.get(tag);
        return this.fields[i2].getAsDouble(index);
    }

    public double getFieldAsDouble(int tag) {
        return this.getFieldAsDouble(tag, 0);
    }

    private short readShort(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readShort();
        }
        return stream.readShortLE();
    }

    private int readUnsignedShort(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private int readInt(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readInt();
        }
        return stream.readIntLE();
    }

    private long readUnsignedInt(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    private long readLong(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readLong();
        }
        return stream.readLongLE();
    }

    private float readFloat(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readFloat();
        }
        return stream.readFloatLE();
    }

    private double readDouble(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readDouble();
        }
        return stream.readDoubleLE();
    }

    private static int readUnsignedShort(RandomAccessFileOrArray stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(RandomAccessFileOrArray stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    public static int getNumDirectories(RandomAccessFileOrArray stream) throws IOException {
        long pointer = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bad.endianness.tag.not.0x4949.or.0x4d4d", new Object[0]));
        }
        boolean isBigEndian = endian == 19789;
        int magic = TIFFDirectory.readUnsignedShort(stream, isBigEndian);
        if (magic != 42) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bad.magic.number.should.be.42", new Object[0]));
        }
        stream.seek(4L);
        long offset = TIFFDirectory.readUnsignedInt(stream, isBigEndian);
        int numDirectories = 0;
        while (offset != 0L) {
            ++numDirectories;
            try {
                stream.seek(offset);
                int entries = TIFFDirectory.readUnsignedShort(stream, isBigEndian);
                stream.skip(12 * entries);
                offset = TIFFDirectory.readUnsignedInt(stream, isBigEndian);
            }
            catch (EOFException eof) {
                --numDirectories;
                break;
            }
        }
        stream.seek(pointer);
        return numDirectories;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

