/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.Annotation;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfAcroForm;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class PdfAnnotationsImp {
    protected PdfAcroForm acroForm;
    protected ArrayList<PdfAnnotation> annotations;
    protected ArrayList<PdfAnnotation> delayedAnnotations = new ArrayList();

    public PdfAnnotationsImp(PdfWriter writer) {
        this.acroForm = new PdfAcroForm(writer);
    }

    public boolean hasValidAcroForm() {
        return this.acroForm.isValid();
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setSigFlags(int f2) {
        this.acroForm.setSigFlags(f2);
    }

    public void addCalculationOrder(PdfFormField formField) {
        this.acroForm.addCalculationOrder(formField);
    }

    public void addAnnotation(PdfAnnotation annot) {
        if (annot.isForm()) {
            PdfFormField field = (PdfFormField)annot;
            if (field.getParent() == null) {
                this.addFormFieldRaw(field);
            }
        } else {
            this.annotations.add(annot);
        }
    }

    public void addPlainAnnotation(PdfAnnotation annot) {
        this.annotations.add(annot);
    }

    void addFormFieldRaw(PdfFormField field) {
        this.annotations.add(field);
        ArrayList<PdfFormField> kids = field.getKids();
        if (kids != null) {
            for (int k2 = 0; k2 < kids.size(); ++k2) {
                this.addFormFieldRaw(kids.get(k2));
            }
        }
    }

    public boolean hasUnusedAnnotations() {
        return !this.annotations.isEmpty();
    }

    public void resetAnnotations() {
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList();
    }

    public PdfArray rotateAnnotations(PdfWriter writer, Rectangle pageSize) {
        PdfArray array = new PdfArray();
        int rotation = pageSize.getRotation() % 360;
        int currentPage = writer.getCurrentPageNumber();
        for (int k2 = 0; k2 < this.annotations.size(); ++k2) {
            PdfAnnotation dic = this.annotations.get(k2);
            int page = dic.getPlaceInPage();
            if (page > currentPage) {
                this.delayedAnnotations.add(dic);
                continue;
            }
            if (dic.isForm()) {
                PdfFormField field;
                HashSet<PdfTemplate> templates;
                if (!dic.isUsed() && (templates = dic.getTemplates()) != null) {
                    this.acroForm.addFieldTemplates(templates);
                }
                if ((field = (PdfFormField)dic).getParent() == null) {
                    this.acroForm.addDocumentField(field.getIndirectReference());
                }
            }
            if (dic.isAnnotation()) {
                PdfArray tmp;
                PdfRectangle rect;
                array.add(dic.getIndirectReference());
                if (!dic.isUsed() && (rect = (tmp = dic.getAsArray(PdfName.RECT)).size() == 4 ? new PdfRectangle(tmp.getAsNumber(0).floatValue(), tmp.getAsNumber(1).floatValue(), tmp.getAsNumber(2).floatValue(), tmp.getAsNumber(3).floatValue()) : new PdfRectangle(tmp.getAsNumber(0).floatValue(), tmp.getAsNumber(1).floatValue())) != null) {
                    switch (rotation) {
                        case 90: {
                            dic.put(PdfName.RECT, new PdfRectangle(pageSize.getTop() - rect.bottom(), rect.left(), pageSize.getTop() - rect.top(), rect.right()));
                            break;
                        }
                        case 180: {
                            dic.put(PdfName.RECT, new PdfRectangle(pageSize.getRight() - rect.left(), pageSize.getTop() - rect.bottom(), pageSize.getRight() - rect.right(), pageSize.getTop() - rect.top()));
                            break;
                        }
                        case 270: {
                            dic.put(PdfName.RECT, new PdfRectangle(rect.bottom(), pageSize.getRight() - rect.left(), rect.top(), pageSize.getRight() - rect.right()));
                        }
                    }
                }
            }
            if (dic.isUsed()) continue;
            dic.setUsed();
            try {
                writer.addToBody((PdfObject)dic, dic.getIndirectReference());
                continue;
            }
            catch (IOException e2) {
                throw new ExceptionConverter(e2);
            }
        }
        return array;
    }

    public static PdfAnnotation convertAnnotation(PdfWriter writer, Annotation annot, Rectangle defaultRect) throws IOException {
        switch (annot.annotationType()) {
            case 1: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((URL)annot.attributes().get("url")));
            }
            case 2: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get("file")));
            }
            case 3: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get("file"), (String)annot.attributes().get("destination")));
            }
            case 7: {
                boolean[] sparams = (boolean[])annot.attributes().get("parameters");
                String fname = (String)annot.attributes().get("file");
                String mimetype = (String)annot.attributes().get("mime");
                PdfFileSpecification fs = sparams[0] ? PdfFileSpecification.fileEmbedded(writer, fname, fname, null) : PdfFileSpecification.fileExtern(writer, fname);
                PdfAnnotation ann = PdfAnnotation.createScreen(writer, new Rectangle(annot.llx(), annot.lly(), annot.urx(), annot.ury()), fname, fs, mimetype, sparams[1]);
                return ann;
            }
            case 4: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get("file"), (Integer)annot.attributes().get("page")));
            }
            case 5: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((Integer)annot.attributes().get("named")));
            }
            case 6: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get("application"), (String)annot.attributes().get("parameters"), (String)annot.attributes().get("operation"), (String)annot.attributes().get("defaultdir")));
            }
        }
        return new PdfAnnotation(writer, defaultRect.getLeft(), defaultRect.getBottom(), defaultRect.getRight(), defaultRect.getTop(), new PdfString(annot.title(), "UnicodeBig"), new PdfString(annot.content(), "UnicodeBig"));
    }
}

