/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageMath;
import java.io.Serializable;

public class ArrayColormap
implements Colormap,
Cloneable,
Serializable {
    static final long serialVersionUID = -7990431442314209043L;
    protected int[] map;

    public ArrayColormap() {
        this.map = new int[256];
    }

    public ArrayColormap(int[] map) {
        this.map = map;
    }

    public Object clone() {
        try {
            ArrayColormap g2 = (ArrayColormap)super.clone();
            g2.map = (int[])this.map.clone();
            return g2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setMap(int[] map) {
        this.map = map;
    }

    public int[] getMap() {
        return this.map;
    }

    public int getColor(float v) {
        int n2 = (int)(v * 255.0f);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        return this.map[n2];
    }

    public void setColorInterpolated(int index, int firstIndex, int lastIndex, int color) {
        int i2;
        int firstColor = this.map[firstIndex];
        int lastColor = this.map[lastIndex];
        for (i2 = firstIndex; i2 <= index; ++i2) {
            this.map[i2] = ImageMath.mixColors((float)(i2 - firstIndex) / (float)(index - firstIndex), firstColor, color);
        }
        for (i2 = index; i2 < lastIndex; ++i2) {
            this.map[i2] = ImageMath.mixColors((float)(i2 - index) / (float)(lastIndex - index), color, lastColor);
        }
    }

    public void setColorRange(int firstIndex, int lastIndex, int color1, int color2) {
        for (int i2 = firstIndex; i2 <= lastIndex; ++i2) {
            this.map[i2] = ImageMath.mixColors((float)(i2 - firstIndex) / (float)(lastIndex - firstIndex), color1, color2);
        }
    }

    public void setColorRange(int firstIndex, int lastIndex, int color) {
        for (int i2 = firstIndex; i2 <= lastIndex; ++i2) {
            this.map[i2] = color;
        }
    }

    public void setColor(int index, int color) {
        this.map[index] = color;
    }
}

