/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PointFilter;
import java.awt.image.BufferedImage;
import java.util.Random;

public class DissolveFilter
extends PointFilter {
    private float density = 1.0f;
    private float softness = 0.0f;
    private float minDensity;
    private float maxDensity;
    private Random randomNumbers;

    public void setDensity(float density) {
        this.density = density;
    }

    public float getDensity() {
        return this.density;
    }

    public void setSoftness(float softness) {
        this.softness = softness;
    }

    public float getSoftness() {
        return this.softness;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        float d2 = (1.0f - this.density) * (1.0f + this.softness);
        this.minDensity = d2 - this.softness;
        this.maxDensity = d2;
        this.randomNumbers = new Random(0L);
        return super.filter(src, dst);
    }

    public int filterRGB(int x, int y, int rgb) {
        int a2 = rgb >> 24 & 0xFF;
        float v = this.randomNumbers.nextFloat();
        float f2 = ImageMath.smoothStep(this.minDensity, this.maxDensity, v);
        return (int)((float)a2 * f2) << 24 | rgb & 0xFFFFFF;
    }

    public String toString() {
        return "Stylize/Dissolve...";
    }
}

