/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PixelUtils;
import java.awt.image.BufferedImage;

public class GlintFilter
extends AbstractBufferedImageOp {
    private float threshold = 1.0f;
    private int length = 5;
    private float blur = 0.0f;
    private float amount = 0.1f;
    private boolean glintOnly = false;
    private Colormap colormap = new LinearColormap(-1, -16777216);

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setBlur(float blur) {
        this.blur = blur;
    }

    public float getBlur() {
        return this.blur;
    }

    public void setGlintOnly(boolean glintOnly) {
        this.glintOnly = glintOnly;
    }

    public boolean getGlintOnly() {
        return this.glintOnly;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width];
        int length2 = (int)((float)this.length / 1.414f);
        int[] colors = new int[this.length + 1];
        int[] colors2 = new int[length2 + 1];
        if (this.colormap != null) {
            int b2;
            int g2;
            int r;
            int argb;
            int i2;
            for (i2 = 0; i2 <= this.length; ++i2) {
                argb = this.colormap.getColor((float)i2 / (float)this.length);
                r = argb >> 16 & 0xFF;
                g2 = argb >> 8 & 0xFF;
                b2 = argb & 0xFF;
                colors[i2] = argb = argb & 0xFF000000 | (int)(this.amount * (float)r) << 16 | (int)(this.amount * (float)g2) << 8 | (int)(this.amount * (float)b2);
            }
            for (i2 = 0; i2 <= length2; ++i2) {
                argb = this.colormap.getColor((float)i2 / (float)length2);
                r = argb >> 16 & 0xFF;
                g2 = argb >> 8 & 0xFF;
                b2 = argb & 0xFF;
                colors2[i2] = argb = argb & 0xFF000000 | (int)(this.amount * (float)r) << 16 | (int)(this.amount * (float)g2) << 8 | (int)(this.amount * (float)b2);
            }
        }
        BufferedImage mask = new BufferedImage(width, height, 2);
        int threshold3 = (int)(this.threshold * 3.0f * 255.0f);
        for (int y = 0; y < height; ++y) {
            this.getRGB(src, 0, y, width, 1, pixels);
            for (int x = 0; x < width; ++x) {
                int rgb = pixels[x];
                int a2 = rgb & 0xFF000000;
                int r = rgb >> 16 & 0xFF;
                int g3 = rgb >> 8 & 0xFF;
                int b3 = rgb & 0xFF;
                int l2 = r + g3 + b3;
                pixels[x] = l2 < threshold3 ? -16777216 : a2 | (l2 /= 3) << 16 | l2 << 8 | l2;
            }
            this.setRGB(mask, 0, y, width, 1, pixels);
        }
        if (this.blur != 0.0f) {
            mask = new GaussianFilter(this.blur).filter(mask, null);
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] dstPixels = this.glintOnly ? new int[width * height] : this.getRGB(src, 0, 0, width, height, null);
        for (int y = 0; y < height; ++y) {
            int index = y * width;
            this.getRGB(mask, 0, y, width, 1, pixels);
            int ymin = Math.max(y - this.length, 0) - y;
            int ymax = Math.min(y + this.length, height - 1) - y;
            int ymin2 = Math.max(y - length2, 0) - y;
            int ymax2 = Math.min(y + length2, height - 1) - y;
            for (int x = 0; x < width; ++x) {
                if ((float)(pixels[x] & 0xFF) > this.threshold * 255.0f) {
                    int xmin = Math.max(x - this.length, 0) - x;
                    int xmax = Math.min(x + this.length, width - 1) - x;
                    int xmin2 = Math.max(x - length2, 0) - x;
                    int xmax2 = Math.min(x + length2, width - 1) - x;
                    int i3 = 0;
                    int k2 = 0;
                    while (i3 <= xmax) {
                        dstPixels[index + i3] = PixelUtils.combinePixels(dstPixels[index + i3], colors[k2], 4);
                        ++i3;
                        ++k2;
                    }
                    i3 = -1;
                    k2 = 1;
                    while (i3 >= xmin) {
                        dstPixels[index + i3] = PixelUtils.combinePixels(dstPixels[index + i3], colors[k2], 4);
                        --i3;
                        ++k2;
                    }
                    i3 = 1;
                    int j2 = index + width;
                    int k3 = 0;
                    while (i3 <= ymax) {
                        dstPixels[j2] = PixelUtils.combinePixels(dstPixels[j2], colors[k3], 4);
                        ++i3;
                        j2 += width;
                        ++k3;
                    }
                    i3 = -1;
                    j2 = index - width;
                    k3 = 0;
                    while (i3 >= ymin) {
                        dstPixels[j2] = PixelUtils.combinePixels(dstPixels[j2], colors[k3], 4);
                        --i3;
                        j2 -= width;
                        ++k3;
                    }
                    int xymin = Math.max(xmin2, ymin2);
                    int xymax = Math.min(xmax2, ymax2);
                    int count = Math.min(xmax2, ymax2);
                    int i4 = 1;
                    int j3 = index + width + 1;
                    int k4 = 0;
                    while (i4 <= count) {
                        dstPixels[j3] = PixelUtils.combinePixels(dstPixels[j3], colors2[k4], 4);
                        ++i4;
                        j3 += width + 1;
                        ++k4;
                    }
                    count = Math.min(-xmin2, -ymin2);
                    i4 = 1;
                    j3 = index - width - 1;
                    k4 = 0;
                    while (i4 <= count) {
                        dstPixels[j3] = PixelUtils.combinePixels(dstPixels[j3], colors2[k4], 4);
                        ++i4;
                        j3 -= width + 1;
                        ++k4;
                    }
                    count = Math.min(xmax2, -ymin2);
                    i4 = 1;
                    j3 = index - width + 1;
                    k4 = 0;
                    while (i4 <= count) {
                        dstPixels[j3] = PixelUtils.combinePixels(dstPixels[j3], colors2[k4], 4);
                        ++i4;
                        j3 += -width + 1;
                        ++k4;
                    }
                    count = Math.min(-xmin2, ymax2);
                    i4 = 1;
                    j3 = index + width - 1;
                    k4 = 0;
                    while (i4 <= count) {
                        dstPixels[j3] = PixelUtils.combinePixels(dstPixels[j3], colors2[k4], 4);
                        ++i4;
                        j3 += width - 1;
                        ++k4;
                    }
                }
                ++index;
            }
        }
        this.setRGB(dst, 0, 0, width, height, dstPixels);
        return dst;
    }

    public String toString() {
        return "Effects/Glint...";
    }
}

