/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

public class FFT {
    protected float[] w1;
    protected float[] w2;
    protected float[] w3;

    public FFT(int logN) {
        this.w1 = new float[logN];
        this.w2 = new float[logN];
        this.w3 = new float[logN];
        int N = 1;
        for (int k2 = 0; k2 < logN; ++k2) {
            double angle = Math.PI * -2 / (double)(N <<= 1);
            this.w1[k2] = (float)Math.sin(0.5 * angle);
            this.w2[k2] = -2.0f * this.w1[k2] * this.w1[k2];
            this.w3[k2] = (float)Math.sin(angle);
        }
    }

    private void scramble(int n2, float[] real, float[] imag) {
        int j2 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int m2;
            if (i2 > j2) {
                float t = real[j2];
                real[j2] = real[i2];
                real[i2] = t;
                t = imag[j2];
                imag[j2] = imag[i2];
                imag[i2] = t;
            }
            for (m2 = n2 >> 1; j2 >= m2 && m2 >= 2; j2 -= m2, m2 >>= 1) {
            }
            j2 += m2;
        }
    }

    private void butterflies(int n2, int logN, int direction, float[] real, float[] imag) {
        int N = 1;
        for (int k2 = 0; k2 < logN; ++k2) {
            int half_N = N;
            N <<= 1;
            float wt = (float)direction * this.w1[k2];
            float wp_re = this.w2[k2];
            float wp_im = (float)direction * this.w3[k2];
            float w_re = 1.0f;
            float w_im = 0.0f;
            for (int offset = 0; offset < half_N; ++offset) {
                for (int i2 = offset; i2 < n2; i2 += N) {
                    int j2 = i2 + half_N;
                    float re = real[j2];
                    float im = imag[j2];
                    float temp_re = w_re * re - w_im * im;
                    float temp_im = w_im * re + w_re * im;
                    real[j2] = real[i2] - temp_re;
                    int n3 = i2;
                    real[n3] = real[n3] + temp_re;
                    imag[j2] = imag[i2] - temp_im;
                    int n4 = i2;
                    imag[n4] = imag[n4] + temp_im;
                }
                wt = w_re;
                w_re = wt * wp_re - w_im * wp_im + w_re;
                w_im = w_im * wp_re + wt * wp_im + w_im;
            }
        }
        if (direction == -1) {
            float nr = 1.0f / (float)n2;
            int i3 = 0;
            while (i3 < n2) {
                int n5 = i3;
                real[n5] = real[n5] * nr;
                int n6 = i3++;
                imag[n6] = imag[n6] * nr;
            }
        }
    }

    public void transform1D(float[] real, float[] imag, int logN, int n2, boolean forward) {
        this.scramble(n2, real, imag);
        this.butterflies(n2, logN, forward ? 1 : -1, real, imag);
    }

    public void transform2D(float[] real, float[] imag, int cols, int rows, boolean forward) {
        int log2cols = this.log2(cols);
        int log2rows = this.log2(rows);
        int n2 = Math.max(rows, cols);
        float[] rtemp = new float[n2];
        float[] itemp = new float[n2];
        for (int y = 0; y < rows; ++y) {
            int offset = y * cols;
            System.arraycopy(real, offset, rtemp, 0, cols);
            System.arraycopy(imag, offset, itemp, 0, cols);
            this.transform1D(rtemp, itemp, log2cols, cols, forward);
            System.arraycopy(rtemp, 0, real, offset, cols);
            System.arraycopy(itemp, 0, imag, offset, cols);
        }
        for (int x = 0; x < cols; ++x) {
            int y;
            int index = x;
            for (y = 0; y < rows; ++y) {
                rtemp[y] = real[index];
                itemp[y] = imag[index];
                index += cols;
            }
            this.transform1D(rtemp, itemp, log2rows, rows, forward);
            index = x;
            for (y = 0; y < rows; ++y) {
                real[index] = rtemp[y];
                imag[index] = itemp[y];
                index += cols;
            }
        }
    }

    private int log2(int n2) {
        int m2 = 1;
        int log2n = 0;
        while (m2 < n2) {
            m2 *= 2;
            ++log2n;
        }
        return m2 == n2 ? log2n : -1;
    }
}

