/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.math.CompoundFunction2D;
import com.jhlabs.math.Function2D;

public class TurbulenceFunction
extends CompoundFunction2D {
    private float octaves;

    public TurbulenceFunction(Function2D basis, float octaves) {
        super(basis);
        this.octaves = octaves;
    }

    public void setOctaves(float octaves) {
        this.octaves = octaves;
    }

    public float getOctaves() {
        return this.octaves;
    }

    public float evaluate(float x, float y) {
        float t = 0.0f;
        for (float f2 = 1.0f; f2 <= this.octaves; f2 *= 2.0f) {
            t += Math.abs(this.basis.evaluate(f2 * x, f2 * y)) / f2;
        }
        return t;
    }
}

