/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class BaseSeparatorUI
extends BasicSeparatorUI {
    private static final Dimension size = new Dimension(2, 3);

    public static ComponentUI createUI(JComponent c2) {
        return new BaseSeparatorUI();
    }

    public void paint(Graphics g2, JComponent c2) {
        ColorUIResource background;
        boolean horizontal = true;
        if (c2 instanceof JSeparator) {
            horizontal = ((JSeparator)c2).getOrientation() == 0;
        }
        ColorUIResource colorUIResource = background = c2 instanceof JPopupMenu.Separator ? AbstractLookAndFeel.getMenuBackgroundColor() : AbstractLookAndFeel.getBackgroundColor();
        if (horizontal) {
            int w = c2.getWidth();
            g2.setColor(background);
            g2.drawLine(0, 0, w, 0);
            g2.setColor(ColorHelper.darker(background, 30.0));
            g2.drawLine(0, 1, w, 1);
            g2.setColor(ColorHelper.brighter(background, 50.0));
            g2.drawLine(0, 2, w, 2);
        } else {
            int h2 = c2.getHeight();
            g2.setColor(ColorHelper.darker(background, 30.0));
            g2.drawLine(0, 0, 0, h2);
            g2.setColor(ColorHelper.brighter(background, 50.0));
            g2.drawLine(1, 0, 1, h2);
        }
    }

    public Dimension getPreferredSize(JComponent c2) {
        return size;
    }
}

