/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class HiFiButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new HiFiButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b2.getWidth();
        int height = b2.getHeight();
        Graphics2D g2D = (Graphics2D)g2;
        Shape savedClip = g2.getClip();
        if (b2.getBorder() != null && b2.isBorderPainted() && b2.getBorder() instanceof UIResource) {
            Area clipArea = new Area(new Rectangle2D.Double(1.0, 1.0, width - 2, height - 2));
            if (savedClip != null) {
                clipArea.intersect(new Area(savedClip));
            }
            g2D.setClip(clipArea);
        }
        super.paintBackground(g2, b2);
        g2D.setClip(savedClip);
    }

    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        ButtonModel model = b2.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
        int mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
        int offs = 0;
        if (model.isArmed() && model.isPressed()) {
            offs = 1;
        }
        Graphics2D g2D = (Graphics2D)g2;
        Composite composite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
        g2D.setComposite(alpha);
        Color foreground = b2.getForeground();
        Color background = b2.getBackground();
        if (background instanceof ColorUIResource) {
            if (model.isPressed() && model.isArmed()) {
                foreground = AbstractLookAndFeel.getTheme().getSelectionForegroundColor();
            } else if (model.isRollover()) {
                foreground = AbstractLookAndFeel.getTheme().getRolloverForegroundColor();
            }
        }
        if (!model.isEnabled()) {
            foreground = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
        }
        if (ColorHelper.getGrayValue(foreground) > 64) {
            g2D.setColor(Color.black);
        } else {
            g2D.setColor(Color.white);
        }
        JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs + 1, textRect.y + offs + fm.getAscent() + 1);
        g2D.setComposite(composite);
        g2D.setColor(foreground);
        JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
    }
}

