/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;

public class McWinComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent c2) {
        return new McWinComboBoxUI();
    }

    public JButton createArrowButton() {
        ArrowButton button = new ArrowButton();
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder border = BorderFactory.createMatteBorder(0, 1, 0, 0, AbstractLookAndFeel.getFrameColor());
            button.setBorder(border);
        } else {
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 0, 1, AbstractLookAndFeel.getFrameColor());
            button.setBorder(border);
        }
        return button;
    }

    static class ArrowButton
    extends NoFocusButton {
        ArrowButton() {
        }

        public void paint(Graphics g2) {
            Dimension size = this.getSize();
            if (this.isEnabled()) {
                if (this.getModel().isArmed() && this.getModel().isPressed()) {
                    JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getPressedColors(), 0, 0, size.width, size.height);
                } else if (this.getModel().isRollover()) {
                    JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getRolloverColors(), 0, 0, size.width, size.height);
                } else if (JTattooUtilities.isActive(this)) {
                    if (AbstractLookAndFeel.getTheme().isBrightMode()) {
                        JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getButtonColors(), 0, 0, size.width, size.height);
                    } else {
                        JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getDefaultColors(), 0, 0, size.width, size.height);
                    }
                } else {
                    JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getInActiveColors(), 0, 0, size.width, size.height);
                }
            } else {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getDisabledColors(), 0, 0, size.width, size.height);
            }
            Icon icon = BaseIcons.getComboBoxIcon();
            int x = (size.width - icon.getIconWidth()) / 2;
            int y = (size.height - icon.getIconHeight()) / 2;
            if (this.getModel().isPressed() && this.getModel().isArmed()) {
                icon.paintIcon(this, g2, x + 2, y + 1);
            } else {
                icon.paintIcon(this, g2, x + 1, y);
            }
            this.paintBorder(g2);
        }
    }
}

