/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODDesktopIconUI;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class NimRODInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static final long serialVersionUID = 3569530640592496710L;
    private MiML miml;
    private Icon resizeIcon;
    private Icon antIcon;
    private int litWidth = UIManager.getInt("NimRODInternalFrameIconLit.width");
    private int litHeight = UIManager.getInt("NimRODInternalFrameIconLit.height");

    public NimRODInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
        this.closeButton.setOpaque(false);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setFocusPainted(false);
        this.maxButton.setOpaque(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.setFocusPainted(false);
        this.iconButton.setOpaque(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setFocusPainted(false);
        HackML hackML = new HackML();
        this.closeButton.addMouseListener(hackML);
        this.maxButton.addMouseListener(hackML);
        this.iconButton.addMouseListener(hackML);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.addMouseListener(this.miml);
        this.addMouseMotionListener(this.miml);
        this.frame.addMouseListener(this.miml);
        this.frame.addMouseMotionListener(this.miml);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeMouseListener(this.miml);
        this.removeMouseMotionListener(this.miml);
        this.frame.removeMouseListener(this.miml);
        this.frame.removeMouseMotionListener(this.miml);
        this.miml = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new NimRODPropertyChangeHandler();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        String string;
        int n2;
        int n3;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.getInstance(3, NimRODUtils.getFrameOpacityFloat()));
        GradientPaint gradientPaint = this.frame.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getPrimaryControlDarkShadow(), n4, 0.0f, NimRODLookAndFeel.getPrimaryControl()) : new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getControl(), n4, 0.0f, NimRODLookAndFeel.getControlDarkShadow());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 1, n4, n5);
        graphics2D.dispose();
        int n6 = n3 = this.frame.getComponentOrientation().isLeftToRight() ? 5 : n4 - 5;
        if (this.frame.getFrameIcon() != this.antIcon) {
            n2 = this.litHeight > n5 ? n5 - 2 : this.litHeight;
            int n7 = this.litHeight > n5 ? n2 : this.litWidth;
            this.antIcon = this.frame.getFrameIcon();
            this.resizeIcon = NimRODUtils.reescala(this.antIcon, n2, n7);
        }
        if (this.resizeIcon != null) {
            n2 = n5 / 2 - this.resizeIcon.getIconHeight() / 2;
            this.resizeIcon.paintIcon(this.frame, graphics, n3, n2);
            n3 += 5 + this.resizeIcon.getIconWidth();
        }
        if ((string = this.frame.getTitle()) != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n8 = (n5 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            int n9 = n4;
            if (this.frame.isIconifiable()) {
                n9 = this.iconButton.getBounds().x;
            } else if (this.frame.isMaximizable()) {
                n9 = this.maxButton.getBounds().x;
            } else if (this.frame.isClosable()) {
                n9 = this.closeButton.getBounds().x;
            }
            n9 = n9 - n3 - this.getInsets().left;
            string = this.getTitle(string, fontMetrics, n9);
            if (this.frame.isSelected()) {
                NimRODUtils.paintShadowTitleFat(graphics, string, n3, n8, Color.white);
            } else {
                NimRODUtils.paintShadowTitleFat(graphics, string, n3, n8, NimRODLookAndFeel.getControl());
            }
        }
    }

    class NimRODPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        NimRODPropertyChangeHandler() {
            super(NimRODInternalFrameTitlePane.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                NimRODInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", bl);
                NimRODInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", bl);
                NimRODInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", bl);
            } else if ("JInternalFrame.messageType".equals(string)) {
                NimRODInternalFrameTitlePane.this.frame.repaint();
            } else if ("icon".equals(string)) {
                NimRODInternalFrameTitlePane.this.iconButton.getModel().setRollover(false);
                NimRODInternalFrameTitlePane.this.closeButton.getModel().setRollover(false);
                NimRODInternalFrameTitlePane.this.maxButton.getModel().setRollover(false);
                ((NimRODDesktopIconUI)((NimRODInternalFrameTitlePane)NimRODInternalFrameTitlePane.this).frame.getDesktopIcon().getUI()).hasFocus = false;
            } else if ("frameIcon".equals(string) && NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    private class HackML
    extends MouseInputAdapter {
        private HackML() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }
    }

    private class MiML
    extends MouseInputAdapter {
        Insets ins;

        private MiML() {
            this.ins = NimRODInternalFrameTitlePane.this.frame.getBorder().getBorderInsets(NimRODInternalFrameTitlePane.this.frame);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        void dodo(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() instanceof NimRODInternalFrameTitlePane) {
                if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                    NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
                }
            } else {
                int n2 = mouseEvent.getX();
                int n3 = NimRODInternalFrameTitlePane.this.frame.getWidth();
                int n4 = mouseEvent.getY();
                int n5 = NimRODInternalFrameTitlePane.this.frame.getHeight();
                if ((n2 <= 5 || n2 >= n3 - this.ins.right || n4 >= n5 - this.ins.bottom) && NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                    NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
                }
            }
        }
    }
}

