/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class NimRODSpinnerUI
extends BasicSpinnerUI {
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.oldOpaque = this.spinner.isOpaque();
        this.spinner.setOpaque(false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.spinner.setOpaque(this.oldOpaque);
    }

    @Override
    protected Component createPreviousButton() {
        Component component = this.createArrowButton(5);
        component.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(component);
        return component;
    }

    @Override
    protected Component createNextButton() {
        Component component = this.createArrowButton(1);
        component.setName("Spinner.nextButton");
        this.installNextButtonListeners(component);
        return component;
    }

    private Component createArrowButton(int n2) {
        NimRODArrowButton nimRODArrowButton = new NimRODArrowButton(n2);
        nimRODArrowButton.setInheritsPopupMenu(true);
        return nimRODArrowButton;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(2, 3, jComponent.getWidth() - 4, jComponent.getHeight() - 6);
        graphics.drawLine(3, 2, jComponent.getWidth() - 4, 2);
        graphics.drawLine(3, jComponent.getHeight() - 3, jComponent.getWidth() - 4, jComponent.getHeight() - 3);
        JComponent jComponent2 = this.spinner.getEditor();
        if (jComponent2 instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent2).getTextField();
            jFormattedTextField.setBackground(jComponent.getBackground());
        }
    }

    class NimRODArrowButton
    extends JButton {
        private static final long serialVersionUID = 3031842923932443184L;
        private int dir;

        public NimRODArrowButton(int n2) {
            this.setRequestFocusEnabled(false);
            this.dir = n2;
            if (n2 == 1) {
                this.setIcon(UIManager.getIcon("Spinner.nextIcon"));
            } else {
                this.setIcon(UIManager.getIcon("Spinner.previousIcon"));
            }
            this.setOpaque(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, this.getIcon().getIconHeight());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics graphics) {
            int n2;
            Icon icon = this.getIcon();
            int n3 = this.getWidth() - 1;
            int n4 = this.getHeight() - 1;
            int n5 = (n3 - icon.getIconWidth()) / 2;
            int n6 = n2 = (n4 - icon.getIconHeight()) / 2;
            Border border = ((JSpinner)this.getParent()).getBorder();
            if (border != null) {
                if (this.dir == 1) {
                    n2 += border.getBorderInsets((Component)this).top / 2;
                    n6 = border.getBorderInsets((Component)this).top - 2;
                } else {
                    n6 = this.getHeight() - border.getBorderInsets((Component)this).bottom;
                }
                n3 -= 3;
            }
            icon.paintIcon(this, graphics, n5, n2);
            if (this.dir == 1) {
                graphics.setColor(NimRODUtils.getBrillo());
                graphics.drawLine(1, n6, 1, n4);
                graphics.setColor(NimRODUtils.getSombra());
                graphics.drawLine(1, n4, n3, n4);
                graphics.drawLine(0, n6, 0, n4);
            } else {
                graphics.setColor(NimRODUtils.getBrillo());
                graphics.drawLine(1, 0, n3, 0);
                graphics.drawLine(1, 0, 1, n6);
                graphics.setColor(NimRODUtils.getSombra());
                graphics.drawLine(0, 0, 0, n6);
            }
        }
    }
}

