/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class PgsBorders {
    private static Border buttonBorder;
    private static Border textFieldBorder;
    private static Border componentBorder;
    private static Border toolBarBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getComponentBorder() {
        if (componentBorder == null) {
            componentBorder = new BorderUIResource.CompoundBorderUIResource(new ComponentBorder(), new BasicBorders.MarginBorder());
        }
        return componentBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new BorderUIResource(new ToolBarBorder());
        }
        return toolBarBorder;
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    PgsUtils.drawVerticalBumps(graphics, 2, 4, component.getHeight() - 6);
                } else {
                    PgsUtils.drawHorizontalBumps(graphics, 4, 2, component.getWidth() - 6);
                }
            }
            if (((JToolBar)component).getOrientation() == 0) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.setColor(UIManager.getColor("ToolBar.borderColor"));
                graphics.drawLine(0, n5 - 1, n4, n5 - 1);
            }
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2;
            insets.left = 2;
            insets.top = 1;
            insets.bottom = 2;
            insets.right = 2;
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        insets.left = 16;
                    } else {
                        insets.right = 16;
                    }
                } else {
                    insets.top = 16;
                }
            }
            if ((insets2 = ((JToolBar)component).getMargin()) != null) {
                insets.left += insets2.left;
                insets.top += insets2.top;
                insets.right += insets2.right;
                insets.bottom += insets2.bottom;
            }
            return insets;
        }
    }

    private static class ComponentBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ComponentBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (component.isEnabled()) {
                PgsUtils.drawButtonBorder(graphics, n2, n3, n4, n5);
            } else {
                PgsUtils.drawDisabledBorder(graphics, n2, n3, n4 - 1, n5 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ComponentBorder.INSETS.top;
            insets.left = ComponentBorder.INSETS.left;
            insets.bottom = ComponentBorder.INSETS.bottom;
            insets.right = ComponentBorder.INSETS.right;
            return insets;
        }
    }

    private static class TextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private TextFieldBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (component.isEnabled()) {
                boolean bl = component instanceof JTextComponent && ((JTextComponent)component).isEditable() || component instanceof JComboBox && ((JComboBox)component).isEditable();
                boolean bl2 = component.hasFocus();
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    bl2 = jComboBox.isEditable() && jComboBox.getEditor().getEditorComponent().hasFocus();
                }
                PgsUtils.drawButtonBorder(graphics, n2, n3, n4 - 1, n5 - 1, 2, 2, bl2 && bl ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlDarkShadow());
            } else {
                PgsUtils.drawDisabledBorder(graphics, n2, n3, n4 - 1, n5 - 1, 2, 2);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = TextFieldBorder.INSETS.top;
            insets.left = TextFieldBorder.INSETS.left;
            insets.bottom = TextFieldBorder.INSETS.bottom;
            insets.right = TextFieldBorder.INSETS.right;
            return insets;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(3, 4, 3, 4);
        protected static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

        private ButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isRollover() && PlafOptions.isPaintRolloverButtonBorder()) {
                    PgsUtils.drawRolloverButtonBorder(graphics, n2, n3, n4, n5);
                } else {
                    PgsUtils.drawButtonBorder(graphics, n2, n3, n4, n5);
                }
            } else {
                PgsUtils.drawDisabledBorder(graphics, n2, n3, n4 - 1, n5 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            if (((AbstractButton)component).isBorderPainted()) {
                return INSETS;
            }
            return NO_INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (((AbstractButton)component).isBorderPainted()) {
                return this.getBorderInsets(component, insets, INSETS);
            }
            return this.getBorderInsets(component, insets, NO_INSETS);
        }

        public Insets getBorderInsets(Component component, Insets insets, Insets insets2) {
            insets.top = insets2.top;
            insets.left = insets2.left;
            insets.bottom = insets2.bottom;
            insets.right = insets2.right;
            return insets;
        }
    }

    public static class Generic
    extends AbstractBorder
    implements UIResource {
        private Insets insets;
        private Color color;

        public Generic(Insets insets, Color color) {
            this.insets = insets;
            this.color = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.setColor(this.color);
            if (this.insets.left != 0) {
                graphics.fillRect(n2, n3, n2 + this.insets.left, n3 + n5);
            }
            if (this.insets.right != 0) {
                graphics.fillRect(n2 + n4 - this.insets.right, n3, n2 + n4, n3 + n5);
            }
            if (this.insets.top != 0) {
                graphics.fillRect(n2, n3, n2 + n4, n2 + this.insets.top);
            }
            if (this.insets.bottom != 0) {
                graphics.fillRect(n2, n3 + n5 - this.insets.bottom, n2 + n4, n3 + n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            return insets;
        }
    }
}

