/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.javasound.JSSample;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class JSPositionalSample
extends JSSample {
    float leftGain = 1.0f;
    float rightGain = 1.0f;
    int leftDelay = 0;
    int rightDelay = 0;
    protected static final boolean dopplerFlag = true;
    int secondIndex = -1;
    int reverbIndex = -1;
    Point3f xformLeftEar = new Point3f(-0.09f, -0.03f, 0.095f);
    Point3f xformRightEar = new Point3f(0.09f, -0.03f, 0.095f);
    Vector3f xformHeadZAxis = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f sourceToCenterEar = new Vector3f();
    Vector3f sourceToRightEar = new Vector3f();
    Vector3f sourceToLeftEar = new Vector3f();
    boolean averageDistances = false;
    long deltaTime = 0L;
    double sourcePositionChange = -1.0;
    double headPositionChange = -1.0;
    static int MAX_DISTANCES = 4;
    int numDistances = 0;
    long[] times = new long[MAX_DISTANCES];
    Point3f[] positions = new Point3f[MAX_DISTANCES];
    Point3f[] centerEars = new Point3f[MAX_DISTANCES];
    int firstIndex = 0;
    int lastIndex = 0;
    int currentIndex = 0;
    double lastRequestedDopplerRateRatio = -1.0;
    double lastActualDopplerRateRatio = -1.0;
    static double maxRatio = 256.0;
    static int TOWARDS = 1;
    static int NO_CHANGE = 0;
    static int AWAY = -1;
    boolean filterFlag = false;
    float filterFreq = -1.0f;

    public JSPositionalSample() {
        for (int i2 = 0; i2 < MAX_DISTANCES; ++i2) {
            this.positions[i2] = new Point3f();
            this.centerEars[i2] = new Point3f(0.09f, -0.03f, 0.095f);
        }
        this.clear();
    }

    boolean getFilterFlag() {
        return this.filterFlag;
    }

    float getFilterFreq() {
        return this.filterFreq;
    }

    public void clear() {
        super.clear();
        this.leftGain = 1.0f;
        this.rightGain = 1.0f;
        this.leftDelay = 0;
        this.rightDelay = 0;
        this.xformLeftEar.set(-0.09f, -0.03f, 0.095f);
        this.xformRightEar.set(0.09f, -0.03f, 0.095f);
        this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
        this.sourceToCenterEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToRightEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToLeftEar.set(0.0f, 0.0f, 0.0f);
        this.reset();
    }

    void reset() {
        super.reset();
        this.averageDistances = false;
        this.deltaTime = 0L;
        this.sourcePositionChange = -1.0;
        this.headPositionChange = -1.0;
        this.rateRatio = 1.0f;
        this.numDistances = 0;
        this.averageDistances = false;
    }

    void incrementIndices() {
        int n2 = MAX_DISTANCES - 1;
        if (this.numDistances < n2) {
            this.averageDistances = false;
            this.currentIndex = this.numDistances++;
            this.lastIndex = this.currentIndex - 1;
            this.firstIndex = 0;
        } else if (this.numDistances == n2) {
            this.averageDistances = true;
            this.currentIndex = n2;
            this.lastIndex = this.currentIndex - 1;
            this.firstIndex = 0;
            ++this.numDistances;
        } else if (this.numDistances > n2) {
            this.averageDistances = true;
            ++this.currentIndex;
            ++this.lastIndex;
            ++this.firstIndex;
            this.currentIndex %= MAX_DISTANCES;
            this.lastIndex %= MAX_DISTANCES;
            this.firstIndex %= MAX_DISTANCES;
        }
    }

    void setXformedPosition() {
        Point3f point3f = new Point3f();
        if (this.getVWrldXfrmFlag()) {
            this.vworldXfrm.transform(this.position, point3f);
        } else {
            point3f.set(this.position);
        }
        if (point3f.x == this.positions[this.currentIndex].x && point3f.y == this.positions[this.currentIndex].y && point3f.z == this.positions[this.currentIndex].z) {
            return;
        }
        this.incrementIndices();
        this.times[this.currentIndex] = System.currentTimeMillis();
        this.positions[this.currentIndex].set(point3f);
        if (this.numDistances > 1) {
            this.centerEars[this.currentIndex].set(this.centerEars[this.lastIndex]);
        }
    }

    float calculateDoppler(AuralParameters auralParameters) {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        float f2 = 0.344f;
        double d7 = 1.0;
        double d8 = 1.0;
        int n2 = NO_CHANGE;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (!this.averageDistances) {
            this.debugPrint("JSPositionalSample.calculateDoppler - not enough distance data collected, dopplerRatio set to zero");
            return 0.0f;
        }
        Point3f point3f = this.positions[this.lastIndex];
        Point3f point3f2 = this.centerEars[this.lastIndex];
        Point3f point3f3 = this.positions[this.currentIndex];
        Point3f point3f4 = this.centerEars[this.currentIndex];
        d5 = point3f3.distance(point3f4);
        d6 = point3f.distance(point3f2);
        this.debugPrint("JSPositionalSample.calculateDoppler - distances: current,last = " + d5 + ", " + d6);
        this.debugPrint("                                      current position = " + point3f3.x + ", " + point3f3.y + ", " + point3f3.z);
        this.debugPrint("                                      current ear = " + point3f4.x + ", " + point3f4.y + ", " + point3f4.z);
        this.debugPrint("                                      last position = " + point3f.x + ", " + point3f.y + ", " + point3f.z);
        this.debugPrint("                                      last ear = " + point3f2.x + ", " + point3f2.y + ", " + point3f2.z);
        if (d5 == d6) {
            this.debugPrint("JSPositionalSample.calculateDoppler - distance diff = 0, dopplerRatio set to zero");
            return 0.0f;
        }
        this.deltaTime = this.times[this.currentIndex] - this.times[this.firstIndex];
        for (int i2 = 0; i2 < MAX_DISTANCES - 1; ++i2) {
            f3 += this.positions[i2 + 1].distance(this.positions[i2]);
            f4 += this.centerEars[i2 + 1].distance(this.centerEars[i2]);
        }
        d4 = (f3 /= (float)(MAX_DISTANCES - 1)) / (float)this.deltaTime;
        d3 = (f4 /= (float)(MAX_DISTANCES - 1)) / (float)this.deltaTime;
        this.debugPrint("                                      delta time = " + this.deltaTime);
        this.debugPrint("                                      soundPosition delta = " + point3f3.distance(point3f));
        this.debugPrint("                                      soundVelocity = " + d4);
        this.debugPrint("                                      headPosition delta = " + point3f4.distance(point3f2));
        this.debugPrint("                                      headVelocity = " + d3);
        if (auralParameters != null) {
            float f5 = auralParameters.rolloff;
            float f6 = auralParameters.velocityScaleFactor;
            if (f5 != 1.0f) {
                f2 *= f5;
                this.debugPrint("                                      attrib rollof = " + f5);
            }
            if (f6 != 1.0f) {
                this.debugPrint("                                      attrib velocity scale factor = " + f6);
                this.debugPrint("                                      new soundVelocity = " + (d4 *= (double)f6));
                this.debugPrint("                                      new headVelocity = " + (d3 *= (double)f6));
            }
        }
        if (d5 < d6) {
            this.debugPrint("                                      moving towards...");
            n2 = TOWARDS;
            d7 = (double)f2 + d3;
            d8 = (double)f2 - d4;
        } else {
            this.debugPrint("                                      moving away...");
            n2 = AWAY;
            d7 = (double)f2 - d3;
            d8 = (double)f2 + d4;
        }
        if (d7 <= 0.0) {
            this.debugPrint("JSPositionalSample.calculateDoppler: BOOM!! - velocity of head > speed of sound");
            return -1.0f;
        }
        if (d8 <= 0.0) {
            this.debugPrint("JSPositionalSample.calculateDoppler: BOOM!! - velocity of sound source negative");
            return -1.0f;
        }
        this.debugPrint("JSPositionalSample.calculateDoppler: numerator = " + d7 + ", denominator = " + d8);
        d2 = d7 / d8;
        return (float)d2;
    }

    void updateEar(int n2, View view) {
        Point3f point3f = new Point3f();
        if (!this.calculateNewEar(n2, view, point3f)) {
            return;
        }
        if (point3f.x == this.centerEars[this.currentIndex].x && point3f.y == this.centerEars[this.currentIndex].y && point3f.z == this.centerEars[this.currentIndex].z) {
            return;
        }
        this.incrementIndices();
        this.times[this.currentIndex] = System.currentTimeMillis();
        this.centerEars[this.currentIndex].set(point3f);
        if (this.numDistances > 1) {
            this.positions[this.currentIndex].set(this.positions[this.lastIndex]);
        }
    }

    boolean calculateNewEar(int n2, View view, Point3f point3f) {
        PhysicalBody physicalBody;
        Point3d point3d = new Point3d();
        boolean bl = false;
        if (!bl && view != null && (physicalBody = view.getPhysicalBody()) != null) {
            Transform3D transform3D = new Transform3D();
            view.getUserHeadToVworld(transform3D);
            physicalBody.getLeftEarPosition(point3d);
            this.xformLeftEar.x = (float)point3d.x;
            this.xformLeftEar.y = (float)point3d.y;
            this.xformLeftEar.z = (float)point3d.z;
            physicalBody.getRightEarPosition(point3d);
            this.xformRightEar.x = (float)point3d.x;
            this.xformRightEar.y = (float)point3d.y;
            this.xformRightEar.z = (float)point3d.z;
            transform3D.transform(this.xformRightEar);
            transform3D.transform(this.xformLeftEar);
            this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
            transform3D.transform(this.xformHeadZAxis);
            point3f.x = this.xformLeftEar.x + (this.xformRightEar.x - this.xformLeftEar.x) * 0.5f;
            point3f.y = this.xformLeftEar.y + (this.xformRightEar.y - this.xformLeftEar.y) * 0.5f;
            point3f.z = this.xformLeftEar.z + (this.xformRightEar.z - this.xformLeftEar.z) * 0.5f;
            bl = true;
        }
        if (!bl) {
            // empty if block
        }
        return bl;
    }

    public void render(int n2, View view, AuralParameters auralParameters) {
        this.updateEar(n2, view);
        float f2 = 1.0f;
        if (auralParameters != null) {
            float f3 = auralParameters.rolloff;
            float f4 = auralParameters.frequencyScaleFactor;
            float f5 = auralParameters.velocityScaleFactor;
            this.debugPrint("JSPositionalSample: attribs NOT null");
            if (!(f3 <= 0.0f) && !(f4 <= 0.0f)) {
                if (f5 > 0.0f) {
                    this.debugPrint("    velocityScaleFactor = " + f5);
                    f2 = this.calculateDoppler(auralParameters);
                    if (f2 != 0.0f && f2 != -1.0f && f2 > 0.0f) {
                        this.rateRatio = f2 * f4 * this.getRateScaleFactor();
                    }
                } else {
                    this.rateRatio = f4 * this.getRateScaleFactor();
                }
            }
        } else {
            this.debugPrint("JSPositionalSample: attribs null");
            this.rateRatio = 1.0f;
        }
        this.panSample(auralParameters);
    }

    float calculateAngularGain() {
        return 1.0f;
    }

    void calculateFilter(float f2, AuralParameters auralParameters) {
        float f3 = 44100.0f;
        float f4 = 44100.0f;
        int n2 = auralParameters.getDistanceFilterLength();
        int n3 = auralParameters.getDistanceFilterType();
        boolean bl = false;
        boolean bl2 = false;
        if (n3 != -1 && n2 > 0) {
            double[] dArray = new double[n2];
            float[] fArray = new float[n2];
            auralParameters.getDistanceFilter(dArray, fArray);
            f3 = this.findFactor(f2, dArray, fArray);
            bl = !(f3 < 0.0f);
        } else {
            bl = false;
            f3 = -1.0f;
        }
        bl2 = false;
        f4 = -1.0f;
        this.filterFlag = bl || bl2;
        this.filterFreq = f3;
    }

    float findFactor(double d2, double[] dArray, float[] fArray) {
        if (dArray == null || fArray == null) {
            return -1.0f;
        }
        int n2 = dArray.length;
        if (n2 < 2) {
            return -1.0f;
        }
        int n3 = n2 - 1;
        if (d2 >= dArray[n3]) {
            return fArray[n3];
        }
        if (d2 <= dArray[0]) {
            return fArray[0];
        }
        int n4 = 0;
        int n5 = n3;
        while (n4 < n5 - 1) {
            if (dArray[n4] >= d2) {
                if (d2 < dArray[n4]) {
                    // empty if block
                }
                return fArray[n4];
            }
            if (dArray[n5] <= d2) {
                if (d2 > dArray[n5]) {
                    // empty if block
                }
                return fArray[n5];
            }
            if (!(d2 > dArray[n4]) || !(d2 < dArray[n5])) continue;
            int n6 = n4 + (n5 - n4) / 2;
            if (d2 <= dArray[n6]) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        float f2 = (float)((d2 - dArray[n4]) / (dArray[n5] - dArray[n4])) * (fArray[n5] - fArray[n4]) + fArray[n4];
        return f2;
    }

    float calculateDistanceAttenuation(float f2) {
        float f3 = 1.0f;
        f3 = this.findFactor(f2, this.attenuationDistance, this.attenuationGain);
        if ((double)f3 >= 0.0) {
            return f3;
        }
        return 1.0f;
    }

    void panSample(AuralParameters auralParameters) {
        int n2 = 1;
        float f2 = 1.0f;
        float f3 = 0.125f;
        float f4 = f2 - f3;
        float f5 = 1.0E-6f;
        float f6 = 0.999999f;
        float f7 = -f6;
        float f8 = 1.5707964f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.18f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.344f;
        float f20 = 1.0f / 0.344f;
        float f21 = 44.1f;
        boolean bl = false;
        boolean bl2 = false;
        float f22 = 1.0f;
        float f23 = this.gain;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Vector3f vector3f = new Vector3f();
        point3f.set(this.positions[this.currentIndex]);
        point3f2.set(this.centerEars[this.currentIndex]);
        this.sourceToCenterEar.x = point3f2.x - point3f.x;
        this.sourceToCenterEar.y = point3f2.y - point3f.y;
        this.sourceToCenterEar.z = point3f2.z - point3f.z;
        this.sourceToRightEar.x = this.xformRightEar.x - point3f.x;
        this.sourceToRightEar.y = this.xformRightEar.y - point3f.y;
        this.sourceToRightEar.z = this.xformRightEar.z - point3f.z;
        this.sourceToLeftEar.x = this.xformLeftEar.x - point3f.x;
        this.sourceToLeftEar.y = this.xformLeftEar.y - point3f.y;
        this.sourceToLeftEar.z = this.xformLeftEar.z - point3f.z;
        f9 = point3f.distance(point3f2);
        f11 = point3f.distance(this.xformRightEar);
        f12 = point3f.distance(this.xformLeftEar);
        f13 = this.xformRightEar.distance(this.xformLeftEar);
        f14 = f13 * 0.5f;
        f15 = f14 / f9;
        double d2 = this.sourceToCenterEar.dot(this.xformHeadZAxis) / (this.sourceToCenterEar.length() * this.xformHeadZAxis.length());
        f16 = (float)Math.acos(d2);
        if (f16 > f8) {
            bl2 = true;
            f16 = (float)Math.PI - f16;
        } else {
            bl2 = false;
        }
        f18 = (float)Math.acos(f15);
        boolean bl3 = bl = !(f11 > f12);
        n2 = bl ? (bl2 ? 4 : 1) : (bl2 ? 3 : 2);
        f17 = (float)Math.sin(f16);
        if ((double)f17 < 0.0) {
            f17 = -f17;
        }
        float f24 = (float)Math.sqrt((double)f9 * (double)f9 + (double)(f14 * f14));
        if (bl) {
            f12 = f24 + f14 * (f8 + f16 - f18);
        } else {
            f11 = f24 + f14 * (f8 + f16 - f18);
        }
        if (f17 < f15) {
            if (bl) {
                f11 = f24 + f14 * (f8 - f16 - f18);
            } else {
                f12 = f24 + f14 * (f8 - f16 - f18);
            }
        } else if (bl) {
            // empty if block
        }
        f21 = this.channel.rateInHz * 0.001f;
        if (bl) {
            this.rightDelay = 0;
            this.leftDelay = (int)((f12 - f11) * f20 * f21);
        } else {
            this.leftDelay = 0;
            this.rightDelay = (int)((f11 - f12) * f20 * f21);
        }
        point3f.sub(point3f2);
        point3f.scale(1.0f / f9);
        f22 = this.calculateDistanceAttenuation(f9);
        f23 *= f22;
        f23 *= this.calculateAngularGain();
        float f25 = point3f.x / 2.0f;
        float f26 = f25 >= 0.0f ? f4 * (0.5f - f25) : f4 * (0.5f + f25);
        switch (n2) {
            case 1: 
            case 4: {
                this.rightGain = f23 * (f2 - f26);
                this.leftGain = f23 * (f3 + f26);
                break;
            }
            case 2: 
            case 3: {
                this.leftGain = f23 * (f2 - f26);
                this.rightGain = f23 * (f3 + f26);
            }
        }
        this.calculateFilter(f9, auralParameters);
    }
}

