/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.exp.swing;

import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class JCanvas3D
extends JPanel
implements AncestorListener {
    public static final int RESIZE_IMMEDIATELY = 0;
    public static final int RESIZE_DELAYED = 1;
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfigTemplate3D template;
    private GraphicsConfiguration graphicsConfig;
    private InternalCanvas3D canvas;
    private boolean hasBeenAdded = false;
    int resizeMode;
    int resizeValidationDelay;
    private GraphicsDevice device;

    public JCanvas3D() {
        this(null, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public JCanvas3D(GraphicsDevice graphicsDevice) {
        this(null, graphicsDevice);
    }

    public JCanvas3D(GraphicsConfigTemplate3D graphicsConfigTemplate3D) {
        this(graphicsConfigTemplate3D, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public JCanvas3D(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsDevice graphicsDevice) {
        this.device = graphicsDevice;
        this.template = new GraphicsConfigTemplate3D();
        if (graphicsConfigTemplate3D != null) {
            this.template.setRedSize(graphicsConfigTemplate3D.getRedSize());
            this.template.setGreenSize(graphicsConfigTemplate3D.getGreenSize());
            this.template.setBlueSize(graphicsConfigTemplate3D.getBlueSize());
            this.template.setDepthSize(graphicsConfigTemplate3D.getDepthSize());
            this.template.setSceneAntialiasing(graphicsConfigTemplate3D.getSceneAntialiasing());
            this.template.setStencilSize(graphicsConfigTemplate3D.getStencilSize());
        }
        this.template.setStereo(3);
        this.template.setDoubleBuffer(3);
        this.graphicsConfig = this.device.getBestConfiguration(this.template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setResizeMode(0);
        this.setResizeValidationDelay(100);
        this.setFocusable(true);
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        Dimension dimension = this.getSize();
        if (0 == dimension.width) {
            dimension.width = 100;
        }
        if (0 == dimension.height) {
            dimension.height = 100;
        }
        this.createCanvas(dimension.width, dimension.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
        this.hasBeenAdded = true;
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.hasBeenAdded = false;
        this.canvas.removeNotify();
    }

    private void computePhysicalDimensions() {
        Rectangle rectangle = this.graphicsConfig.getBounds();
        int n2 = (int)rectangle.getWidth();
        int n3 = (int)rectangle.getHeight();
        this.canvas.getScreen3D().setSize(n2, n3);
        this.canvas.getScreen3D().setPhysicalScreenWidth((double)n2 * METERS_PER_PIXEL);
        this.canvas.getScreen3D().setPhysicalScreenHeight((double)n3 * METERS_PER_PIXEL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createCanvas(int n2, int n3) {
        if (this.getParent() == null) {
            return;
        }
        if (null != this.canvas) {
            if (n2 == this.canvas.getWidth() && n3 == this.canvas.getHeight()) return;
            if (null != this.canvas.getOffScreenBuffer() && null != this.canvas.getOffScreenBuffer().getImage()) {
                this.canvas.getOffScreenBuffer().getImage().flush();
            }
        } else {
            this.canvas = new InternalCanvas3D(this.graphicsConfig, this);
        }
        this.createOffScreenBuffer(n2, n3);
    }

    private void createOffScreenBuffer(int n2, int n3) {
        this.computePhysicalDimensions();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage, true, false);
        imageComponent2D.setCapability(2);
        imageComponent2D.setCapability(3);
        this.canvas.stopRenderer();
        this.canvas.waitForOffScreenRendering();
        this.canvas.setOffScreenBuffer(imageComponent2D);
        this.canvas.startRenderer();
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (null == this.canvas) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public int getResizeValidationDelay() {
        return this.resizeValidationDelay;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasBeenAdded) {
            if (!this.canvas.canvasCrashed && this.canvas.isRendererRunning()) {
                this.canvas.waitForSwap();
            }
            if (null != this.canvas.bi) {
                graphics.drawImage(this.canvas.bi, 0, 0, this.getWidth(), this.getHeight(), null);
            }
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        Object object = keyEvent.getSource();
        keyEvent.setSource(this.canvas);
        this.canvas.processComponentEvent(keyEvent);
        keyEvent.setSource(object);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        Object object = focusEvent.getSource();
        focusEvent.setSource(this.canvas);
        this.canvas.processFocusEvent(focusEvent);
        focusEvent.setSource(object);
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        super.processInputMethodEvent(inputMethodEvent);
        Object object = inputMethodEvent.getSource();
        inputMethodEvent.setSource(this.canvas);
        this.canvas.processInputMethodEvent(inputMethodEvent);
        inputMethodEvent.setSource(object);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        Object object = keyEvent.getSource();
        keyEvent.setSource(this.canvas);
        this.canvas.processKeyEvent(keyEvent);
        keyEvent.setSource(object);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        Object object = mouseEvent.getSource();
        mouseEvent.setSource(this.canvas);
        this.canvas.processMouseEvent(mouseEvent);
        mouseEvent.setSource(object);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        Object object = mouseEvent.getSource();
        mouseEvent.setSource(this.canvas);
        this.canvas.processMouseMotionEvent(mouseEvent);
        mouseEvent.setSource(object);
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        super.processMouseWheelEvent(mouseWheelEvent);
        Object object = mouseWheelEvent.getSource();
        mouseWheelEvent.setSource(this.canvas);
        this.canvas.processMouseWheelEvent(mouseWheelEvent);
        mouseWheelEvent.setSource(object);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        if (null == this.canvas || null == this.canvas.getOffScreenBuffer() || 0 == this.getResizeMode()) {
            this.createCanvas(n4, n5);
        } else if (1 == this.getResizeMode() && null != this.canvas.getParent() && this.canvas.getParent().isVisible()) {
            if (null == this.canvas.resizeThread || !this.canvas.resizeThread.isAlive()) {
                this.canvas.resizeThread = new ResizeThread(n4, n5, this.getResizeValidationDelay(), this);
                this.canvas.resizeThread.start();
            } else {
                this.canvas.resizeThread.setWidth(n4);
                this.canvas.resizeThread.setHeight(n5);
            }
        }
    }

    public void setResizeMode(int n2) {
        this.resizeMode = n2;
    }

    public void setResizeValidationDelay(int n2) {
        this.resizeValidationDelay = n2;
    }

    static class InternalCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private static final int MAX_WAIT_LOOPS = 5;
        private static final long MAX_WAIT_TIME = 100L;
        BufferedImage bi = null;
        JCanvas3D lwCanvas;
        ResizeThread resizeThread;
        boolean addNotifyFlag;
        protected boolean canvasCrashed;
        boolean imageReadyBis;
        boolean waitingForSwap;

        public InternalCanvas3D(GraphicsConfiguration graphicsConfiguration, JCanvas3D jCanvas3D) {
            super(graphicsConfiguration, true);
            this.lwCanvas = jCanvas3D;
            this.imageReadyBis = false;
            this.waitingForSwap = false;
            this.addNotifyFlag = false;
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("CHANGE ME");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            if (null == this.lwCanvas) {
                return null;
            }
            return this.lwCanvas.getParent();
        }

        public void postRender() {
            this.imageReadyBis = false;
        }

        public synchronized void postSwap() {
            if (this.isRendererRunning()) {
                this.bi = this.getOffScreenBuffer().getImage();
                this.imageReadyBis = true;
                if (!this.waitingForSwap) {
                    this.lwCanvas.repaint();
                } else {
                    this.notify();
                }
            }
        }

        protected void processComponentEvent(ComponentEvent componentEvent) {
            super.processComponentEvent(componentEvent);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
        }

        protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
            super.processInputMethodEvent(inputMethodEvent);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
        }

        protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
            super.processMouseWheelEvent(mouseWheelEvent);
        }

        synchronized void waitForSwap() {
            int n2 = 5;
            while (!this.imageReadyBis) {
                try {
                    this.waitingForSwap = true;
                    this.wait(100L);
                    this.waitingForSwap = false;
                    if (this.imageReadyBis || --n2 > 0) continue;
                    System.err.println("CANVAS CRASHED!!!");
                    this.canvasCrashed = true;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
            }
        }
    }

    static class ResizeSwingRunnable
    implements Runnable {
        JCanvas3D canvas;
        int height;
        int width;

        private ResizeSwingRunnable() {
        }

        public ResizeSwingRunnable(JCanvas3D jCanvas3D, int n2, int n3) {
            this.canvas = jCanvas3D;
            this.width = n2;
            this.height = n3;
        }

        public void run() {
            this.canvas.createCanvas(this.width, this.height);
        }
    }

    static class ResizeThread
    extends Thread {
        JCanvas3D canvas;
        boolean sizeChanged;
        int delay;
        int height;
        int width;

        private ResizeThread() {
        }

        public ResizeThread(int n2, int n3, int n4, JCanvas3D jCanvas3D) {
            this.width = n2;
            this.height = n3;
            this.delay = n4;
            this.sizeChanged = true;
            this.canvas = jCanvas3D;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public void run() {
            try {
                while (this.sizeChanged) {
                    while (this.sizeChanged) {
                        this.sizeChanged = false;
                        Thread.sleep(this.delay);
                    }
                    try {
                        EventQueue.invokeAndWait(new ResizeSwingRunnable(this.canvas, this.width, this.height));
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setHeight(int n2) {
            if (!this.isAlive()) {
                throw new RuntimeException("Resizing order arrived to a dead resizing thread. Spawn a new one.");
            }
            this.height = n2;
            this.sizeChanged = true;
        }

        public void setWidth(int n2) {
            if (!this.isAlive()) {
                throw new RuntimeException("Resizing order arrived to a dead resizing thread. Spawn a new one.");
            }
            this.width = n2;
            this.sizeChanged = true;
        }
    }
}

