/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.LwoSurface;
import com.sun.j3d.loaders.lw3d.ParserObject;
import java.util.Vector;
import javax.vecmath.Vector3f;

class ShapeHolder
extends ParserObject {
    Vector facetSizesList;
    Vector facetIndicesList;
    int[] facetIndicesArray;
    int currentNumIndices = 0;
    int numSurf;
    int numVerts;
    int[] facetIndices;
    int[] facetSizes;
    int[] normalIndices;
    float[] normalCoords;
    float[] coordsArray;

    ShapeHolder() {
    }

    ShapeHolder(int n2) {
        super(n2);
    }

    void printGeometryData(LwoSurface lwoSurface) {
        int n2 = 0;
        System.out.println("\nPolygon Data:");
        System.out.println("  Surface color = " + lwoSurface.color);
        System.out.println("  Surface diffuse = " + lwoSurface.diffuseColor);
        for (int i2 = 0; i2 < this.facetSizes.length; ++i2) {
            int n3 = this.facetSizes[i2];
            System.out.println("Facet of size " + n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = 3 * this.facetIndices[n2++];
                System.out.println("x, y, z = " + this.coordsArray[n4] + ", " + this.coordsArray[n4 + 1] + ", " + this.coordsArray[n4 + 2]);
            }
        }
    }

    void createArrays(boolean bl) {
        int n2;
        int n3;
        int n4;
        this.debugOutputLn(1, "createArrays()");
        this.facetIndices = new int[this.currentNumIndices];
        if (bl) {
            n4 = 0;
            for (n3 = 0; n3 < this.facetSizesList.size(); ++n3) {
                n2 = (Integer)this.facetSizesList.elementAt(n3);
                int[] nArray = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.facetIndices[n4 + i2] = this.facetIndicesArray[n4 + n2 - i2 - 1];
                }
                n4 += n2;
            }
        } else {
            for (n4 = 0; n4 < this.facetIndices.length; ++n4) {
                this.facetIndices[n4] = this.facetIndicesArray[n4];
            }
        }
        this.debugOutputLn(8, "facetIndices.len and coordsArray.len = " + this.facetIndices.length + ", " + this.coordsArray.length);
        if ((Integer)this.facetSizesList.elementAt(0) < 3) {
            this.debugOutputLn(8, "Using direct geometry because facetIndices is of size " + this.facetIndices.length + " and coordsArray is of length " + this.coordsArray.length);
            float[] fArray = new float[this.facetIndices.length * 3];
            n3 = 0;
            for (n2 = 0; n2 < this.facetIndices.length; ++n2) {
                fArray[n3++] = this.coordsArray[this.facetIndices[n2] * 3];
                fArray[n3++] = this.coordsArray[this.facetIndices[n2] * 3 + 1];
                fArray[n3++] = this.coordsArray[this.facetIndices[n2] * 3 + 2];
            }
            this.coordsArray = fArray;
            this.facetIndices = null;
        }
        this.facetSizes = new int[this.facetSizesList.size()];
        for (int i3 = 0; i3 < this.facetSizes.length; ++i3) {
            this.facetSizes[i3] = (Integer)this.facetSizesList.elementAt(i3);
        }
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
    }

    void nullify() {
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
        this.facetSizes = null;
        this.facetIndices = null;
        this.normalCoords = null;
        this.normalIndices = null;
    }

    void calcNormals() {
        this.debugOutputLn(1, "calcNormals()");
        this.debugOutputLn(8, "coordsLength, facetsizes.len = " + this.coordsArray.length + ", " + this.facetSizes.length);
        if (this.facetSizes[0] > 2) {
            if (this.facetIndices != null) {
                this.normalIndices = new int[this.facetIndices.length];
                this.normalCoords = new float[this.facetIndices.length * 3];
            } else {
                this.normalCoords = new float[this.coordsArray.length];
            }
            this.debugOutputLn(8, "normalCoords, incides len = " + this.normalCoords.length + ", " + (this.facetIndices == null ? 0 : this.normalIndices.length));
            int n2 = 0;
            int n3 = -1;
            for (int i2 = 0; i2 < this.facetSizes.length; ++i2) {
                Vector3f vector3f;
                int n4 = this.facetSizes[i2];
                if (n4 < 3) {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                } else {
                    int n5;
                    int n6;
                    int n7;
                    if (this.facetIndices != null) {
                        n7 = this.facetIndices[n2];
                        n6 = this.facetIndices[n2 + 1];
                        n5 = this.facetIndices[n2 + 2];
                    } else {
                        n7 = n2;
                        n6 = n2 + 1;
                        n5 = n2 + 2;
                    }
                    Vector3f vector3f2 = new Vector3f(this.coordsArray[n6 * 3] - this.coordsArray[n7 * 3], this.coordsArray[n6 * 3 + 1] - this.coordsArray[n7 * 3 + 1], this.coordsArray[n6 * 3 + 2] - this.coordsArray[n7 * 3 + 2]);
                    Vector3f vector3f3 = new Vector3f(this.coordsArray[n5 * 3] - this.coordsArray[n7 * 3], this.coordsArray[n5 * 3 + 1] - this.coordsArray[n7 * 3 + 1], this.coordsArray[n5 * 3 + 2] - this.coordsArray[n7 * 3 + 2]);
                    vector3f = new Vector3f();
                    vector3f.cross(vector3f2, vector3f3);
                    vector3f.normalize(vector3f);
                }
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n8 = n2 + i3;
                    this.normalCoords[n8 * 3] = vector3f.x;
                    this.normalCoords[n8 * 3 + 1] = vector3f.y;
                    this.normalCoords[n8 * 3 + 2] = vector3f.z;
                    if (this.facetIndices == null) continue;
                    this.normalIndices[n8] = n8;
                }
                n2 += n4;
            }
        }
        this.debugOutputLn(1, "done with calcNormals()");
    }
}

