/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.CubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;

public class CubicSplineCurve {
    private float totalCurveLength;
    private CubicSplineSegment[] cubicSplineSegment;
    public int numSegments;

    CubicSplineCurve() {
        this.numSegments = 0;
        this.totalCurveLength = 0.0f;
    }

    CubicSplineCurve(TCBKeyFrame[] tCBKeyFrameArray) {
        int n2 = tCBKeyFrameArray.length;
        if (n2 < 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("CubicSplineCurve0"));
        }
        this.numSegments = n2 - 3;
        this.cubicSplineSegment = new CubicSplineSegment[this.numSegments];
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        while (n3 < this.numSegments) {
            this.cubicSplineSegment[n3] = new CubicSplineSegment(tCBKeyFrameArray[n3], tCBKeyFrameArray[n4], tCBKeyFrameArray[n5], tCBKeyFrameArray[n6]);
            ++n3;
            ++n4;
            ++n5;
            ++n6;
        }
        this.computeTotalCurveLength();
    }

    CubicSplineCurve(CubicSplineSegment[] cubicSplineSegmentArray) {
        this.cubicSplineSegment = new CubicSplineSegment[cubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i2 = 0; i2 < this.numSegments; ++i2) {
            this.cubicSplineSegment[i2] = cubicSplineSegmentArray[i2];
        }
        this.computeTotalCurveLength();
    }

    public void setSegments(CubicSplineSegment[] cubicSplineSegmentArray) {
        this.cubicSplineSegment = new CubicSplineSegment[cubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i2 = 0; i2 < this.numSegments; ++i2) {
            this.cubicSplineSegment[i2] = cubicSplineSegmentArray[i2];
        }
        this.computeTotalCurveLength();
    }

    public CubicSplineSegment getSegment(int n2) {
        return this.cubicSplineSegment[n2];
    }

    private void computeTotalCurveLength() {
        this.totalCurveLength = 0.0f;
        for (int i2 = 0; i2 < this.numSegments; ++i2) {
            this.totalCurveLength += this.cubicSplineSegment[i2].length;
        }
    }

    public float getTotalCurveLength() {
        return this.totalCurveLength;
    }
}

