/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.utils.behaviors.interpolators.CubicSplineCurve;
import com.sun.j3d.utils.behaviors.interpolators.CubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.TCBSplinePathInterpolator;
import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class RotPosScaleTCBSplinePathInterpolator
extends TCBSplinePathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Matrix4d tMat = new Matrix4d();
    private Matrix4d sMat = new Matrix4d();
    private Quat4f iQuat = new Quat4f();
    private Vector3f iPos = new Vector3f();
    private Point3f iScale = new Point3f();
    CubicSplineCurve cubicSplineCurve = new CubicSplineCurve();
    CubicSplineSegment[] cubicSplineSegments;
    int numSegments;
    int currentSegmentIndex;
    CubicSplineSegment currentSegment;

    RotPosScaleTCBSplinePathInterpolator() {
    }

    public RotPosScaleTCBSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, TCBKeyFrame[] tCBKeyFrameArray) {
        super(alpha, transformGroup, transform3D, tCBKeyFrameArray);
        this.cubicSplineCurve = new CubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public void setAxisOfRotPosScale(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotPosScale() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f2, Transform3D transform3D) {
        this.computePathInterpolation(f2);
        this.currentSegmentIndex = this.lowerKnot - 1;
        if (this.currentSegmentIndex == 0 && this.currentU == 0.0f) {
            this.iQuat.set(this.keyFrames[1].quat);
            this.iPos.set(this.keyFrames[1].position);
            this.iScale.set(this.keyFrames[1].scale);
        } else if (this.currentSegmentIndex == this.numSegments - 1 && (double)this.currentU == 1.0) {
            this.iQuat.set(this.keyFrames[this.upperKnot].quat);
            this.iPos.set(this.keyFrames[this.upperKnot].position);
            this.iScale.set(this.keyFrames[this.upperKnot].scale);
        } else {
            this.currentSegment = this.cubicSplineCurve.getSegment(this.currentSegmentIndex);
            this.currentSegment.getInterpolatedQuaternion(this.currentU, this.iQuat);
            this.currentSegment.getInterpolatedPositionVector(this.currentU, this.iPos);
            this.currentSegment.getInterpolatedScale(this.currentU, this.iScale);
        }
        this.iQuat.normalize();
        this.tMat.set(this.iQuat);
        this.tMat.m03 = this.iPos.x;
        this.tMat.m13 = this.iPos.y;
        this.tMat.m23 = this.iPos.z;
        this.rotation.set(this.tMat);
        transform3D.mul(this.axis, this.rotation);
        transform3D.setScale(new Vector3d(this.iScale));
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        RotPosScaleTCBSplinePathInterpolator rotPosScaleTCBSplinePathInterpolator = new RotPosScaleTCBSplinePathInterpolator();
        rotPosScaleTCBSplinePathInterpolator.duplicateNode(this, bl);
        return rotPosScaleTCBSplinePathInterpolator;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        RotPosScaleTCBSplinePathInterpolator rotPosScaleTCBSplinePathInterpolator = (RotPosScaleTCBSplinePathInterpolator)node;
        this.cubicSplineCurve = new CubicSplineCurve(rotPosScaleTCBSplinePathInterpolator.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }
}

