/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class MouseRotate
extends MouseBehavior {
    double x_angle;
    double y_angle;
    double x_factor = 0.03;
    double y_factor = 0.03;
    private MouseBehaviorCallback callback = null;

    public MouseRotate(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseRotate() {
        super(0);
    }

    public MouseRotate(int n2) {
        super(n2);
    }

    public MouseRotate(Component component) {
        super(component, 0);
    }

    public MouseRotate(Component component, TransformGroup transformGroup) {
        super(component, transformGroup);
    }

    public MouseRotate(Component component, int n2) {
        super(component, n2);
    }

    public void initialize() {
        super.initialize();
        this.x_angle = 0.0;
        this.y_angle = 0.0;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setFactor(double d2) {
        this.x_factor = this.y_factor = d2;
    }

    public void setFactor(double d2, double d3) {
        this.x_factor = d2;
        this.y_factor = d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration enumeration) {
        block3: while (enumeration.hasMoreElements()) {
            MouseEvent mouseEvent;
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (wakeupCriterion instanceof WakeupOnAWTEvent) {
                AWTEvent[] aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
                if (aWTEventArray.length <= 0) continue;
                mouseEvent = (MouseEvent)aWTEventArray[aWTEventArray.length - 1];
                this.doProcess(mouseEvent);
                continue;
            }
            if (!(wakeupCriterion instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    mouseEvent = (MouseEvent)this.mouseq.remove(0);
                    while (mouseEvent.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        mouseEvent = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(mouseEvent);
            }
        }
        this.wakeupOn(this.mouseCriterion);
    }

    void doProcess(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int n2 = mouseEvent.getID();
            if (n2 == 506 && !mouseEvent.isMetaDown() && !mouseEvent.isAltDown()) {
                this.x = mouseEvent.getX();
                this.y = mouseEvent.getY();
                int n3 = this.x - this.x_last;
                int n4 = this.y - this.y_last;
                if (!this.reset) {
                    this.x_angle = (double)n4 * this.y_factor;
                    this.y_angle = (double)n3 * this.x_factor;
                    this.transformX.rotX(this.x_angle);
                    this.transformY.rotY(this.y_angle);
                    this.transformGroup.getTransform(this.currXform);
                    Matrix4d matrix4d = new Matrix4d();
                    this.currXform.get(matrix4d);
                    this.currXform.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                        this.currXform.mul(this.currXform, this.transformY);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                        this.currXform.mul(this.transformY, this.currXform);
                    }
                    Vector3d vector3d = new Vector3d(matrix4d.m03, matrix4d.m13, matrix4d.m23);
                    this.currXform.setTranslation(vector3d);
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(0, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (n2 == 501) {
                this.x_last = mouseEvent.getX();
                this.y_last = mouseEvent.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform3D) {
    }

    public void setupCallback(MouseBehaviorCallback mouseBehaviorCallback) {
        this.callback = mouseBehaviorCallback;
    }
}

