/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.BBox;
import com.sun.j3d.utils.geometry.Distance;
import com.sun.j3d.utils.geometry.Left;
import com.sun.j3d.utils.geometry.NoHash;
import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class Bridge {
    Bridge() {
    }

    static void constructBridges(Triangulator triangulator, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        if (!triangulator.noHashingEdges) {
            System.out.println("Bridge:constructBridges noHashingEdges is false");
        }
        if (n3 <= n2) {
            System.out.println("Bridge:constructBridges loopMax<=loopMin");
        }
        if (n2 < 0) {
            System.out.println("Bridge:constructBridges loopMin<0");
        }
        if (n3 > triangulator.numLoops) {
            System.out.println("Bridge:constructBridges loopMax>triRef.numLoops");
        }
        if ((n5 = n3 - n2 - 1) > triangulator.maxNumLeftMost) {
            triangulator.maxNumLeftMost = n5;
            triangulator.leftMost = new Left[n5];
        }
        Bridge.findLeftMostVertex(triangulator, triangulator.loops[n2], nArray2, nArray);
        int n6 = 0;
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            Bridge.findLeftMostVertex(triangulator, triangulator.loops[i2], nArray6, nArray5);
            triangulator.leftMost[n6] = new Left();
            triangulator.leftMost[n6].ind = nArray6[0];
            triangulator.leftMost[n6].index = nArray5[0];
            ++n6;
        }
        Bridge.sortLeft(triangulator.leftMost, n5);
        triangulator.maxNumDist = n4 = triangulator.numPoints + 2 * triangulator.numLoops;
        triangulator.distances = new Distance[n4];
        for (int i3 = 0; i3 < triangulator.maxNumDist; ++i3) {
            triangulator.distances[i3] = new Distance();
        }
        for (n6 = 0; n6 < n5; ++n6) {
            if (!Bridge.findBridge(triangulator, nArray2[0], nArray[0], triangulator.leftMost[n6].index, nArray4, nArray3)) {
                // empty if block
            }
            if (nArray3[0] == triangulator.leftMost[n6].index) {
                Bridge.simpleBridge(triangulator, nArray4[0], triangulator.leftMost[n6].ind);
                continue;
            }
            Bridge.insertBridge(triangulator, nArray4[0], nArray3[0], triangulator.leftMost[n6].ind, triangulator.leftMost[n6].index);
        }
    }

    static boolean findBridge(Triangulator triangulator, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        BBox bBox;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 0;
        Distance[] distanceArray = null;
        nArray[0] = n2;
        nArray2[0] = n3;
        if (nArray2[0] == n4) {
            return true;
        }
        if (n11 >= triangulator.maxNumDist) {
            triangulator.maxNumDist += 50;
            distanceArray = triangulator.distances;
            triangulator.distances = new Distance[triangulator.maxNumDist];
            System.arraycopy(distanceArray, 0, triangulator.distances, 0, distanceArray.length);
            for (n10 = distanceArray.length; n10 < triangulator.maxNumDist; ++n10) {
                triangulator.distances[n10] = new Distance();
            }
        }
        triangulator.distances[n11].dist = Numerics.baseLength(triangulator.points[n4], triangulator.points[nArray2[0]]);
        triangulator.distances[n11].ind = nArray[0];
        ++n11;
        nArray[0] = triangulator.fetchNextData(nArray[0]);
        nArray2[0] = triangulator.fetchData(nArray[0]);
        while (nArray[0] != n2) {
            if (nArray2[0] == n4) {
                return true;
            }
            if (n11 >= triangulator.maxNumDist) {
                triangulator.maxNumDist += 50;
                distanceArray = triangulator.distances;
                triangulator.distances = new Distance[triangulator.maxNumDist];
                System.arraycopy(distanceArray, 0, triangulator.distances, 0, distanceArray.length);
                for (n10 = distanceArray.length; n10 < triangulator.maxNumDist; ++n10) {
                    triangulator.distances[n10] = new Distance();
                }
            }
            triangulator.distances[n11].dist = Numerics.baseLength(triangulator.points[n4], triangulator.points[nArray2[0]]);
            triangulator.distances[n11].ind = nArray[0];
            ++n11;
            nArray[0] = triangulator.fetchNextData(nArray[0]);
            nArray2[0] = triangulator.fetchData(nArray[0]);
        }
        Bridge.sortDistance(triangulator.distances, n11);
        for (n9 = 0; n9 < n11; ++n9) {
            boolean bl;
            boolean bl2;
            nArray[0] = triangulator.distances[n9].ind;
            nArray2[0] = triangulator.fetchData(nArray[0]);
            if (nArray2[0] > n4 || !(bl2 = Numerics.isInCone(triangulator, n8 = triangulator.fetchData(n7 = triangulator.fetchPrevData(nArray[0])), nArray2[0], n6 = triangulator.fetchData(n5 = triangulator.fetchNextData(nArray[0])), n4, bl = triangulator.getAngle(nArray[0]) > 0)) || NoHash.noHashEdgeIntersectionExists(triangulator, bBox = new BBox(triangulator, nArray2[0], n4), -1, -1, nArray[0], -1)) continue;
            return true;
        }
        for (n9 = 0; n9 < n11; ++n9) {
            nArray[0] = triangulator.distances[n9].ind;
            nArray2[0] = triangulator.fetchData(nArray[0]);
            n7 = triangulator.fetchPrevData(nArray[0]);
            n8 = triangulator.fetchData(n7);
            n5 = triangulator.fetchNextData(nArray[0]);
            n6 = triangulator.fetchData(n5);
            bBox = new BBox(triangulator, nArray2[0], n4);
            if (NoHash.noHashEdgeIntersectionExists(triangulator, bBox, -1, -1, nArray[0], -1)) continue;
            return true;
        }
        nArray[0] = n2;
        nArray2[0] = n3;
        return false;
    }

    static void findLeftMostVertex(Triangulator triangulator, int n2, int[] nArray, int[] nArray2) {
        int n3 = n2;
        int n4 = triangulator.fetchData(n3);
        nArray[0] = n3;
        nArray2[0] = n4;
        n3 = triangulator.fetchNextData(n3);
        n4 = triangulator.fetchData(n3);
        while (n3 != n2) {
            if (n4 < nArray2[0]) {
                nArray[0] = n3;
                nArray2[0] = n4;
            } else if (n4 == nArray2[0] && triangulator.getAngle(n3) < 0) {
                nArray[0] = n3;
                nArray2[0] = n4;
            }
            n3 = triangulator.fetchNextData(n3);
            n4 = triangulator.fetchData(n3);
        }
    }

    static void simpleBridge(Triangulator triangulator, int n2, int n3) {
        triangulator.rotateLinks(n2, n3);
        int n4 = triangulator.fetchData(n2);
        int n5 = triangulator.fetchNextData(n2);
        int n6 = triangulator.fetchData(n5);
        int n7 = triangulator.fetchPrevData(n2);
        int n8 = triangulator.fetchData(n7);
        int n9 = Numerics.isConvexAngle(triangulator, n8, n4, n6, n2);
        triangulator.setAngle(n2, n9);
        int n10 = triangulator.fetchData(n3);
        n5 = triangulator.fetchNextData(n3);
        n6 = triangulator.fetchData(n5);
        n7 = triangulator.fetchPrevData(n3);
        n8 = triangulator.fetchData(n7);
        n9 = Numerics.isConvexAngle(triangulator, n8, n10, n6, n3);
        triangulator.setAngle(n3, n9);
    }

    static void insertBridge(Triangulator triangulator, int n2, int n3, int n4, int n5) {
        int n6 = triangulator.makeNode(n3);
        triangulator.insertAfter(n2, n6);
        int n7 = triangulator.list[n2].getCommonIndex();
        triangulator.list[n6].setCommonIndex(n7);
        int n8 = triangulator.makeNode(n5);
        triangulator.insertAfter(n4, n8);
        n7 = triangulator.list[n4].getCommonIndex();
        triangulator.list[n8].setCommonIndex(n7);
        triangulator.splitSplice(n2, n6, n4, n8);
        int n9 = triangulator.fetchNextData(n2);
        int n10 = triangulator.fetchData(n9);
        int n11 = triangulator.fetchPrevData(n2);
        int n12 = triangulator.fetchData(n11);
        int n13 = Numerics.isConvexAngle(triangulator, n12, n3, n10, n2);
        triangulator.setAngle(n2, n13);
        n9 = triangulator.fetchNextData(n6);
        n10 = triangulator.fetchData(n9);
        n11 = triangulator.fetchPrevData(n6);
        n12 = triangulator.fetchData(n11);
        n13 = Numerics.isConvexAngle(triangulator, n12, n3, n10, n6);
        triangulator.setAngle(n6, n13);
        n9 = triangulator.fetchNextData(n4);
        n10 = triangulator.fetchData(n9);
        n11 = triangulator.fetchPrevData(n4);
        n12 = triangulator.fetchData(n11);
        n13 = Numerics.isConvexAngle(triangulator, n12, n5, n10, n4);
        triangulator.setAngle(n4, n13);
        n9 = triangulator.fetchNextData(n8);
        n10 = triangulator.fetchData(n9);
        n11 = triangulator.fetchPrevData(n8);
        n12 = triangulator.fetchData(n11);
        n13 = Numerics.isConvexAngle(triangulator, n12, n5, n10, n8);
        triangulator.setAngle(n8, n13);
    }

    static int l_comp(Left left, Left left2) {
        if (left.index < left2.index) {
            return -1;
        }
        if (left.index > left2.index) {
            return 1;
        }
        return 0;
    }

    static int d_comp(Distance distance, Distance distance2) {
        if (distance.dist < distance2.dist) {
            return -1;
        }
        if (distance.dist > distance2.dist) {
            return 1;
        }
        return 0;
    }

    static void sortLeft(Left[] leftArray, int n2) {
        Left left = new Left();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                if (Bridge.l_comp(leftArray[i2], leftArray[i3]) <= 0) continue;
                left.copy(leftArray[i2]);
                leftArray[i2].copy(leftArray[i3]);
                leftArray[i3].copy(left);
            }
        }
    }

    static void sortDistance(Distance[] distanceArray, int n2) {
        Distance distance = new Distance();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                if (Bridge.d_comp(distanceArray[i2], distanceArray[i3]) <= 0) continue;
                distance.copy(distanceArray[i2]);
                distanceArray[i2].copy(distanceArray[i3]);
                distanceArray[i3].copy(distance);
            }
        }
    }
}

