/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Quadrics;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;

public class Cone
extends Primitive {
    float radius;
    float height;
    int xdivisions;
    int ydivisions;
    static final int MID_REZ_DIV_X = 15;
    static final int MID_REZ_DIV_Y = 1;
    public static final int BODY = 0;
    public static final int CAP = 1;

    public Cone() {
        this(1.0f, 2.0f, 1, 15, 1, null);
    }

    public Cone(float f2, float f3) {
        this(f2, f3, 1, 15, 1, null);
    }

    public Cone(float f2, float f3, Appearance appearance) {
        this(f2, f3, 1, 15, 1, appearance);
    }

    public Cone(float f2, float f3, int n2, Appearance appearance) {
        this(f2, f3, n2, 15, 1, appearance);
    }

    public Shape3D getShape(int n2) {
        if (n2 > 1 || n2 < 0) {
            return null;
        }
        return (Shape3D)this.getChild(n2);
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
        ((Shape3D)this.getChild(1)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n2) {
        if (n2 > 1 || n2 < 0) {
            return null;
        }
        return this.getShape(n2).getAppearance();
    }

    public Cone(float f2, float f3, int n2, int n3, int n4, Appearance appearance) {
        Shape3D[] shape3DArray = new Shape3D[2];
        this.radius = f2;
        this.height = f3;
        this.xdivisions = n3;
        this.ydivisions = n4;
        this.flags = n2;
        boolean bl = (this.flags & 4) == 0;
        boolean bl2 = (this.flags & 8) != 0;
        Quadrics quadrics = new Quadrics();
        GeomBuffer geomBuffer = null;
        GeomBuffer geomBuffer2 = this.getCachedGeometry(4, f2, 0.0f, f3, n3, n4, n2);
        if (geomBuffer2 != null) {
            shape3DArray[0] = new Shape3D(geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.coneTop((double)f3 / 2.0 - (double)(f3 / (float)this.ydivisions), f2 / (float)this.ydivisions, f3 / (float)this.ydivisions, this.xdivisions, 1.0 - 1.0 / (double)this.ydivisions, bl, bl2);
            shape3DArray[0] = new Shape3D(geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n2 & 0x10) == 0) {
                this.cacheGeometry(4, f2, 0.0f, f3, n3, n4, n2, geomBuffer);
            }
        }
        if (this.ydivisions > 1) {
            geomBuffer2 = this.getCachedGeometry(64, f2, 0.0f, f3, n3, n4, n2);
            if (geomBuffer2 != null) {
                shape3DArray[0].addGeometry(geomBuffer2.getComputedGeometry());
                this.numVerts += geomBuffer2.getNumVerts();
                this.numTris += geomBuffer2.getNumTris();
            } else {
                geomBuffer = quadrics.coneBody(-((double)f3 / 2.0), (double)f3 / 2.0 - (double)(f3 / (float)this.ydivisions), f2, f2 / (float)this.ydivisions, this.xdivisions, this.ydivisions - 1, 1.0 / (double)this.ydivisions, bl, bl2);
                shape3DArray[0].addGeometry(geomBuffer.getGeom(this.flags));
                this.numVerts += geomBuffer.getNumVerts();
                this.numTris += geomBuffer.getNumTris();
                if ((n2 & 0x10) == 0) {
                    this.cacheGeometry(64, f2, 0.0f, f3, n3, n4, n2, geomBuffer);
                }
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[0].setCapability(14);
            shape3DArray[0].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[0].setCapability(12);
        }
        this.addChild(shape3DArray[0]);
        geomBuffer2 = this.getCachedGeometry(32, f2, f2, -f3 / 2.0f, n3, n3, n2);
        if (geomBuffer2 != null) {
            shape3DArray[1] = new Shape3D(geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.disk(f2, n3, -((double)f3) / 2.0, !bl, bl2);
            shape3DArray[1] = new Shape3D(geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n2 & 0x10) == 0) {
                this.cacheGeometry(32, f2, f2, -f3 / 2.0f, n3, n3, n2, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[1].setCapability(14);
            shape3DArray[1].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[1].setCapability(12);
        }
        this.addChild(shape3DArray[1]);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Node cloneNode(boolean bl) {
        Cone cone = new Cone(this.radius, this.height, this.flags, this.xdivisions, this.ydivisions, this.getAppearance());
        cone.duplicateNode(this, bl);
        return cone;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getXdivisions() {
        return this.xdivisions;
    }

    public int getYdivisions() {
        return this.ydivisions;
    }
}

