/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.BBox;
import com.sun.j3d.utils.geometry.BottleNeck;
import com.sun.j3d.utils.geometry.Degenerate;
import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.PntNode;
import com.sun.j3d.utils.geometry.Triangulator;

class NoHash {
    static final int NIL = -1;

    NoHash() {
    }

    static void insertAfterVtx(Triangulator triangulator, int n2) {
        if (triangulator.vtxList == null) {
            int n3 = Math.max(triangulator.numVtxList + 1, 100);
            triangulator.vtxList = new PntNode[n3];
        } else if (triangulator.numVtxList >= triangulator.vtxList.length) {
            int n4 = Math.max(triangulator.numVtxList + 1, triangulator.vtxList.length + 100);
            PntNode[] pntNodeArray = triangulator.vtxList;
            triangulator.vtxList = new PntNode[n4];
            System.arraycopy(pntNodeArray, 0, triangulator.vtxList, 0, pntNodeArray.length);
        }
        triangulator.vtxList[triangulator.numVtxList] = new PntNode();
        triangulator.vtxList[triangulator.numVtxList].pnt = n2;
        triangulator.vtxList[triangulator.numVtxList].next = triangulator.reflexVertices;
        triangulator.reflexVertices = triangulator.numVtxList++;
        ++triangulator.numReflex;
    }

    static void deleteFromList(Triangulator triangulator, int n2) {
        int n3;
        if (triangulator.numReflex == 0) {
            return;
        }
        int n4 = triangulator.reflexVertices;
        if (!NoHash.inVtxList(triangulator, n4)) {
            System.out.println("NoHash:deleteFromList. Problem :Not is InVtxList ..." + n4);
        }
        if ((n3 = triangulator.vtxList[n4].pnt) == n2) {
            triangulator.reflexVertices = triangulator.vtxList[n4].next;
            --triangulator.numReflex;
        } else {
            int n5 = triangulator.vtxList[n4].next;
            while (n5 != -1) {
                if (!NoHash.inVtxList(triangulator, n5)) {
                    System.out.println("NoHash:deleteFromList. Problem :Not is InVtxList ..." + n5);
                }
                if ((n3 = triangulator.vtxList[n5].pnt) == n2) {
                    triangulator.vtxList[n4].next = triangulator.vtxList[n5].next;
                    n5 = -1;
                    --triangulator.numReflex;
                    continue;
                }
                n4 = n5;
                n5 = triangulator.vtxList[n4].next;
            }
        }
    }

    static boolean inVtxList(Triangulator triangulator, int n2) {
        return 0 <= n2 && n2 < triangulator.numVtxList;
    }

    static void freeNoHash(Triangulator triangulator) {
        triangulator.noHashingEdges = false;
        triangulator.noHashingPnts = false;
        triangulator.numVtxList = 0;
    }

    static void prepareNoHashEdges(Triangulator triangulator, int n2, int n3) {
        triangulator.loopMin = n2;
        triangulator.loopMax = n3;
        triangulator.noHashingEdges = true;
    }

    static void prepareNoHashPnts(Triangulator triangulator, int n2) {
        int n3;
        triangulator.numVtxList = 0;
        triangulator.reflexVertices = -1;
        int n4 = n3 = triangulator.loops[n2];
        triangulator.numReflex = 0;
        int n5 = triangulator.fetchData(n4);
        do {
            if (triangulator.getAngle(n4) < 0) {
                NoHash.insertAfterVtx(triangulator, n4);
            }
            n4 = triangulator.fetchNextData(n4);
            n5 = triangulator.fetchData(n4);
        } while (n4 != n3);
        triangulator.noHashingPnts = true;
    }

    static boolean noHashIntersectionExists(Triangulator triangulator, int n2, int n3, int n4, int n5, BBox bBox) {
        int[] nArray = new int[1];
        if (!triangulator.noHashingPnts) {
            System.out.println("NoHash:noHashIntersectionExists noHashingPnts is false");
        }
        if (triangulator.numReflex <= 0) {
            return false;
        }
        if (n2 < bBox.imin) {
            bBox.imin = n2;
        } else if (n2 > bBox.imax) {
            bBox.imax = n2;
        }
        double d2 = triangulator.points[n2].y;
        if (d2 < bBox.ymin) {
            bBox.ymin = d2;
        } else if (d2 > bBox.ymax) {
            bBox.ymax = d2;
        }
        int n6 = triangulator.reflexVertices;
        boolean bl = false;
        do {
            int n7;
            int n8;
            if (!bBox.pntInBBox(triangulator, n8 = triangulator.fetchData(n7 = triangulator.vtxList[n6].pnt))) continue;
            int n9 = triangulator.fetchNextData(n7);
            int n10 = triangulator.fetchData(n9);
            if (n7 == n3 || n7 == n9 || !(n8 == n2 ? Degenerate.handleDegeneracies(triangulator, n2, n3, n4, n5, n8, n7) : n8 != n4 && n8 != n5 && (bl = Numerics.vtxInTriangle(triangulator, n2, n4, n5, n8, nArray)))) continue;
            return true;
        } while ((n6 = triangulator.vtxList[n6].next) != -1);
        return false;
    }

    static void deleteReflexVertex(Triangulator triangulator, int n2) {
        NoHash.deleteFromList(triangulator, n2);
    }

    static boolean noHashEdgeIntersectionExists(Triangulator triangulator, BBox bBox, int n2, int n3, int n4, int n5) {
        if (!triangulator.noHashingEdges) {
            System.out.println("NoHash:noHashEdgeIntersectionExists noHashingEdges is false");
        }
        triangulator.identCntr = 0;
        for (int i2 = triangulator.loopMin; i2 < triangulator.loopMax; ++i2) {
            int n6;
            int n7 = n6 = triangulator.loops[i2];
            int n8 = triangulator.fetchData(n7);
            do {
                int n9;
                BBox bBox2;
                if (bBox.BBoxOverlap(bBox2 = new BBox(triangulator, n8, n9 = triangulator.fetchData(n7 = triangulator.fetchNextData(n7)))) && Numerics.segIntersect(triangulator, bBox.imin, bBox.imax, bBox2.imin, bBox2.imax, n5)) {
                    return true;
                }
                n8 = n9;
            } while (n7 != n6);
        }
        if (triangulator.identCntr >= 4) {
            return BottleNeck.checkBottleNeck(triangulator, n5, n2, n3, n4);
        }
        return false;
    }
}

