/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.CommandStream;
import com.sun.j3d.utils.geometry.compression.CompressionStream;
import com.sun.j3d.utils.geometry.compression.CompressionStreamColor;
import com.sun.j3d.utils.geometry.compression.CompressionStreamElement;
import com.sun.j3d.utils.geometry.compression.CompressionStreamNormal;
import com.sun.j3d.utils.geometry.compression.HuffmanNode;
import com.sun.j3d.utils.geometry.compression.HuffmanTable;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class CompressionStreamVertex
extends CompressionStreamElement {
    private int X;
    private int Y;
    private int Z;
    private int meshFlag;
    private int stripFlag;
    private float floatX;
    private float floatY;
    private float floatZ;
    int xAbsolute;
    int yAbsolute;
    int zAbsolute;
    CompressionStreamColor color = null;
    CompressionStreamNormal normal = null;

    CompressionStreamVertex(CompressionStream compressionStream, Point3f point3f, Vector3f vector3f, Color3f color3f, int n2, int n3) {
        this(compressionStream, point3f, vector3f, n2, n3);
        if (compressionStream.vertexColor3) {
            this.color = new CompressionStreamColor(compressionStream, color3f);
        }
    }

    CompressionStreamVertex(CompressionStream compressionStream, Point3f point3f, Vector3f vector3f, Color4f color4f, int n2, int n3) {
        this(compressionStream, point3f, vector3f, n2, n3);
        if (compressionStream.vertexColor4) {
            this.color = new CompressionStreamColor(compressionStream, color4f);
        }
    }

    CompressionStreamVertex(CompressionStream compressionStream, Point3f point3f, Vector3f vector3f, int n2, int n3) {
        this.stripFlag = n2;
        this.meshFlag = n3;
        this.floatX = point3f.x;
        this.floatY = point3f.y;
        this.floatZ = point3f.z;
        compressionStream.byteCount += 12;
        ++compressionStream.vertexCount;
        if ((double)point3f.x < compressionStream.mcBounds[0].x) {
            compressionStream.mcBounds[0].x = point3f.x;
        }
        if ((double)point3f.y < compressionStream.mcBounds[0].y) {
            compressionStream.mcBounds[0].y = point3f.y;
        }
        if ((double)point3f.z < compressionStream.mcBounds[0].z) {
            compressionStream.mcBounds[0].z = point3f.z;
        }
        if ((double)point3f.x > compressionStream.mcBounds[1].x) {
            compressionStream.mcBounds[1].x = point3f.x;
        }
        if ((double)point3f.y > compressionStream.mcBounds[1].y) {
            compressionStream.mcBounds[1].y = point3f.y;
        }
        if ((double)point3f.z > compressionStream.mcBounds[1].z) {
            compressionStream.mcBounds[1].z = point3f.z;
        }
        if (compressionStream.vertexNormals) {
            this.normal = new CompressionStreamNormal(compressionStream, vector3f);
        }
    }

    void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
        int n2 = compressionStream.positionQuant < 1 ? 1 : (compressionStream.positionQuant > 16 ? 16 : compressionStream.positionQuant);
        this.absolute = false;
        if (compressionStream.firstPosition || compressionStream.positionQuantChanged) {
            this.absolute = true;
            compressionStream.lastPosition[0] = 0;
            compressionStream.lastPosition[1] = 0;
            compressionStream.lastPosition[2] = 0;
            compressionStream.firstPosition = false;
            compressionStream.positionQuantChanged = false;
        }
        double d2 = ((double)this.floatX - compressionStream.center[0]) * compressionStream.scale;
        double d3 = ((double)this.floatY - compressionStream.center[1]) * compressionStream.scale;
        double d4 = ((double)this.floatZ - compressionStream.center[2]) * compressionStream.scale;
        this.X = (int)(d2 * 32768.0);
        this.Y = (int)(d3 * 32768.0);
        this.Z = (int)(d4 * 32768.0);
        this.X &= quantizationMask[n2];
        this.Y &= quantizationMask[n2];
        this.Z &= quantizationMask[n2];
        if (this.X < compressionStream.qcBounds[0].x) {
            compressionStream.qcBounds[0].x = this.X;
        }
        if (this.Y < compressionStream.qcBounds[0].y) {
            compressionStream.qcBounds[0].y = this.Y;
        }
        if (this.Z < compressionStream.qcBounds[0].z) {
            compressionStream.qcBounds[0].z = this.Z;
        }
        if (this.X > compressionStream.qcBounds[1].x) {
            compressionStream.qcBounds[1].x = this.X;
        }
        if (this.Y > compressionStream.qcBounds[1].y) {
            compressionStream.qcBounds[1].y = this.Y;
        }
        if (this.Z > compressionStream.qcBounds[1].z) {
            compressionStream.qcBounds[1].z = this.Z;
        }
        this.xAbsolute = this.X;
        this.yAbsolute = this.Y;
        this.zAbsolute = this.Z;
        this.X -= compressionStream.lastPosition[0];
        this.Y -= compressionStream.lastPosition[1];
        this.Z -= compressionStream.lastPosition[2];
        compressionStream.lastPosition[0] = compressionStream.lastPosition[0] + this.X;
        compressionStream.lastPosition[1] = compressionStream.lastPosition[1] + this.Y;
        compressionStream.lastPosition[2] = compressionStream.lastPosition[2] + this.Z;
        this.X = this.X << 16 >> 16;
        this.Y = this.Y << 16 >> 16;
        this.Z = this.Z << 16 >> 16;
        this.computeLengthShift(this.X, this.Y, this.Z);
        if (this.length == 0) {
            this.length = 1;
        }
        huffmanTable.addPositionEntry(this.length, this.shift, this.absolute);
        if (this.color != null) {
            this.color.quantize(compressionStream, huffmanTable);
        }
        if (this.normal != null) {
            this.normal.quantize(compressionStream, huffmanTable);
        }
        if (this.meshFlag == 1) {
            compressionStream.meshBuffer.push(this);
        }
    }

    void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        int n2 = 64;
        HuffmanNode huffmanNode = huffmanTable.getPositionEntry(this.length, this.shift, this.absolute);
        int n3 = huffmanNode.dataLength - huffmanNode.shift;
        int n4 = huffmanNode.tagLength + 3 * n3;
        this.X = this.X >> huffmanNode.shift & (int)lengthMask[n3];
        this.Y = this.Y >> huffmanNode.shift & (int)lengthMask[n3];
        this.Z = this.Z >> huffmanNode.shift & (int)lengthMask[n3];
        long l2 = (long)huffmanNode.tag << 3 * n3 | (long)this.X << 2 * n3 | (long)this.Y << 1 * n3 | (long)this.Z << 0 * n3;
        if (n4 < 6) {
            n2 |= (int)(l2 << 6 - n4);
            n4 = 0;
        } else {
            n2 |= (int)(l2 >>> n4 - 6);
            n4 -= 6;
        }
        long l3 = (long)this.stripFlag << n4 + 1 | (long)this.meshFlag << n4 + 0 | l2 & lengthMask[n4];
        commandStream.addCommand(n2, 8, l3, n4 + 3);
        if (this.normal != null) {
            this.normal.outputSubcommand(huffmanTable, commandStream);
        }
        if (this.color != null) {
            this.color.outputSubcommand(huffmanTable, commandStream);
        }
    }

    public String toString() {
        String string = this.absolute ? "" : "delta ";
        String string2 = this.color == null ? "" : "\n\n " + this.color.toString();
        String string3 = this.normal == null ? "" : "\n\n " + this.normal.toString();
        return "position: " + this.floatX + " " + this.floatY + " " + this.floatZ + "\n" + "fixed point " + string + this.X + " " + this.Y + " " + this.Z + "\n" + "length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative") + "\n" + "strip flag " + this.stripFlag + " mesh flag " + this.meshFlag + string2 + string3;
    }
}

