/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.CommandStream;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryData;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryFile;
import com.sun.j3d.utils.geometry.compression.CompressionStream;
import com.sun.j3d.utils.geometry.compression.HuffmanTable;
import java.io.IOException;
import javax.vecmath.Point3d;

public class GeometryCompressor {
    private static final boolean benchmark = false;
    private static final boolean printStream = false;
    private static final boolean printHuffman = false;
    private HuffmanTable huffmanTable;
    private CommandStream outputBuffer;
    private CompressedGeometryData.Header cgHeader = new CompressedGeometryData.Header();
    private long startTime;

    public GeometryCompressor() {
        this.cgHeader.majorVersionNumber = 1;
        this.cgHeader.minorVersionNumber = 0;
        this.cgHeader.minorMinorVersionNumber = 2;
    }

    public CompressedGeometryData compress(CompressionStream compressionStream) {
        this.compressStream(compressionStream);
        CompressedGeometryData compressedGeometryData = new CompressedGeometryData(this.cgHeader, this.outputBuffer.getBytes());
        this.outputBuffer.clear();
        return compressedGeometryData;
    }

    public void compress(CompressionStream compressionStream, CompressedGeometryFile compressedGeometryFile) throws IOException {
        this.compressStream(compressionStream);
        compressedGeometryFile.write(this.cgHeader, this.outputBuffer.getBytes());
        this.outputBuffer.clear();
    }

    private void compressStream(CompressionStream compressionStream) {
        this.huffmanTable = new HuffmanTable();
        compressionStream.quantize(this.huffmanTable);
        this.huffmanTable.computeTags();
        this.outputBuffer = new CommandStream(compressionStream.getByteCount() / 3);
        compressionStream.outputCommands(this.huffmanTable, this.outputBuffer);
        this.cgHeader.bufferType = compressionStream.streamType;
        this.cgHeader.bufferDataPresent = 0;
        this.cgHeader.lowerBound = new Point3d(compressionStream.ncBounds[0]);
        this.cgHeader.upperBound = new Point3d(compressionStream.ncBounds[1]);
        if (compressionStream.vertexNormals) {
            this.cgHeader.bufferDataPresent |= 1;
        }
        if (compressionStream.vertexColor3 || compressionStream.vertexColor4) {
            this.cgHeader.bufferDataPresent |= 2;
        }
        if (compressionStream.vertexColor4) {
            this.cgHeader.bufferDataPresent |= 4;
        }
        this.cgHeader.start = 0;
        this.cgHeader.size = this.outputBuffer.getByteCount();
        this.huffmanTable.clear();
    }

    private void printBench(CompressionStream compressionStream) {
        long l2 = System.currentTimeMillis() - this.startTime;
        int n2 = compressionStream.getVertexCount();
        int n3 = compressionStream.getMeshReferenceCount();
        int n4 = n3 + n2;
        float f2 = 100.0f * (float)n3 / (float)n4;
        float f3 = (float)compressionStream.getByteCount() / (float)this.outputBuffer.getByteCount();
        int n5 = 12 + (compressionStream.vertexColor3 ? 12 : 0) + (compressionStream.vertexColor4 ? 16 : 0) + (compressionStream.vertexNormals ? 12 : 0);
        float f4 = (float)this.outputBuffer.getByteCount() / (float)n4;
        System.out.println("\nGeometryCompressor:\n" + n4 + " total vertices\n" + n2 + " streamed vertices\n" + n3 + " mesh buffer references (" + f2 + "%)\n" + compressionStream.getByteCount() + " bytes streamed geometry compressed to " + this.outputBuffer.getByteCount() + " in " + (float)l2 / 1000.0f + " sec\n" + (float)compressionStream.getByteCount() / (float)l2 + " kbytes/sec, " + "stream compression ratio " + f3 + "\n\n" + n5 + " original bytes per vertex, " + f4 + " compressed bytes per vertex\n" + "total vertex compression ratio " + (float)n5 / f4 + "\n\n" + "lower bound " + compressionStream.ncBounds[0].toString() + "\n" + "upper bound " + compressionStream.ncBounds[1].toString());
    }
}

