/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.pickfast;

import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.PickInfo;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class PickIntersection {
    private double[] interpWeights;
    private static final boolean debug = false;
    private static final int X_AXIS = 1;
    private static final int Y_AXIS = 2;
    private static final int Z_AXIS = 3;
    static final double TOL = 1.0E-5;
    private PickInfo.IntersectionInfo iInfo = null;
    private Transform3D l2vw = null;
    private Geometry geometry = null;
    private boolean geometryIsIndexed = false;
    private double distance;
    private boolean hasColors;
    private boolean hasNormals;
    private boolean hasTexCoords;
    private int[] primitiveCoordinateIndices;
    private int[] primitiveNormalIndices;
    private int[] primitiveColorIndices;
    private int[] primitiveTexCoordIndices;
    private int[] primitiveVertexIndices = null;
    private Point3d[] primitiveCoordinates = null;
    private Point3d[] primitiveCoordinatesVW = null;
    private Vector3f[] primitiveNormals = null;
    private Color4f[] primitiveColors = null;
    private TexCoord3f[] primitiveTexCoords = null;
    private Point3d pointCoordinatesVW = null;
    private Point3d pointCoordinates = null;
    private Vector3f pointNormal = null;
    private Color4f pointColor = null;
    private TexCoord3f pointTexCoord = null;
    private int closestVertexIndex = -1;
    private Point3d closestVertexCoordinates = null;
    private Point3d closestVertexCoordinatesVW = null;

    public PickIntersection(Transform3D transform3D, PickInfo.IntersectionInfo intersectionInfo) {
        this.l2vw = transform3D;
        this.iInfo = intersectionInfo;
        this.geometry = this.iInfo.getGeometry();
        this.pointCoordinates = this.iInfo.getIntersectionPoint();
        this.distance = this.iInfo.getDistance();
        this.primitiveVertexIndices = this.iInfo.getVertexIndices();
        if (this.geometry instanceof GeometryArray) {
            int n2 = ((GeometryArray)this.geometry).getVertexFormat();
            this.hasColors = 0 != (n2 & 0xC);
            this.hasNormals = 0 != (n2 & 2);
            boolean bl = this.hasTexCoords = 0 != (n2 & 0x60);
            if (this.geometry instanceof IndexedGeometryArray) {
                this.geometryIsIndexed = true;
            }
        }
    }

    public boolean geometryIsIndexed() {
        return this.geometryIsIndexed;
    }

    public Point3d getClosestVertexCoordinates() {
        GeometryArray geometryArray = (GeometryArray)this.geometry;
        if (this.closestVertexCoordinates == null) {
            int n2 = this.getClosestVertexIndex();
            int n3 = geometryArray.getVertexFormat();
            int[] nArray = this.getPrimitiveCoordinateIndices();
            if ((n3 & 0x80) == 0) {
                this.closestVertexCoordinates = new Point3d();
                geometryArray.getCoordinate(nArray[n2], this.closestVertexCoordinates);
            } else if ((n3 & 0x100) == 0) {
                double[] dArray = geometryArray.getCoordRefDouble();
                if (dArray == null) {
                    float[] fArray = geometryArray.getCoordRefFloat();
                    if (fArray == null) {
                        throw new UnsupportedOperationException("Deprecated : BY_REF - p3f and p3d");
                    }
                    int n4 = nArray[n2] * 3;
                    this.closestVertexCoordinates = new Point3d(fArray[n4], fArray[n4 + 1], fArray[n4 + 2]);
                } else {
                    int n5 = nArray[n2] * 3;
                    this.closestVertexCoordinates = new Point3d(dArray[n5], dArray[n5 + 1], dArray[n5 + 2]);
                }
            } else {
                float[] fArray = geometryArray.getInterleavedVertices();
                int n6 = this.getInterleavedVertexOffset(geometryArray);
                int n7 = n6 + 3;
                int n8 = n7 * nArray[n2] + n6;
                this.closestVertexCoordinates = new Point3d(fArray[n8], fArray[n8 + 1], fArray[n8 + 2]);
            }
        }
        return this.closestVertexCoordinates;
    }

    public Point3d getClosestVertexCoordinatesVW() {
        if (this.closestVertexCoordinatesVW == null) {
            int n2 = this.getClosestVertexIndex();
            Point3d[] point3dArray = this.getPrimitiveCoordinatesVW();
            this.closestVertexCoordinatesVW = point3dArray[n2];
        }
        return this.closestVertexCoordinatesVW;
    }

    public int getClosestVertexIndex() {
        if (this.closestVertexIndex == -1) {
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            int n2 = -1;
            this.primitiveCoordinates = this.getPrimitiveCoordinates();
            assert (this.primitiveCoordinates != null);
            for (int i2 = 0; i2 < this.primitiveCoordinates.length; ++i2) {
                d3 = this.pointCoordinates.distance(this.primitiveCoordinates[i2]);
                if (!(d3 < d2)) continue;
                n2 = i2;
                d2 = d3;
            }
            this.closestVertexIndex = n2;
        }
        return this.closestVertexIndex;
    }

    public double getDistance() {
        return this.distance;
    }

    public Color4f getPointColor() {
        if (this.hasColors && this.pointColor == null) {
            double[] dArray = this.getInterpWeights();
            Color4f[] color4fArray = this.getPrimitiveColors();
            this.pointColor = new Color4f();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.pointColor.x += (float)dArray[i2] * color4fArray[i2].x;
                this.pointColor.y += (float)dArray[i2] * color4fArray[i2].y;
                this.pointColor.z += (float)dArray[i2] * color4fArray[i2].z;
                this.pointColor.w += (float)dArray[i2] * color4fArray[i2].w;
            }
        }
        return this.pointColor;
    }

    public Point3d getPointCoordinates() {
        return this.pointCoordinates;
    }

    public Point3d getPointCoordinatesVW() {
        if (this.pointCoordinatesVW != null) {
            return this.pointCoordinatesVW;
        }
        this.pointCoordinatesVW = new Point3d();
        this.pointCoordinatesVW.x = this.pointCoordinates.x;
        this.pointCoordinatesVW.y = this.pointCoordinates.y;
        this.pointCoordinatesVW.z = this.pointCoordinates.z;
        this.l2vw.transform(this.pointCoordinatesVW);
        return this.pointCoordinatesVW;
    }

    public Vector3f getPointNormal() {
        if (this.hasNormals && this.pointNormal == null) {
            double[] dArray = this.getInterpWeights();
            Vector3f[] vector3fArray = this.getPrimitiveNormals();
            this.pointNormal = new Vector3f();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.pointNormal.x += (float)dArray[i2] * vector3fArray[i2].x;
                this.pointNormal.y += (float)dArray[i2] * vector3fArray[i2].y;
                this.pointNormal.z += (float)dArray[i2] * vector3fArray[i2].z;
            }
        }
        return this.pointNormal;
    }

    public TexCoord3f getPointTextureCoordinate(int n2) {
        if (this.hasTexCoords && this.pointTexCoord == null) {
            double[] dArray = this.getInterpWeights();
            TexCoord3f[] texCoord3fArray = this.getPrimitiveTexCoords(n2);
            this.pointTexCoord = new TexCoord3f();
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.pointTexCoord.x += (float)dArray[i2] * texCoord3fArray[i2].x;
                this.pointTexCoord.y += (float)dArray[i2] * texCoord3fArray[i2].y;
                this.pointTexCoord.z += (float)dArray[i2] * texCoord3fArray[i2].z;
            }
        }
        return this.pointTexCoord;
    }

    public int[] getPrimitiveColorIndices() {
        if (this.hasColors && this.primitiveColorIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveColorIndices = new int[this.primitiveVertexIndices.length];
                for (int i2 = 0; i2 < this.primitiveVertexIndices.length; ++i2) {
                    this.primitiveColorIndices[i2] = ((IndexedGeometryArray)this.geometry).getColorIndex(this.primitiveVertexIndices[i2]);
                }
            } else {
                this.primitiveColorIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveColorIndices;
    }

    public Color4f[] getPrimitiveColors() {
        block20: {
            GeometryArray geometryArray = (GeometryArray)this.geometry;
            if (!this.hasColors || this.primitiveColors != null) break block20;
            this.primitiveColors = new Color4f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveColorIndices();
            int n2 = geometryArray.getVertexFormat();
            if ((n2 & 0x80) == 0) {
                if ((n2 & 0xC) == 12) {
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        this.primitiveColors[i2] = new Color4f();
                        geometryArray.getColor(nArray[i2], this.primitiveColors[i2]);
                    }
                } else {
                    Color3f color3f = new Color3f();
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        this.primitiveColors[i3] = new Color4f();
                        geometryArray.getColor(nArray[i3], color3f);
                        this.primitiveColors[i3].x = color3f.x;
                        this.primitiveColors[i3].y = color3f.y;
                        this.primitiveColors[i3].z = color3f.z;
                        this.primitiveColors[i3].w = 1.0f;
                    }
                }
            } else if ((n2 & 0x100) == 0) {
                float[] fArray = geometryArray.getColorRefFloat();
                if (fArray == null) {
                    byte[] byArray = geometryArray.getColorRefByte();
                    if (byArray == null) {
                        throw new UnsupportedOperationException("Deprecated : BY_REF - c3b and c3f");
                    }
                    if ((n2 & 0xC) == 12) {
                        for (int i4 = 0; i4 < nArray.length; ++i4) {
                            int n3 = nArray[i4] << 2;
                            this.primitiveColors[i4] = new Color4f(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], byArray[n3 + 3]);
                        }
                    } else {
                        for (int i5 = 0; i5 < nArray.length; ++i5) {
                            int n4 = nArray[i5] * 3;
                            this.primitiveColors[i5] = new Color4f(byArray[n4], byArray[n4 + 1], byArray[n4 + 2], 1.0f);
                        }
                    }
                } else if ((n2 & 0xC) == 12) {
                    for (int i6 = 0; i6 < nArray.length; ++i6) {
                        int n5 = nArray[i6] << 2;
                        this.primitiveColors[i6] = new Color4f(fArray[n5], fArray[n5 + 1], fArray[n5 + 2], fArray[n5 + 3]);
                    }
                } else {
                    for (int i7 = 0; i7 < nArray.length; ++i7) {
                        int n6 = nArray[i7] * 3;
                        this.primitiveColors[i7] = new Color4f(fArray[n6], fArray[n6 + 1], fArray[n6 + 2], 1.0f);
                    }
                }
            } else {
                float[] fArray = geometryArray.getInterleavedVertices();
                int n7 = this.getInterleavedColorOffset(geometryArray);
                int n8 = this.getInterleavedStride(geometryArray);
                for (int i8 = 0; i8 < nArray.length; ++i8) {
                    int n9 = n8 * nArray[i8] + n7;
                    this.primitiveColors[i8] = (n2 & 0xC) == 12 ? new Color4f(fArray[n9], fArray[n9 + 1], fArray[n9 + 2], fArray[n9 + 3]) : new Color4f(fArray[n9], fArray[n9 + 1], fArray[n9 + 2], 1.0f);
                }
            }
        }
        return this.primitiveColors;
    }

    public int[] getPrimitiveCoordinateIndices() {
        if (this.primitiveCoordinateIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveCoordinateIndices = new int[this.primitiveVertexIndices.length];
                for (int i2 = 0; i2 < this.primitiveVertexIndices.length; ++i2) {
                    this.primitiveCoordinateIndices[i2] = ((IndexedGeometryArray)this.geometry).getCoordinateIndex(this.primitiveVertexIndices[i2]);
                }
            } else {
                this.primitiveCoordinateIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveCoordinateIndices;
    }

    public Point3d[] getPrimitiveCoordinates() {
        block11: {
            GeometryArray geometryArray = (GeometryArray)this.geometry;
            if (this.primitiveCoordinates != null) break block11;
            this.primitiveCoordinates = new Point3d[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveCoordinateIndices();
            int n2 = geometryArray.getVertexFormat();
            if ((n2 & 0x80) == 0) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this.primitiveCoordinates[i2] = new Point3d();
                    geometryArray.getCoordinate(nArray[i2], this.primitiveCoordinates[i2]);
                }
            } else if ((n2 & 0x100) == 0) {
                double[] dArray = geometryArray.getCoordRefDouble();
                if (dArray == null) {
                    float[] fArray = geometryArray.getCoordRefFloat();
                    if (fArray == null) {
                        throw new UnsupportedOperationException("Deprecated : BY_REF - c3f and c3d");
                    }
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        int n3 = nArray[i3] * 3;
                        this.primitiveCoordinates[i3] = new Point3d(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
                    }
                } else {
                    for (int i4 = 0; i4 < nArray.length; ++i4) {
                        int n4 = nArray[i4] * 3;
                        this.primitiveCoordinates[i4] = new Point3d(dArray[n4], dArray[n4 + 1], dArray[n4 + 2]);
                    }
                }
            } else {
                float[] fArray = geometryArray.getInterleavedVertices();
                int n5 = this.getInterleavedVertexOffset(geometryArray);
                int n6 = n5 + 3;
                for (int i5 = 0; i5 < nArray.length; ++i5) {
                    int n7 = n6 * nArray[i5] + n5;
                    this.primitiveCoordinates[i5] = new Point3d(fArray[n7], fArray[n7 + 1], fArray[n7 + 2]);
                }
            }
        }
        return this.primitiveCoordinates;
    }

    public Point3d[] getPrimitiveCoordinatesVW() {
        if (this.primitiveCoordinatesVW == null) {
            Point3d[] point3dArray = this.getPrimitiveCoordinates();
            this.primitiveCoordinatesVW = new Point3d[point3dArray.length];
            for (int i2 = 0; i2 < point3dArray.length; ++i2) {
                this.primitiveCoordinatesVW[i2] = new Point3d();
                this.primitiveCoordinatesVW[i2].x = point3dArray[i2].x;
                this.primitiveCoordinatesVW[i2].y = point3dArray[i2].y;
                this.primitiveCoordinatesVW[i2].z = point3dArray[i2].z;
                this.l2vw.transform(this.primitiveCoordinatesVW[i2]);
            }
        }
        return this.primitiveCoordinatesVW;
    }

    public int[] getPrimitiveNormalIndices() {
        if (this.hasNormals && this.primitiveNormalIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveNormalIndices = new int[this.primitiveVertexIndices.length];
                for (int i2 = 0; i2 < this.primitiveVertexIndices.length; ++i2) {
                    this.primitiveNormalIndices[i2] = ((IndexedGeometryArray)this.geometry).getNormalIndex(this.primitiveVertexIndices[i2]);
                }
            } else {
                this.primitiveNormalIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveNormalIndices;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector3f[] getPrimitiveNormals() {
        GeometryArray geometryArray = (GeometryArray)this.geometry;
        if (!this.hasNormals || this.primitiveNormals != null) return this.primitiveNormals;
        this.primitiveNormals = new Vector3f[this.primitiveVertexIndices.length];
        int[] nArray = this.getPrimitiveNormalIndices();
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 0x80) == 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.primitiveNormals[i2] = new Vector3f();
                geometryArray.getNormal(nArray[i2], this.primitiveNormals[i2]);
            }
            return this.primitiveNormals;
        } else if ((n2 & 0x100) == 0) {
            float[] fArray = geometryArray.getNormalRefFloat();
            if (fArray == null) throw new UnsupportedOperationException("Deprecated : BY_REF - n3f");
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n3 = nArray[i3] * 3;
                this.primitiveNormals[i3] = new Vector3f(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
            }
            return this.primitiveNormals;
        } else {
            float[] fArray = geometryArray.getInterleavedVertices();
            int n4 = this.getInterleavedColorOffset(geometryArray);
            int n5 = this.getInterleavedStride(geometryArray);
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                int n6 = n5 * nArray[i4] + n4;
                this.primitiveNormals[i4] = new Vector3f(fArray[n6], fArray[n6 + 1], fArray[n6 + 2]);
            }
        }
        return this.primitiveNormals;
    }

    public int[] getPrimitiveTexCoordIndices(int n2) {
        if (this.hasTexCoords && this.primitiveTexCoordIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveTexCoordIndices = new int[this.primitiveVertexIndices.length];
                for (int i2 = 0; i2 < this.primitiveVertexIndices.length; ++i2) {
                    this.primitiveTexCoordIndices[i2] = ((IndexedGeometryArray)this.geometry).getTextureCoordinateIndex(n2, this.primitiveVertexIndices[i2]);
                }
            } else {
                this.primitiveTexCoordIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveTexCoordIndices;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TexCoord3f[] getPrimitiveTexCoords(int n2) {
        GeometryArray geometryArray = (GeometryArray)this.geometry;
        if (this.primitiveTexCoords != null) return this.primitiveTexCoords;
        this.primitiveTexCoords = new TexCoord3f[this.primitiveVertexIndices.length];
        int[] nArray = this.getPrimitiveTexCoordIndices(n2);
        int n3 = geometryArray.getVertexFormat();
        if ((n3 & 0x80) == 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.primitiveTexCoords[i2] = new TexCoord3f();
                geometryArray.getTextureCoordinate(n2, nArray[i2], this.primitiveTexCoords[i2]);
            }
            return this.primitiveTexCoords;
        } else if ((n3 & 0x100) == 0) {
            float[] fArray = geometryArray.getTexCoordRefFloat(n2);
            if (fArray == null) throw new UnsupportedOperationException("Deprecated : BY_REF - t2f and t3f");
            if ((n3 & 0x20) == 32) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    int n4 = nArray[i3] << 1;
                    this.primitiveTexCoords[i3] = new TexCoord3f(fArray[n4], fArray[n4 + 1], 0.0f);
                }
                return this.primitiveTexCoords;
            } else {
                for (int i4 = 0; i4 < nArray.length; ++i4) {
                    int n5 = nArray[i4] * 3;
                    this.primitiveTexCoords[i4] = new TexCoord3f(fArray[n5], fArray[n5 + 1], fArray[n5 + 2]);
                }
            }
            return this.primitiveTexCoords;
        } else {
            float[] fArray = geometryArray.getInterleavedVertices();
            int n6 = this.getInterleavedStride(geometryArray);
            int n7 = (n3 & 0x20) == 32 ? n2 << 1 : n2 * 3;
            for (int i5 = 0; i5 < nArray.length; ++i5) {
                int n8 = n6 * nArray[i5];
                this.primitiveTexCoords[i5] = (n3 & 0x20) == 32 ? new TexCoord3f(fArray[n8 + n7], fArray[n8 + 1 + n7], 0.0f) : new TexCoord3f(fArray[n8 + n7], fArray[n8 + 1 + n7], fArray[n8 + 2 + n7]);
            }
        }
        return this.primitiveTexCoords;
    }

    public int[] getPrimitiveVertexIndices() {
        return this.primitiveVertexIndices;
    }

    public PickInfo.IntersectionInfo getIntersectionInfo() {
        return this.iInfo;
    }

    public String toString() {
        int n2;
        String string = new String("PickIntersection: ");
        string = string + " IntersectionInfo = " + this.iInfo + "\n";
        string = string + " geometry = " + this.geometry + "\n";
        if (this.distance != -1.0) {
            string = string + " dist:" + this.distance + "\n";
        }
        if (this.pointCoordinates != null) {
            string = string + " pt:" + this.pointCoordinates + "\n";
        }
        if (this.pointCoordinatesVW != null) {
            string = string + " ptVW:" + this.pointCoordinatesVW + "\n";
        }
        if (this.primitiveCoordinateIndices != null) {
            string = string + " prim coordinate ind:\n";
            for (n2 = 0; n2 < this.primitiveCoordinateIndices.length; ++n2) {
                string = string + " " + this.primitiveCoordinateIndices[n2] + "\n";
            }
        }
        if (this.primitiveColorIndices != null) {
            string = string + " prim color ind:\n";
            for (n2 = 0; n2 < this.primitiveColorIndices.length; ++n2) {
                string = string + " " + this.primitiveColorIndices[n2] + "\n";
            }
        }
        if (this.primitiveNormalIndices != null) {
            string = string + " prim normal ind:\n";
            for (n2 = 0; n2 < this.primitiveNormalIndices.length; ++n2) {
                string = string + " " + this.primitiveNormalIndices[n2] + "\n";
            }
        }
        if (this.primitiveTexCoordIndices != null) {
            string = string + " prim texture ind:\n";
            for (n2 = 0; n2 < this.primitiveTexCoordIndices.length; ++n2) {
                string = string + " " + this.primitiveTexCoordIndices[n2] + "\n";
            }
        }
        if (this.closestVertexCoordinates != null) {
            string = string + " clos. vert:" + this.closestVertexCoordinates + "\n";
        }
        if (this.closestVertexCoordinatesVW != null) {
            string = string + " clos. vert:" + this.closestVertexCoordinatesVW + "\n";
        }
        if (this.closestVertexIndex != -1) {
            string = string + " clos. vert. ind.:" + this.closestVertexIndex + "\n";
        }
        return string;
    }

    int getInterleavedVertexOffset(GeometryArray geometryArray) {
        int n2 = 0;
        int n3 = geometryArray.getVertexFormat();
        if ((n3 & 4) == 4) {
            n2 += 3;
        } else if ((n3 & 0xC) == 12) {
            n2 += 4;
        }
        if ((n3 & 2) != 0) {
            n2 += 3;
        }
        if ((n3 & 0x20) == 32) {
            n2 += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n3 & 0x40) == 64) {
            n2 += 3 * geometryArray.getTexCoordSetCount();
        }
        return n2;
    }

    int getInterleavedStride(GeometryArray geometryArray) {
        int n2 = 3;
        int n3 = geometryArray.getVertexFormat();
        if ((n3 & 4) == 4) {
            n2 += 3;
        } else if ((n3 & 0xC) == 12) {
            n2 += 4;
        }
        if ((n3 & 2) != 0) {
            n2 += 3;
        }
        if ((n3 & 0x20) == 32) {
            n2 += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n3 & 0x40) == 64) {
            n2 += 3 * geometryArray.getTexCoordSetCount();
        }
        return n2;
    }

    int getInterleavedColorOffset(GeometryArray geometryArray) {
        int n2 = 0;
        int n3 = geometryArray.getVertexFormat();
        if ((n3 & 0x20) == 32) {
            n2 += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n3 & 0x40) == 64) {
            n2 += 3 * geometryArray.getTexCoordSetCount();
        }
        return n2;
    }

    double abs(double d2) {
        if (d2 < 0.0) {
            return -d2;
        }
        return d2;
    }

    int maxAxis(Vector3d vector3d) {
        int n2 = 1;
        double d2 = this.abs(vector3d.x);
        if (this.abs(vector3d.y) > d2) {
            n2 = 2;
            d2 = this.abs(vector3d.y);
        }
        if (this.abs(vector3d.z) > d2) {
            n2 = 3;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean interpTriangle(int n2, int n3, int n4, Point3d[] point3dArray, Point3d point3d) {
        double d2;
        double d3;
        int n5;
        int n6;
        int n7;
        int n8;
        double[] dArray;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d.sub(point3dArray[n3], point3dArray[n2]);
        vector3d2.sub(point3dArray[n4], point3dArray[n2]);
        vector3d3.sub(point3dArray[n4], point3dArray[n3]);
        double d4 = vector3d.lengthSquared();
        double d5 = vector3d2.lengthSquared();
        double d6 = vector3d3.lengthSquared();
        Vector3d vector3d4 = vector3d;
        double d7 = d4;
        if (d5 > d7) {
            vector3d4 = vector3d2;
            d7 = d5;
        }
        if (d6 > d7) {
            vector3d4 = vector3d3;
        }
        if ((dArray = new double[]{PickIntersection.getInterpFactorForBase(point3d, point3dArray[n3], point3dArray[n4], n8 = this.maxAxis(vector3d4)), PickIntersection.getInterpFactorForBase(point3d, point3dArray[n4], point3dArray[n2], n8), PickIntersection.getInterpFactorForBase(point3d, point3dArray[n2], point3dArray[n3], n8)})[0] < 0.0 || dArray[0] > 1.0) {
            n7 = n2;
            n6 = n3;
            n5 = n4;
            d3 = dArray[2];
            d2 = 1.0 - dArray[1];
        } else if (dArray[1] < 0.0 || dArray[1] > 1.0) {
            n7 = n3;
            n6 = n4;
            n5 = n2;
            d3 = dArray[0];
            d2 = 1.0 - dArray[2];
        } else {
            n7 = n4;
            n6 = n2;
            n5 = n3;
            d3 = dArray[1];
            d2 = 1.0 - dArray[0];
        }
        Point3d point3d2 = new Point3d(d2 * point3dArray[n5].x + (1.0 - d2) * point3dArray[n7].x, d2 * point3dArray[n5].y + (1.0 - d2) * point3dArray[n7].y, d2 * point3dArray[n5].z + (1.0 - d2) * point3dArray[n7].z);
        Point3d point3d3 = new Point3d(d3 * point3dArray[n6].x + (1.0 - d3) * point3dArray[n7].x, d3 * point3dArray[n6].y + (1.0 - d3) * point3dArray[n7].y, d3 * point3dArray[n6].z + (1.0 - d3) * point3dArray[n7].z);
        vector3d.sub(point3d2, point3d3);
        int n9 = this.maxAxis(vector3d);
        double d8 = PickIntersection.getInterpFactor(point3d, point3d3, point3d2, n9);
        if (d8 < 0.0) {
            if (!(d8 + 1.0E-5 >= 0.0)) return false;
            d8 = 0.0;
        } else if (d8 > 1.0) {
            if (!(d8 - 1.0E-5 <= 1.0)) return false;
            d8 = 1.0;
        }
        this.interpWeights[n7] = 1.0 - d8 * d2 - d3 + d8 * d3;
        this.interpWeights[n5] = d8 * d2;
        this.interpWeights[n6] = d3 - d8 * d3;
        return true;
    }

    double[] getInterpWeights() {
        Point3d point3d = this.getPointCoordinates();
        Point3d[] point3dArray = this.getPrimitiveCoordinates();
        if (this.interpWeights != null) {
            return this.interpWeights;
        }
        this.interpWeights = new double[point3dArray.length];
        switch (point3dArray.length) {
            case 1: {
                this.interpWeights[0] = 1.0;
                break;
            }
            case 2: {
                double d2;
                Vector3d vector3d = new Vector3d();
                vector3d.sub(point3dArray[1], point3dArray[0]);
                int n2 = this.maxAxis(vector3d);
                this.interpWeights[0] = d2 = (double)PickIntersection.getInterpFactor(point3d, point3dArray[1], point3dArray[0], n2);
                this.interpWeights[1] = 1.0 - d2;
                break;
            }
            case 3: {
                if (this.interpTriangle(0, 1, 2, point3dArray, point3d)) break;
                throw new RuntimeException("Interp point outside triangle");
            }
            case 4: {
                if (this.interpTriangle(0, 1, 2, point3dArray, point3d) || this.interpTriangle(0, 2, 3, point3dArray, point3d)) break;
                throw new RuntimeException("Interp point outside quad");
            }
            default: {
                throw new RuntimeException("Unexpected number of points.");
            }
        }
        return this.interpWeights;
    }

    private static float getInterpFactor(Point3d point3d, Point3d point3d2, Point3d point3d3, int n2) {
        float f2;
        switch (n2) {
            case 1: {
                if (point3d2.x == point3d3.x) {
                    f2 = 0.0f;
                    break;
                }
                f2 = (float)((point3d2.x - point3d.x) / (point3d2.x - point3d3.x));
                break;
            }
            case 2: {
                if (point3d2.y == point3d3.y) {
                    f2 = 0.0f;
                    break;
                }
                f2 = (float)((point3d2.y - point3d.y) / (point3d2.y - point3d3.y));
                break;
            }
            case 3: {
                if (point3d2.z == point3d3.z) {
                    f2 = 0.0f;
                    break;
                }
                f2 = (float)((point3d2.z - point3d.z) / (point3d2.z - point3d3.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + n2 + " (must be 0-2)");
            }
        }
        return f2;
    }

    private static float getInterpFactorForBase(Point3d point3d, Point3d point3d2, Point3d point3d3, int n2) {
        float f2;
        switch (n2) {
            case 1: {
                if (point3d2.x == point3d3.x) {
                    f2 = Float.MAX_VALUE;
                    break;
                }
                f2 = (float)((point3d2.x - point3d.x) / (point3d2.x - point3d3.x));
                break;
            }
            case 2: {
                if (point3d2.y == point3d3.y) {
                    f2 = Float.MAX_VALUE;
                    break;
                }
                f2 = (float)((point3d2.y - point3d.y) / (point3d2.y - point3d3.y));
                break;
            }
            case 3: {
                if (point3d2.z == point3d3.z) {
                    f2 = Float.MAX_VALUE;
                    break;
                }
                f2 = (float)((point3d2.z - point3d.z) / (point3d2.z - point3d3.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + n2 + " (must be 0-2)");
            }
        }
        return f2;
    }
}

