/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.SceneGraphIO;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;

public class GroupState
extends NodeState {
    protected SceneGraphObjectState[] groupChildren;

    public GroupState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Group)this.node).getCollisionBounds());
        int n2 = this.checkProcessChildren() ? ((Group)this.node).numChildren() : 0;
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.control.writeObject(dataOutput, this.control.createState(((Group)this.node).getChild(i2)));
        }
        dataOutput.writeBoolean(((Group)this.node).getAlternateCollisionTarget());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Group)this.node).setCollisionBounds(this.control.readBounds(dataInput));
        int n2 = dataInput.readInt();
        this.groupChildren = new SceneGraphObjectState[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.groupChildren[i2] = this.control.readObject(dataInput);
            ((Group)this.node).addChild((Node)this.groupChildren[i2].getNode());
        }
        ((Group)this.node).setAlternateCollisionTarget(dataInput.readBoolean());
    }

    private boolean checkProcessChildren() {
        if (this.node instanceof SceneGraphIO) {
            return ((SceneGraphIO)((Object)this.node)).saveChildren();
        }
        return this.processChildren();
    }

    protected boolean processChildren() {
        return true;
    }

    public void buildGraph() {
        for (int i2 = 0; i2 < this.groupChildren.length; ++i2) {
            if (this.groupChildren[i2].getSymbol().graphBuilt) continue;
            this.groupChildren[i2].getSymbol().graphBuilt = true;
            this.groupChildren[i2].buildGraph();
        }
        super.buildGraph();
    }

    public void cleanup() {
        for (int i2 = 0; i2 < this.groupChildren.length; ++i2) {
            this.groupChildren[i2].cleanup();
            this.groupChildren[i2] = null;
        }
        this.groupChildren = null;
        super.cleanup();
    }

    protected SceneGraphObject createNode() {
        return new Group();
    }
}

