/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.media.j3d.ImageComponent;

public abstract class ImageComponentState
extends NodeComponentState {
    protected int format;
    protected int height;
    protected int width;
    protected boolean byReference;
    protected boolean yUp;
    private static final int DIRECT_COLOR_MODEL = 1;
    private static final int SINGLE_PIXEL_PACKED_SAMPLE_MODEL = 1;
    private static final int DATA_BUFFER_INT = 1;
    public static final byte NO_COMPRESSION = 0;
    public static final byte GZIP_COMPRESSION = 1;
    public static final byte JPEG_COMPRESSION = 2;

    public ImageComponentState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    protected void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeInt(((ImageComponent)this.node).getFormat());
        dataOutput.writeInt(((ImageComponent)this.node).getHeight());
        dataOutput.writeInt(((ImageComponent)this.node).getWidth());
        dataOutput.writeBoolean(((ImageComponent)this.node).isByReference());
        dataOutput.writeBoolean(((ImageComponent)this.node).isYUp());
    }

    protected void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.format = dataInput.readInt();
        this.height = dataInput.readInt();
        this.width = dataInput.readInt();
        this.byReference = dataInput.readBoolean();
        this.yUp = dataInput.readBoolean();
    }

    protected void writeBufferedImage(DataOutput dataOutput, BufferedImage bufferedImage) throws IOException {
        int n2 = this.control.getImageCompression();
        dataOutput.writeByte(n2);
        if (n2 == 0) {
            this.writeBufferedImageNoCompression(dataOutput, bufferedImage);
        } else if (n2 == 1) {
            this.writeBufferedImageGzipCompression(dataOutput, bufferedImage);
        } else if (n2 == 2) {
            this.writeBufferedImageJpegCompression(dataOutput, bufferedImage);
        }
    }

    private void writeBufferedImageNoCompression(DataOutput dataOutput, BufferedImage bufferedImage) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            int n2;
            object = (ComponentColorModel)colorModel;
            int n3 = ((ColorModel)object).getNumComponents();
            switch (n3) {
                case 3: {
                    n2 = 1;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
                default: {
                    throw new SGIORuntimeException("Unsupported ColorModel " + colorModel.getClass().getName());
                }
            }
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n2);
            WritableRaster writableRaster = bufferedImage2.getRaster();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            writableRaster.setRect(writableRaster2);
            bufferedImage = bufferedImage2;
        }
        this.writeColorModel(dataOutputStream, bufferedImage.getColorModel());
        this.writeWritableRaster(dataOutputStream, bufferedImage.getRaster());
        dataOutputStream.writeBoolean(bufferedImage.isAlphaPremultiplied());
        dataOutputStream.close();
        object = byteArrayOutputStream.toByteArray();
        dataOutput.writeInt(((Object)object).length);
        dataOutput.write((byte[])object);
    }

    private void writeBufferedImageGzipCompression(DataOutput dataOutput, BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(gZIPOutputStream);
        this.writeColorModel(dataOutputStream, bufferedImage.getColorModel());
        this.writeWritableRaster(dataOutputStream, bufferedImage.getRaster());
        dataOutputStream.writeBoolean(bufferedImage.isAlphaPremultiplied());
        dataOutputStream.flush();
        gZIPOutputStream.finish();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
        dataOutputStream.close();
    }

    private void writeBufferedImageJpegCompression(DataOutput dataOutput, BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
        jPEGImageEncoder.encode(bufferedImage);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
    }

    protected BufferedImage readBufferedImage(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by == 0) {
            return this.readBufferedImageNoCompression(dataInput);
        }
        if (by == 1) {
            return this.readBufferedImageGzipCompression(dataInput);
        }
        if (by == 2) {
            return this.readBufferedImageJpegCompression(dataInput);
        }
        throw new SGIORuntimeException("Unknown Image Compression");
    }

    private BufferedImage readBufferedImageNoCompression(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n2];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        ColorModel colorModel = this.readColorModel(dataInputStream);
        WritableRaster writableRaster = this.readWritableRaster(dataInputStream);
        boolean bl = dataInputStream.readBoolean();
        dataInputStream.close();
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    private BufferedImage readBufferedImageGzipCompression(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n2];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        DataInputStream dataInputStream = new DataInputStream(gZIPInputStream);
        ColorModel colorModel = this.readColorModel(dataInputStream);
        WritableRaster writableRaster = this.readWritableRaster(dataInputStream);
        boolean bl = dataInputStream.readBoolean();
        dataInputStream.close();
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    private BufferedImage readBufferedImageJpegCompression(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n2];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        byteArrayInputStream.close();
        return jPEGImageDecoder.decodeAsBufferedImage();
    }

    private void writeColorModel(DataOutput dataOutput, ColorModel colorModel) throws IOException {
        if (!(colorModel instanceof DirectColorModel)) {
            throw new SGIORuntimeException("Unsupported ColorModel " + colorModel.getClass().getName());
        }
        dataOutput.writeInt(1);
        this.writeDirectColorModel(dataOutput, (DirectColorModel)colorModel);
    }

    private ColorModel readColorModel(DataInput dataInput) throws IOException {
        switch (dataInput.readInt()) {
            case 1: {
                return this.readDirectColorModel(dataInput);
            }
        }
        throw new SGIORuntimeException("Invalid ColorModel - File corrupt");
    }

    private void writeDirectColorModel(DataOutput dataOutput, DirectColorModel directColorModel) throws IOException {
        dataOutput.writeInt(directColorModel.getPixelSize());
        dataOutput.writeInt(directColorModel.getRedMask());
        dataOutput.writeInt(directColorModel.getGreenMask());
        dataOutput.writeInt(directColorModel.getBlueMask());
        dataOutput.writeInt(directColorModel.getAlphaMask());
    }

    private DirectColorModel readDirectColorModel(DataInput dataInput) throws IOException {
        return new DirectColorModel(dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt());
    }

    private void writeWritableRaster(DataOutput dataOutput, WritableRaster writableRaster) throws IOException {
        this.writeSampleModel(dataOutput, writableRaster.getSampleModel());
        this.writeDataBuffer(dataOutput, writableRaster.getDataBuffer());
        Point point = new Point();
        dataOutput.writeInt(point.x);
        dataOutput.writeInt(point.y);
    }

    private WritableRaster readWritableRaster(DataInput dataInput) throws IOException {
        return Raster.createWritableRaster(this.readSampleModel(dataInput), this.readDataBuffer(dataInput), new Point(dataInput.readInt(), dataInput.readInt()));
    }

    private void writeSampleModel(DataOutput dataOutput, SampleModel sampleModel) throws IOException {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new SGIORuntimeException("Unsupported SampleModel " + sampleModel.getClass().getName());
        }
        dataOutput.writeInt(1);
        this.writeSinglePixelPackedSampleModel(dataOutput, (SinglePixelPackedSampleModel)sampleModel);
    }

    private SampleModel readSampleModel(DataInput dataInput) throws IOException {
        switch (dataInput.readInt()) {
            case 1: {
                return this.readSinglePixelPackedSampleModel(dataInput);
            }
        }
        throw new SGIORuntimeException("Invalid SampleModel - file corrupt");
    }

    private void writeSinglePixelPackedSampleModel(DataOutput dataOutput, SinglePixelPackedSampleModel singlePixelPackedSampleModel) throws IOException {
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        dataOutput.writeInt(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dataOutput.writeInt(nArray[i2]);
        }
        dataOutput.writeInt(singlePixelPackedSampleModel.getDataType());
        dataOutput.writeInt(singlePixelPackedSampleModel.getWidth());
        dataOutput.writeInt(singlePixelPackedSampleModel.getHeight());
        dataOutput.writeInt(singlePixelPackedSampleModel.getScanlineStride());
    }

    private SinglePixelPackedSampleModel readSinglePixelPackedSampleModel(DataInput dataInput) throws IOException {
        int[] nArray = new int[dataInput.readInt()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = dataInput.readInt();
        }
        return new SinglePixelPackedSampleModel(dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), nArray);
    }

    private void writeDataBuffer(DataOutput dataOutput, DataBuffer dataBuffer) throws IOException {
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new SGIORuntimeException("Unsupported DataBuffer " + dataBuffer.getClass().getName());
        }
        dataOutput.writeInt(1);
        this.writeDataBufferInt(dataOutput, (DataBufferInt)dataBuffer);
    }

    private DataBuffer readDataBuffer(DataInput dataInput) throws IOException {
        switch (dataInput.readInt()) {
            case 1: {
                return this.readDataBufferInt(dataInput);
            }
        }
        throw new SGIORuntimeException("Incorrect DataBuffer - file corrupt");
    }

    private void writeDataBufferInt(DataOutput dataOutput, DataBufferInt dataBufferInt) throws IOException {
        int[][] nArray = dataBufferInt.getBankData();
        dataOutput.writeInt(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dataOutput.writeInt(nArray[i2].length);
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                dataOutput.writeInt(nArray[i2][i3]);
            }
        }
        dataOutput.writeInt(dataBufferInt.getSize());
    }

    private DataBufferInt readDataBufferInt(DataInput dataInput) throws IOException {
        int[][] nArrayArray = new int[dataInput.readInt()][];
        for (int i2 = 0; i2 < nArrayArray.length; ++i2) {
            nArrayArray[i2] = new int[dataInput.readInt()];
            for (int i3 = 0; i3 < nArrayArray[i2].length; ++i3) {
                nArrayArray[i2][i3] = dataInput.readInt();
            }
        }
        return new DataBufferInt(nArrayArray, dataInput.readInt());
    }
}

