/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Morph;
import javax.media.j3d.SceneGraphObject;

public class MorphState
extends LeafState {
    private int[] geometry;
    private double[] weights;
    private int appearance;

    public MorphState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.appearance = controller.getSymbolTable().addReference(((Morph)this.node).getAppearance());
            this.weights = ((Morph)this.node).getWeights();
            this.geometry = new int[this.weights.length];
            for (int i2 = 0; i2 < this.weights.length; ++i2) {
                this.geometry[i2] = controller.getSymbolTable().addReference(((Morph)this.node).getGeometryArray(i2));
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Morph)this.node).getCollisionBounds());
        dataOutput.writeInt(this.appearance);
        dataOutput.writeBoolean(((Morph)this.node).getAppearanceOverrideEnable());
        dataOutput.writeInt(this.geometry.length);
        for (int i2 = 0; i2 < this.geometry.length; ++i2) {
            dataOutput.writeInt(this.geometry[i2]);
            dataOutput.writeDouble(this.weights[i2]);
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Morph)this.node).setCollisionBounds(this.control.readBounds(dataInput));
        this.appearance = dataInput.readInt();
        ((Morph)this.node).setAppearanceOverrideEnable(dataInput.readBoolean());
        int n2 = dataInput.readInt();
        this.geometry = new int[n2];
        this.weights = new double[n2];
        for (int i2 = 0; i2 < this.geometry.length; ++i2) {
            this.geometry[i2] = dataInput.readInt();
            this.weights[i2] = dataInput.readDouble();
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
        for (int i2 = 0; i2 < this.geometry.length; ++i2) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.geometry[i2]);
        }
    }

    public void buildGraph() {
        ((Morph)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        GeometryArray[] geometryArrayArray = new GeometryArray[this.geometry.length];
        for (int i2 = 0; i2 < this.geometry.length; ++i2) {
            geometryArrayArray[i2] = (GeometryArray)this.control.getSymbolTable().getJ3dNode(this.geometry[i2]);
        }
        ((Morph)this.node).setGeometryArrays(geometryArrayArray);
        ((Morph)this.node).setWeights(this.weights);
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Morph(null);
    }
}

