/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.SceneGraphIO;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.media.j3d.SceneGraphObject;

public abstract class SceneGraphObjectState {
    protected SceneGraphObject node;
    protected SymbolTableData symbol;
    protected Controller control;
    protected String nodeClassName;

    public SceneGraphObjectState(SymbolTableData symbolTableData, Controller controller) {
        this.symbol = symbolTableData;
        this.control = controller;
        if (symbolTableData != null) {
            this.node = symbolTableData.j3dNode;
        }
        if (this.node != null) {
            this.nodeClassName = this.node.getClass().getName();
            try {
                if (this.node instanceof SceneGraphIO) {
                    ((SceneGraphIO)((Object)this.node)).createSceneGraphObjectReferences(controller.getSymbolTable());
                }
            }
            catch (Exception exception) {
                System.err.println("Exception in createSceneGraphObjectReferences");
                exception.printStackTrace();
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        boolean bl = this.node instanceof SceneGraphIO;
        dataOutput.writeBoolean(bl);
        dataOutput.writeInt(this.symbol.nodeID);
        int n2 = this.control.getNodeClassID(this.node);
        dataOutput.writeShort(n2);
        if (n2 == -1) {
            dataOutput.writeUTF(this.nodeClassName);
        }
        this.writeConstructorParams(dataOutput);
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((SceneGraphIO)((Object)this.node)).writeSceneGraphObject(dataOutputStream);
            dataOutputStream.close();
            dataOutput.writeInt(byteArrayOutputStream.size());
            dataOutput.write(byteArrayOutputStream.toByteArray());
        }
        this.writeUserData(dataOutput);
        this.writeString(this.node.getName(), dataOutput);
        this.writeCapabilities(dataOutput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        boolean bl = dataInput.readBoolean();
        int n2 = dataInput.readInt();
        short s = dataInput.readShort();
        this.nodeClassName = null;
        if (s == -1) {
            this.nodeClassName = dataInput.readUTF();
        }
        this.readConstructorParams(dataInput);
        if (s != -1) {
            this.node = this.createNode();
            this.nodeClassName = this.node.getClass().getName();
        } else {
            this.node = this.createNode(this.nodeClassName);
        }
        if (bl) {
            if (this.control.getCurrentFileVersion() == 1) {
                ((SceneGraphIO)((Object)this.node)).readSceneGraphObject(dataInput);
            } else {
                int n3 = dataInput.readInt();
                if (this.node instanceof SceneGraphIO) {
                    byte[] byArray = new byte[n3];
                    dataInput.readFully(byArray);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    ((SceneGraphIO)((Object)this.node)).readSceneGraphObject(dataInputStream);
                    dataInputStream.close();
                } else {
                    dataInput.skipBytes(n3);
                }
            }
        }
        this.symbol = this.control.getSymbolTable().createSymbol(this, this.node, n2);
        this.readUserData(dataInput);
        if (this.control.getCurrentFileVersion() > 2) {
            this.node.setName(this.readString(dataInput));
        }
        this.readCapabilities(dataInput);
    }

    public SceneGraphObject getNode() {
        return this.node;
    }

    public int getNodeID() {
        return this.symbol.nodeID;
    }

    public SymbolTableData getSymbol() {
        return this.symbol;
    }

    private void readUserData(DataInput dataInput) throws IOException {
        this.node.setUserData(this.control.readSerializedData(dataInput));
    }

    private void writeUserData(DataOutput dataOutput) throws IOException {
        Object object = this.node.getUserData();
        if (object != null && !(object instanceof Serializable)) {
            System.err.println("UserData is not Serializable and will not be saved");
            object = null;
        }
        this.control.writeSerializedData(dataOutput, (Serializable)object);
    }

    private void writeCapabilities(DataOutput dataOutput) throws IOException {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < 64; ++i2) {
            if (this.node.getCapability(i2)) {
                l2 |= 1L << i2;
            }
            if (this.node.getCapabilityIsFrequent(i2)) continue;
            l3 |= 1L << i2;
        }
        dataOutput.writeLong(l2);
        dataOutput.writeLong(l3);
    }

    private void readCapabilities(DataInput dataInput) throws IOException {
        long l2 = dataInput.readLong();
        long l3 = dataInput.readLong();
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((l2 & 1L << i2) != 0L) {
                this.node.setCapability(i2);
            }
            if ((l3 & 1L << i2) == 0L) continue;
            this.node.clearCapabilityIsFrequent(i2);
        }
    }

    protected void writeConstructorParams(DataOutput dataOutput) throws IOException {
    }

    protected void readConstructorParams(DataInput dataInput) throws IOException {
    }

    protected SceneGraphObject createNode() {
        throw new SGIORuntimeException("createNode() not implemented in class " + this.getClass().getName());
    }

    protected SceneGraphObject createNode(Class clazz) {
        SceneGraphObject sceneGraphObject;
        try {
            sceneGraphObject = (SceneGraphObject)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + clazz.getClass().getName() + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Broken State class for " + clazz.getClass().getName());
        }
        return sceneGraphObject;
    }

    protected SceneGraphObject createNode(String string) {
        SceneGraphObject sceneGraphObject;
        try {
            Class<?> clazz = Class.forName(string, true, this.control.getClassLoader());
            sceneGraphObject = this.createNode(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.control.useSuperClassIfNoChildClass()) {
                sceneGraphObject = this.createNodeFromSuper(string);
            }
            throw new SGIORuntimeException("No Such Class " + string);
        }
        return sceneGraphObject;
    }

    private SceneGraphObject createNodeFromSuper(String string) {
        SceneGraphObject sceneGraphObject;
        String string2 = this.getClass().getName();
        String string3 = string2.substring(string2.indexOf("state") + 6, string2.length() - 5);
        System.err.println("Unable to create node " + string + " attempting Java3D superclass " + string3);
        try {
            Class<?> clazz = Class.forName(string3);
            sceneGraphObject = (SceneGraphObject)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SGIORuntimeException("No Such Class " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + string + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Unable to instantiate class " + string);
        }
        return sceneGraphObject;
    }

    private SceneGraphObject createNode(String string, Class[] classArray, Object[] objectArray) {
        SceneGraphObject sceneGraphObject;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            sceneGraphObject = (SceneGraphObject)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.control.useSuperClassIfNoChildClass()) {
                sceneGraphObject = this.createNodeFromSuper(string, classArray, objectArray);
            }
            throw new SGIORuntimeException("No State class for " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + string + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Broken State class for " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SGIORuntimeException("InvocationTargetException for " + string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                System.err.println(classArray[i2].getName());
            }
            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + string);
        }
        return sceneGraphObject;
    }

    protected SceneGraphObject createNode(Class clazz, Class[] classArray, Object[] objectArray) {
        SceneGraphObject sceneGraphObject;
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            sceneGraphObject = (SceneGraphObject)constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + clazz.getClass().getName() + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Broken State class for " + clazz.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SGIORuntimeException("InvocationTargetException for " + clazz.getClass().getName());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                System.err.println(classArray[i2].getName());
            }
            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + clazz.getClass().getName());
        }
        return sceneGraphObject;
    }

    private SceneGraphObject createNodeFromSuper(String string, Class[] classArray, Object[] objectArray) {
        SceneGraphObject sceneGraphObject;
        String string2 = this.getClass().getName();
        String string3 = string2.substring(string2.indexOf("state") + 6, string2.length() - 5);
        try {
            Class<?> clazz = Class.forName(string3);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            sceneGraphObject = (SceneGraphObject)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SGIORuntimeException("No State class for " + string3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + string + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Broken State class for " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SGIORuntimeException("InvocationTargetException for " + string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                System.err.println(classArray[i2].getName());
            }
            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + string);
        }
        return sceneGraphObject;
    }

    protected SceneGraphObjectState createState(SceneGraphObject sceneGraphObject, Controller controller) {
        return controller.createState(sceneGraphObject);
    }

    private String getClassName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    public void buildGraph() {
        if (this.node instanceof SceneGraphIO) {
            ((SceneGraphIO)((Object)this.node)).restoreSceneGraphObjectReferences(this.control.getSymbolTable());
        }
    }

    public void cleanup() {
        this.control = null;
        this.node = null;
    }

    protected String readString(DataInput dataInput) throws IOException {
        if (dataInput.readBoolean()) {
            return dataInput.readUTF();
        }
        return null;
    }

    protected void writeString(String string, DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(string != null);
        if (string != null) {
            dataOutput.writeUTF(string);
        }
    }
}

