/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.GeometryState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Font3D;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Text3D;
import javax.vecmath.Point3f;

public class Text3DState
extends GeometryState {
    private int font3d;

    public Text3DState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.font3d = controller.getSymbolTable().addReference(((Text3D)this.node).getFont3D());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(((Text3D)this.node).getAlignment());
        dataOutput.writeFloat(((Text3D)this.node).getCharacterSpacing());
        dataOutput.writeInt(this.font3d);
        dataOutput.writeInt(((Text3D)this.node).getPath());
        Point3f point3f = new Point3f();
        ((Text3D)this.node).getPosition(point3f);
        this.control.writePoint3f(dataOutput, point3f);
        dataOutput.writeUTF(((Text3D)this.node).getString());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Text3D)this.node).setAlignment(dataInput.readInt());
        ((Text3D)this.node).setCharacterSpacing(dataInput.readFloat());
        this.font3d = dataInput.readInt();
        ((Text3D)this.node).setPath(dataInput.readInt());
        ((Text3D)this.node).setPosition(this.control.readPoint3f(dataInput));
        ((Text3D)this.node).setString(dataInput.readUTF());
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.font3d);
    }

    public void buildGraph() {
        ((Text3D)this.node).setFont3D((Font3D)this.control.getSymbolTable().getJ3dNode(this.font3d));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Text3D();
    }
}

