/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.webkit.InputMethodClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.graphics.WCPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.web.WebView;

public final class InputMethodClientImpl
implements InputMethodClient,
ExtendedInputMethodRequests {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)InputMethodClientImpl.class.getName());
    private final WeakReference<WebView> wvRef;
    private final WebPage webPage;
    private boolean state;

    public InputMethodClientImpl(WebView webView, WebPage webPage) {
        this.wvRef = new WeakReference<WebView>(webView);
        this.webPage = webPage;
        if (webPage != null) {
            webPage.setInputMethodClient(this);
        }
    }

    @Override
    public void activateInputMethods(boolean bl) {
        WebView webView = (WebView)((Object)this.wvRef.get());
        if (webView != null && webView.getScene() != null) {
            SceneHelper.enableInputMethodEvents((Scene)webView.getScene(), (boolean)bl);
        }
        this.state = bl;
    }

    public boolean getInputMethodState() {
        return this.state;
    }

    public static WCInputMethodEvent convertToWCInputMethodEvent(InputMethodEvent inputMethodEvent) {
        Object object2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object object2 : inputMethodEvent.getComposed()) {
            String string = object2.getText();
            InputMethodHighlight inputMethodHighlight = object2.getHighlight();
            arrayList.add(n2);
            arrayList.add(n2 + string.length());
            arrayList.add(inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED || inputMethodHighlight == InputMethodHighlight.SELECTED_RAW ? 1 : 0);
            n2 += string.length();
            stringBuilder.append(string);
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            arrayList.add(0);
            arrayList.add(n2);
            arrayList.add(0);
            n3 = arrayList.size();
        }
        object2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            object2[i2] = (InputMethodTextRun)((Integer)arrayList.get(i2));
        }
        return new WCInputMethodEvent(inputMethodEvent.getCommitted(), stringBuilder.toString(), (int[])object2, inputMethodEvent.getCaretPosition());
    }

    public Point2D getTextLocation(int n2) {
        FutureTask<Point2D> futureTask = new FutureTask<Point2D>(() -> {
            int[] nArray = this.webPage.getClientTextLocation(n2);
            WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(nArray[0], nArray[1] + nArray[3]));
            return new Point2D((double)wCPoint.getIntX(), (double)wCPoint.getIntY());
        });
        Invoker.getInvoker().invokeOnEventThread(futureTask);
        Point2D point2D = null;
        try {
            point2D = futureTask.get();
        }
        catch (ExecutionException executionException) {
            log.severe("InputMethodClientImpl.getTextLocation " + executionException);
        }
        catch (InterruptedException interruptedException) {
            log.severe("InputMethodClientImpl.getTextLocation InterruptedException" + interruptedException);
        }
        return point2D;
    }

    public int getLocationOffset(int n2, int n3) {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(() -> {
            WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(0.0f, 0.0f));
            return this.webPage.getClientLocationOffset(n2 - wCPoint.getIntX(), n3 - wCPoint.getIntY());
        });
        Invoker.getInvoker().invokeOnEventThread(futureTask);
        int n4 = 0;
        try {
            n4 = futureTask.get();
        }
        catch (ExecutionException executionException) {
            log.severe("InputMethodClientImpl.getLocationOffset " + executionException);
        }
        catch (InterruptedException interruptedException) {
            log.severe("InputMethodClientImpl.getTextLocation InterruptedException" + interruptedException);
        }
        return n4;
    }

    public void cancelLatestCommittedText() {
    }

    public String getSelectedText() {
        return this.webPage.getClientSelectedText();
    }

    public int getInsertPositionOffset() {
        return this.webPage.getClientInsertPositionOffset();
    }

    public String getCommittedText(int n2, int n3) {
        try {
            return this.webPage.getClientCommittedText().substring(n2, n3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException(stringIndexOutOfBoundsException);
        }
    }

    public int getCommittedTextLength() {
        return this.webPage.getClientCommittedTextLength();
    }
}

