/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.dsound;

import com.sun.media.JMFSecurityManager;
import javax.media.format.AudioFormat;

public class DSound {
    private static boolean opened = false;
    private static AudioFormat format = null;
    private static int bufSize = 2048;
    private static long directSound = 0L;
    private long dsBuffer = 0L;
    static boolean loaded = false;

    public DSound(AudioFormat format, int bufferSize) {
        DSound.format = format;
        bufSize = bufferSize;
    }

    public static boolean isOpen() {
        return opened;
    }

    public static boolean isFormatSupported(AudioFormat format, int bufSize) {
        return true;
    }

    public void open() {
        this.dsBuffer = this.nOpen((int)format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), bufSize);
        if (this.dsBuffer == 0L) {
            throw new Error("Couldn't create capture buffer");
        }
    }

    public AudioFormat getFormat() {
        return format;
    }

    public int getBufferSize() {
        return bufSize;
    }

    public void start() {
        this.nStart(this.dsBuffer);
    }

    public void stop() {
        this.nStop(this.dsBuffer);
    }

    public void flush() {
        this.nFlush(this.dsBuffer);
    }

    public synchronized void close() {
        if (this.dsBuffer != 0L) {
            this.nClose(this.dsBuffer);
        }
        this.dsBuffer = 0L;
    }

    public int read(byte[] data, int offset, int len) {
        return this.nRead(this.dsBuffer, data, offset, len);
    }

    private native long nOpen(int var1, int var2, int var3, int var4);

    private synchronized native void nStart(long var1);

    private synchronized native void nStop(long var1);

    private synchronized native void nFlush(long var1);

    private synchronized native int nRead(long var1, byte[] var3, int var4, int var5);

    private synchronized native void nClose(long var1);

    static {
        if (!loaded) {
            try {
                JMFSecurityManager.checkCapture();
                JMFSecurityManager.loadLibrary("jmdaudc");
                loaded = true;
            }
            catch (UnsatisfiedLinkError e2) {
                loaded = false;
                throw e2;
            }
        }
    }
}

