/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.vfw;

import com.sun.media.protocol.vfw.VFWCapture;
import com.sun.media.vfw.BitMapInfo;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.VideoFormat;

public class VFWDeviceQuery
extends CaptureDeviceInfo {
    private int capHandle;
    private Vector vecFormats = null;
    protected Dimension[] sizes = new Dimension[]{new Dimension(80, 60), new Dimension(160, 120), new Dimension(176, 144), new Dimension(320, 240), new Dimension(352, 288), new Dimension(640, 480), new Dimension(768, 576)};
    protected String[] knownFourCC = new String[]{"YUY2", "Y411", "YVU9", "YV12", "I420", "MJPG", "VDEC", "VGPX", "WINX", "MPGI"};
    protected int[] knownBitCount = new int[]{16, 12, 9, 12, 12, 24, 16, 24, 24, 24};
    static /* synthetic */ Class array$B;

    private void addFormat(Format fin) {
        Enumeration enumeration = this.vecFormats.elements();
        while (enumeration.hasMoreElements()) {
            Format f2 = (Format)enumeration.nextElement();
            if (!f2.equals(fin)) continue;
            return;
        }
        this.vecFormats.addElement(fin);
    }

    public VFWDeviceQuery(int index) {
        Dimension size;
        VideoFormat vf;
        int parentWindow = VFWCapture.createWindow("Crap");
        this.capHandle = VFWCapture.capCreateCaptureWindow("Test", parentWindow, 0, 0, 320, 240, VFWCapture.getNextID());
        if (this.capHandle == 0) {
            VFWCapture.destroyWindow(parentWindow);
            throw new RuntimeException("Could not create capture window");
        }
        if (!VFWCapture.capDriverConnect(this.capHandle, index)) {
            VFWCapture.destroyWindow(this.capHandle);
            VFWCapture.destroyWindow(parentWindow);
            throw new RuntimeException("Unsupported device");
        }
        BitMapInfo bmi = new BitMapInfo();
        this.vecFormats = new Vector();
        VFWCapture.capGetVideoFormat(this.capHandle, bmi);
        if (!(bmi.biWidth == 0 || bmi.biHeight == 0 || bmi.biBitCount == 8 && bmi.fourcc.equalsIgnoreCase("RGB"))) {
            vf = bmi.createVideoFormat(array$B == null ? (array$B = VFWDeviceQuery.class$("[B")) : array$B);
            this.addFormat(vf);
        }
        BitMapInfo bmTry = new BitMapInfo("RGB", 0, 0, 1, 16, 0, 0, 0);
        int i2 = 0;
        while (i2 < this.sizes.length) {
            size = this.sizes[i2];
            bmTry.biWidth = size.width;
            bmTry.biHeight = size.height;
            bmTry.biSizeImage = size.width * size.height * 2;
            VFWCapture.capSetVideoFormat(this.capHandle, bmTry);
            VFWCapture.capGetVideoFormat(this.capHandle, bmi);
            if (bmi.biWidth != 0 && bmi.biHeight != 0) {
                vf = bmi.createVideoFormat(array$B == null ? VFWDeviceQuery.class$("[B") : array$B);
                this.addFormat(vf);
            }
            ++i2;
        }
        bmTry = new BitMapInfo("RGB", 0, 0, 1, 24, 0, 0, 0);
        i2 = 0;
        while (i2 < this.sizes.length) {
            size = this.sizes[i2];
            bmTry.biWidth = size.width;
            bmTry.biHeight = size.height;
            bmTry.biSizeImage = size.width * size.height * 3;
            VFWCapture.capSetVideoFormat(this.capHandle, bmTry);
            VFWCapture.capGetVideoFormat(this.capHandle, bmi);
            if (bmi.biWidth != 0 && bmi.biHeight != 0) {
                vf = bmi.createVideoFormat(array$B == null ? VFWDeviceQuery.class$("[B") : array$B);
                this.addFormat(vf);
            }
            ++i2;
        }
        String partName = VFWCapture.capDriverGetName(this.capHandle);
        boolean hasVGPX = false;
        int startCode = 0;
        int endCode = this.knownFourCC.length;
        if (partName.startsWith("Color QuickCam video")) {
            startCode = 6;
            endCode = 7;
        }
        if (partName.startsWith("Logitech QuickCam")) {
            startCode = 6;
            endCode = 6;
        }
        int j2 = startCode;
        while (j2 < endCode) {
            int bitCount = this.knownBitCount[j2];
            bmTry = new BitMapInfo(this.knownFourCC[j2], 0, 0, 1, bitCount, 0, 0, 0);
            i2 = 0;
            while (i2 < this.sizes.length) {
                Dimension size2 = this.sizes[i2];
                bmTry.biWidth = size2.width;
                bmTry.biHeight = size2.height;
                if (!this.knownFourCC[j2].equals("VGPX") || size2.width != 80 && size2.width != 176 && size2.width <= 320) {
                    bmTry.biSizeImage = size2.width * size2.height * bitCount / 8;
                    VFWCapture.capSetVideoFormat(this.capHandle, bmTry);
                    VFWCapture.capGetVideoFormat(this.capHandle, bmi);
                    if (bmi.biWidth != 0 && bmi.biHeight != 0) {
                        vf = bmi.createVideoFormat(array$B == null ? VFWDeviceQuery.class$("[B") : array$B);
                        if (this.knownFourCC[j2].equals("VGPX")) {
                            hasVGPX = true;
                        }
                        this.addFormat(vf);
                    }
                }
                ++i2;
            }
            if (hasVGPX) break;
            ++j2;
        }
        String driverVerson = VFWCapture.capDriverGetVersion(this.capHandle);
        VFWCapture.capDriverDisconnect(this.capHandle);
        VFWCapture.destroyWindow(this.capHandle);
        VFWCapture.destroyWindow(parentWindow);
        this.name = "vfw:" + partName + ":" + index;
        String strLocator = "vfw://" + index;
        this.formats = new Format[this.vecFormats.size()];
        Enumeration enumeration = this.vecFormats.elements();
        i2 = 0;
        while (enumeration.hasMoreElements()) {
            Format f2 = (Format)enumeration.nextElement();
            this.formats[i2++] = f2;
        }
        this.locator = new MediaLocator(strLocator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

