/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.io;

import de.javasoft.io.FileOperationEvent;
import de.javasoft.io.FileOperationListener;
import de.javasoft.io.FileProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    public static boolean delete(File file, boolean bl, FileOperationListener fileOperationListener) {
        File[] fileArray;
        boolean bl2 = false;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].isDirectory() && bl) {
                    boolean bl3 = bl2 = !FileUtils.delete(fileArray[n2], bl, fileOperationListener);
                    if (bl2) {
                        return !bl2;
                    }
                } else {
                    if (fileOperationListener != null) {
                        boolean bl4 = bl2 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, fileArray[n2], 3));
                    }
                    if (bl2) {
                        return !bl2;
                    }
                    fileArray[n2].delete();
                }
                ++n2;
            }
        }
        if (fileOperationListener != null) {
            boolean bl5 = bl2 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, file, 3));
        }
        if (bl2) {
            return !bl2;
        }
        file.delete();
        return !bl2;
    }

    public static boolean copy(File file, File file2, boolean bl, boolean bl2, FileOperationListener fileOperationListener) throws FileNotFoundException, IOException {
        boolean bl3 = false;
        if (fileOperationListener != null) {
            boolean bl4 = bl3 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, file, 2));
        }
        if (bl3) {
            return !bl3;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[65536];
        int n2 = 0;
        while ((n2 = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n2);
        }
        fileOutputStream.close();
        fileInputStream.close();
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
        if (bl2) {
            boolean bl5 = bl3 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, file, 3));
            if (bl3) {
                return !bl3;
            }
            file.delete();
        }
        return !bl3;
    }

    public static boolean copy(File file, File file2, boolean bl, boolean bl2, boolean bl3, FileOperationListener fileOperationListener) throws IOException {
        File[] fileArray;
        boolean bl4 = false;
        if (!file.exists()) {
            throw new IOException("Source directory not found: " + file.getAbsolutePath());
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            if (!file2.exists()) {
                if (fileOperationListener != null) {
                    boolean bl5 = bl4 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(FileUtils.class, file2, 1));
                }
                if (bl4) {
                    return !bl4;
                }
                file2.mkdir();
            }
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file3;
                if (fileArray[n2].isDirectory() && bl) {
                    file3 = new File(file2, fileArray[n2].getName());
                    boolean bl6 = bl4 = !FileUtils.copy(fileArray[n2], file3, bl, bl2, bl3, fileOperationListener);
                    if (bl4) {
                        return !bl4;
                    }
                } else if (fileArray[n2].isFile()) {
                    file3 = new File(file2, fileArray[n2].getName());
                    if (bl2 || !file3.exists() || file3.lastModified() < file.lastModified()) {
                        boolean bl7 = bl4 = !FileUtils.copy(fileArray[n2], file3, true, bl3, fileOperationListener);
                        if (bl4) {
                            return !bl4;
                        }
                    }
                }
                ++n2;
            }
        } else if (bl2 || !file2.exists() || file2.lastModified() < file.lastModified()) {
            boolean bl8 = bl4 = !FileUtils.copy(file, file2, true, bl3, fileOperationListener);
            if (bl4) {
                return !bl4;
            }
        }
        if (file.isDirectory() && bl && bl3) {
            bl4 = !FileUtils.delete(file, false, fileOperationListener);
        }
        return !bl4;
    }

    public static boolean determineProperties(FileProperties fileProperties, File file, boolean bl, FileOperationListener fileOperationListener) throws IOException {
        File[] fileArray;
        boolean bl2 = false;
        if (!file.exists()) {
            throw new IOException("File not found: " + file.getAbsolutePath());
        }
        if (fileProperties.location == null) {
            fileProperties.location = file.getParent();
        }
        if (file.isDirectory() && bl && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            ++fileProperties.directories;
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].isDirectory() && bl) {
                    boolean bl3 = bl2 = !FileUtils.determineProperties(fileProperties, fileArray[n2], bl, fileOperationListener);
                    if (bl2) {
                        return !bl2;
                    }
                } else if (fileArray[n2].isFile()) {
                    ++fileProperties.files;
                    fileProperties.size += fileArray[n2].length();
                    if (fileOperationListener != null) {
                        boolean bl4 = bl2 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(fileProperties, file, 4));
                    }
                    if (bl2) {
                        return !bl2;
                    }
                }
                ++n2;
            }
        } else {
            if (file.isDirectory()) {
                ++fileProperties.directories;
            } else {
                ++fileProperties.files;
                fileProperties.size += file.length();
            }
            fileProperties.lastModified = file.lastModified();
            if (fileOperationListener != null) {
                bl2 = !fileOperationListener.processFileOperationEvent(new FileOperationEvent(fileProperties, file, 4));
            }
        }
        return !bl2;
    }
}

