/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class SyntheticaDesktopManager
extends DefaultDesktopManager {
    private static final long serialVersionUID = -4402279640030928428L;

    public void beginDraggingFrame(JComponent jComponent) {
        boolean bl = jComponent.isOpaque();
        if (!bl) {
            jComponent.setOpaque(true);
        }
        super.beginDraggingFrame(jComponent);
        jComponent.setOpaque(bl);
    }

    public void dragFrame(JComponent jComponent, int n2, int n3) {
        super.dragFrame(jComponent, n2, n3);
        if (jComponent instanceof JInternalFrame) {
            this.setDragging(jComponent, false);
            this.repaintBorder(jComponent);
            this.setDragging(jComponent, true);
        }
    }

    private void repaintBorder(JComponent jComponent) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.internalFrame.border.insets", jComponent);
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        jComponent.paintImmediately(0, 0, n2, insets.top);
        jComponent.paintImmediately(0, insets.top, insets.left, n3 - insets.top - insets.bottom);
        jComponent.paintImmediately(0, n3 - insets.bottom, n2, insets.bottom);
        jComponent.paintImmediately(n2 - insets.right, insets.top, insets.right, n3 - insets.top - insets.bottom);
    }

    private void setDragging(JComponent jComponent, boolean bl) {
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            try {
                Class<JInternalFrame> clazz = JInternalFrame.class;
                Field field = clazz.getDeclaredField("isDragging");
                field.setAccessible(true);
                field.set(jComponent, bl);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

