/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class SyntheticaState {
    private int cState = 0;

    public SyntheticaState() {
    }

    public SyntheticaState(int n2) {
        this();
        this.cState = n2;
    }

    public SyntheticaState(State state) {
        this.setState(state);
    }

    public int getState() {
        return this.cState;
    }

    public void setState(int n2) {
        this.cState = n2;
    }

    public void setState(State state) {
        this.cState |= state.toInt();
    }

    public void resetState(State state) {
        if (this.isSet(state)) {
            this.cState ^= state.toInt();
        }
    }

    public boolean isSet(State state) {
        return (this.getState() & state.toInt()) > 0;
    }

    public boolean isSet(int n2) {
        return (this.getState() & n2) != 0;
    }

    public boolean equals(Object object) {
        return ((SyntheticaState)object).getState() == this.getState();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        State[] stateArray = State.values();
        int n2 = stateArray.length;
        int n3 = 0;
        while (n3 < n2) {
            State state = stateArray[n3];
            if ((this.getState() & state.toInt()) != 0) {
                stringBuilder.append(':');
                stringBuilder.append((Object)state);
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNDEFINED("UNDEFINED", 0),
        ENABLED("ENABLED", 1),
        HOVER("HOVER", 2),
        PRESSED("PRESSED", 4),
        DISABLED("DISABLED", 8),
        FOCUSED("FOCUSED", 256),
        SELECTED("SELECTED", 512),
        DEFAULT("DEFAULT", 1024),
        LOCKED("LOCKED", 2048),
        ACTIVE("ACTIVE", 4096);

        private int state;
        private String name;
        private static Map<String, State> states;

        static {
            states = new HashMap<String, State>();
            State[] stateArray = State.values();
            int n2 = stateArray.length;
            int n3 = 0;
            while (n3 < n2) {
                State state = stateArray[n3];
                states.put(state.name, state);
                ++n3;
            }
        }

        private State(String string2, int n3) {
            this.name = string2;
            this.state = n3;
        }

        public static State parse(String string) throws ParseException {
            State state = states.get(string.toUpperCase());
            if (state == null) {
                throw new ParseException("Unsupported state: " + string, -1);
            }
            return state;
        }

        public int toInt() {
            return this.state;
        }

        public String toString() {
            return this.name;
        }
    }
}

