/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.bluelight;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.util.OS;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.table.TableCellRenderer;

public class GraphicsUtils
extends de.javasoft.plaf.synthetica.GraphicsUtils {
    private boolean textShadowEnabled = SyntheticaLookAndFeel.getBoolean("SyntheticaBlueLight.textShadowEnabled", null, true);
    private boolean useSimpleTextShadow = SyntheticaLookAndFeel.getBoolean("SyntheticaBlueLight.useSimpleTextShadow", null, true);
    private Color optionalForeground = Color.BLACK;
    private Color optionalForeground_disabled = new Color(0x50000000, true);

    public void paintText(SynthContext sc, Graphics g2, String text, int x, int y, int mnemonicIndex) {
        JTable table;
        boolean focused;
        JComponent c2 = sc.getComponent();
        String name = c2.getName();
        Region region = sc.getRegion();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean hover = (sc.getComponentState() & 2) > 0;
        boolean pressed = (sc.getComponentState() & 4) > 0;
        Container cParent = c2.getParent();
        Container grandParent = cParent == null ? null : cParent.getParent();
        boolean respectFocus = SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.respectFocus", c2, false);
        boolean bl = respectFocus ? (grandParent != null ? grandParent.hasFocus() : false) : (focused = false);
        if ("Table.cellRenderer".equals(name) && respectFocus && grandParent instanceof JTable && (table = (JTable)grandParent).getCellEditor() != null) {
            focused = true;
        }
        JComponent parent = cParent instanceof JComponent ? (JComponent)cParent : null;
        JToolBar opaqueToolBar = null;
        boolean isToolBarChild = parent instanceof JToolBar;
        Color paintColor = g2.getColor();
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            Color fg;
            if (pressed && !selected) {
                ++y;
            }
            opaqueToolBar = SyntheticaLookAndFeel.findOpaqueParentOfClass(JToolBar.class, c2, false);
            if (isToolBarChild && paintColor instanceof UIResource && !"ButtonBar".equals(parent.getName()) && !hover && !pressed) {
                fg = disabled ? this.optionalForeground_disabled : this.optionalForeground;
                g2.setColor(fg);
            } else if (!(((AbstractButton)c2).isContentAreaFilled() && SyntheticaLookAndFeel.isOpaque(c2) || !(paintColor instanceof UIResource) || name != null && name.startsWith("XMenu"))) {
                fg = disabled ? this.optionalForeground_disabled : this.optionalForeground;
                g2.setColor(fg);
            }
        } else if ((region == Region.LABEL || region == Region.CHECK_BOX) && -1 == c2.getForeground().getRGB() && ("List.cellRenderer".equals(name) || "Table.cellRenderer".equals(name) || "Tree.cellRenderer".equals(name) || "JYCheckBoxTree.cellRenderer".equals(name))) {
            if (!(grandParent instanceof JTable) && !(grandParent instanceof JTree) && !(grandParent instanceof JList) || grandParent instanceof JTree && grandParent instanceof TableCellRenderer) {
                Container parent_ = grandParent;
                while (parent_ != null && !parent_.hasFocus()) {
                    parent_ = parent_.getParent();
                }
                boolean bl2 = focused = parent_ == null || parent_ instanceof JRootPane ? false : parent_.hasFocus();
            }
            if (respectFocus && !focused) {
                g2.setColor(this.optionalForeground);
            }
        }
        if (this.textShadowEnabled) {
            if (region == Region.MENU && ((JMenu)c2).isTopLevelMenu()) {
                Window w = SwingUtilities.getWindowAncestor(c2);
                if (w != null && w.isActive() && !(hover |= SyntheticaLookAndFeel.getClientProperty("Synthetica.MOUSE_OVER", c2, false).booleanValue()) && !selected) {
                    this.paintBrightShadow(c2, g2, x, y, text, mnemonicIndex);
                } else if (w != null && w.isActive() && (hover || selected) && !disabled) {
                    this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
                }
            } else if (region == Region.MENU && selected) {
                this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
            } else if (c2 instanceof JMenuItem && hover) {
                this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && "TableHeader.renderer".equals(name)) {
                this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && -1 == c2.getForeground().getRGB()) {
                if (focused && ("List.cellRenderer".equals(name) || "Table.cellRenderer".equals(name) || "Tree.cellRenderer".equals(name))) {
                    this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
                } else if ("ComboBox.listRenderer".equals(name) && grandParent != null && "ComboBox.list".equals(grandParent.getName())) {
                    this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
                }
            } else if (!(region != Region.BUTTON && region != Region.TOGGLE_BUTTON || opaqueToolBar != null || disabled)) {
                if (hover && !pressed && !selected && g2.getColor().equals(Color.BLACK)) {
                    this.paintBrightShadow(c2, g2, x, y, text, mnemonicIndex);
                } else if (g2.getColor().equals(Color.WHITE)) {
                    this.paintDarkShadow(c2, g2, x, y, text, mnemonicIndex);
                }
            }
        }
        super.paintText(sc, g2, text, x, y, mnemonicIndex);
    }

    private void paintBrightShadow(JComponent c2, Graphics g2, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c2, g2, x, y, text, false, 1, -2, 0.75f, Color.WHITE, 0, 1, mnemonicIndex);
    }

    private void paintDarkShadow(JComponent c2, Graphics g2, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c2, g2, x, y, text, false, 1, -2, 0.5f, Color.BLACK, 0, -1, mnemonicIndex);
    }

    private void paintShadow(JComponent c2, Graphics g2, int x, int y, String text, boolean highQuality, int size, int distance, float opacity, Color color, int xOffset, int yOffset, int mnemonicIndex) {
        Graphics2D g22 = (Graphics2D)g2;
        RenderingHints rh = null;
        if (OS.getCurrentOS() == OS.Mac) {
            rh = g22.getRenderingHints();
            g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.useSimpleTextShadow) {
            FontMetrics fm = g2.getFontMetrics(c2.getFont());
            Color col = g2.getColor();
            g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * opacity / 1.25f)));
            g2.drawString(text, x + xOffset, y + yOffset + fm.getAscent());
            g2.setColor(col);
        } else {
            this.paintTextShadow(c2, g2, x, y, text, highQuality, size, distance, opacity, color, xOffset, yOffset, false, mnemonicIndex);
        }
        if (OS.getCurrentOS() == OS.Mac) {
            g22.setRenderingHints(rh);
        }
    }
}

