/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.synth.SynthContext;

public class ArrowButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ArrowButtonPainter";

    protected ArrowButtonPainter() {
    }

    public static ArrowButtonPainter getInstance() {
        return ArrowButtonPainter.getInstance(null);
    }

    public static ArrowButtonPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ArrowButtonPainter.getPainterClassName(synthContext, ArrowButtonPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ArrowButtonPainter.getInstance(synthContext, ArrowButtonPainter.class, UI_KEY);
        }
        return (ArrowButtonPainter)syntheticaComponentPainter;
    }

    public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        boolean bl;
        JButton jButton = (JButton)synthContext.getComponent();
        Container container = jButton.getParent();
        String string = jButton.getName();
        int n6 = 0;
        if (container instanceof JComboBox) {
            n6 = ((JComboBox)container).isEditable() ? 0 : SyntheticaState.State.LOCKED.toInt();
        }
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext, n6, false);
        if (string != null && string.startsWith("SplitPaneDivider.")) {
            return;
        }
        int n7 = (Integer)jButton.getClientProperty("__arrow_direction__");
        boolean bl2 = true;
        boolean bl3 = bl = (n7 == 5 || n7 == 1) && !jButton.getComponentOrientation().isLeftToRight();
        if (container instanceof JComboBox || string != null && string.startsWith("ComboBox.arrowButton")) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.hoverAndPressed.enabled", container)) {
                syntheticaPainterState = new SyntheticaPainterState(synthContext, n6, false, true);
            }
            n7 = 7;
        } else if (container instanceof JSpinner || "Spinner.nextButton".equals(string) || "Spinner.previousButton".equals(string)) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.hoverAndPressed.enabled", container)) {
                syntheticaPainterState = new SyntheticaPainterState(synthContext, n6, false, false);
            }
            n7 = 7;
        }
        Insets insets = null;
        UIKey uIKey = new UIKey("arrowButton.y.background", syntheticaPainterState);
        if (bl2) {
            if (n4 <= 12 || n5 <= 12) {
                uIKey = new UIKey("arrowButton.8x8.background", syntheticaPainterState);
            } else if (n7 == 3 || n7 == 7) {
                uIKey = new UIKey("arrowButton.x.background", syntheticaPainterState);
            }
            insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 2);
        }
        String string2 = (String)uIKey.findProperty(synthContext, null, true, 1);
        Insets insets2 = insets;
        int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jButton, 1);
        int n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jButton, 50);
        int n10 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jButton, 2);
        if (syntheticaPainterState.isSet(SyntheticaState.State.HOVER)) {
            n10 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jButton, 1);
        }
        ImagePainter imagePainter = new ImagePainter(jButton, null, n8, n9, n10, syntheticaPainterState.getState(), graphics, n2, n3, n4, n5, string2, insets, insets2, 0, 0, bl, false);
        imagePainter.draw();
    }

    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        JComponent jComponent = synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey("arrow", syntheticaPainterState, n6, -1, -1);
        boolean bl2 = bl = (n6 == 5 || n6 == 1) && !jComponent.getComponentOrientation().isLeftToRight();
        if (n4 < 16 || n5 < 16) {
            uIKey = new UIKey("arrow.8x8", syntheticaPainterState, n6, -1, -1);
            n2 += (n4 - 8 + 1) / 2;
            n3 += (n5 - 8 + 1) / 2;
            n4 = 8;
            n5 = 8;
        } else if (n4 != 16 || n5 != 16) {
            n2 += bl ? (n4 - 16) / 2 : (n4 - 16 + 1) / 2;
            n3 += (n5 - 16 + 1) / 2;
            n4 = 16;
            n5 = 16;
        }
        n2 += jComponent.getClientProperty("Synthetica.arrow.xOffset") == null ? 0 : (Integer)jComponent.getClientProperty("Synthetica.arrow.xOffset");
        n3 += jComponent.getClientProperty("Synthetica.arrow.yOffset") == null ? 0 : (Integer)jComponent.getClientProperty("Synthetica.arrow.yOffset");
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        String string = SyntheticaLookAndFeel.getString(uIKey.get(), jComponent);
        if (string != null) {
            ImagePainter imagePainter = new ImagePainter(jComponent, null, -1, -1, -1, -1, graphics, n2, n3, n4, n5, string, insets, insets2, 0, 0, bl, false);
            imagePainter.draw();
        }
    }
}

