/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ProgressBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ProgressBarPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected ProgressBarPainter() {
    }

    public static ProgressBarPainter getInstance() {
        return ProgressBarPainter.getInstance(null);
    }

    public static ProgressBarPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ProgressBarPainter.getPainterClassName(synthContext, ProgressBarPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ProgressBarPainter.getInstance(synthContext, ProgressBarPainter.class, UI_KEY);
        }
        return (ProgressBarPainter)syntheticaComponentPainter;
    }

    public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Insets insets;
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        Insets insets2 = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets3 = jProgressBar.getInsets();
        n4 -= insets3.left + insets3.right - insets2.left - insets2.right;
        n5 -= insets3.top + insets3.bottom - insets2.top - insets2.bottom;
        n2 += insets3.left - insets2.left;
        n3 += insets3.top - insets2.top;
        int n6 = jProgressBar.getValue() > 0 || jProgressBar.isIndeterminate() ? SyntheticaState.State.ACTIVE.toInt() : 0;
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext, n6, false);
        UIKey uIKey = new UIKey("progressBar.x.background", syntheticaPainterState);
        if (jProgressBar.getOrientation() == 1) {
            uIKey = new UIKey("progressBar.y.background", syntheticaPainterState);
        }
        Insets insets4 = insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 2);
        String string = (String)uIKey.findProperty(synthContext, null, true, 1);
        uIKey = new UIKey("progressBar.background", syntheticaPainterState);
        if (string != null) {
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jProgressBar, 1);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jProgressBar, 50);
            int n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jProgressBar, 6);
            if (syntheticaPainterState.isSet(SyntheticaState.State.ACTIVE)) {
                n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jProgressBar, 5);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)jProgressBar, n7, n8, n9, syntheticaPainterState.getState(), graphics, n2, n3, n4, n5, string, insets, insets4, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        Insets insets;
        Graphics2D graphics2D = (Graphics2D)graphics;
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey(jProgressBar.isIndeterminate() ? "progressBar.x.indeterminate" : "progressBar.x", syntheticaPainterState);
        if (n6 == 1) {
            uIKey = new UIKey(jProgressBar.isIndeterminate() ? "progressBar.y.indeterminate" : "progressBar.y", syntheticaPainterState);
        }
        if ((insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 2)) == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets2 = insets;
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.respectMinimumBarImageSize", jProgressBar, true);
        if (n6 == 0) {
            int n10 = n9 = bl ? insets.left + insets.right : 1;
            if (n4 < n9) {
                return;
            }
        } else {
            int n11 = n9 = bl ? insets.top + insets.bottom : 1;
            if (n5 < n9) {
                return;
            }
        }
        n9 = n4;
        int n12 = n5;
        int n13 = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.tiled", jProgressBar) ? 1 : 0;
        String string = (String)uIKey.findProperty(synthContext, null, true, 2);
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.continuous", jProgressBar)) {
            Image image = imgCache.get(string);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
                imgCache.put(string, image);
            }
            n8 = image.getWidth(null) - insets.left - insets.right;
            n7 = image.getHeight(null) - insets.top - insets.bottom;
            n9 = (n4 - insets.left - insets.right) / n8 * n8 + insets.left + insets.right;
            n12 = (n5 - insets.top - insets.bottom) / n7 * n7 + insets.top + insets.bottom;
            n13 = 1;
        }
        int n14 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jProgressBar, -1);
        n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jProgressBar, 70);
        n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jProgressBar, 0);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ImagePainter imagePainter = null;
        if (n6 == 0) {
            imagePainter = new ImagePainter((JComponent)jProgressBar, n14, n8, n7, syntheticaPainterState.getState(), graphics, n2, n3, n9, n5, string, insets, insets2, n13, 0);
            imagePainter.draw();
        } else {
            imagePainter = new ImagePainter((JComponent)jProgressBar, n14, n8, n7, syntheticaPainterState.getState(), graphics, n2, n3 - n12 + n5, n4, n12, string, insets, insets2, 0, n13);
            imagePainter.draw();
        }
        graphics2D.setRenderingHints(renderingHints);
        if (jProgressBar.isStringPainted() && jProgressBar.isIndeterminate() && JAVA5) {
            SynthStyle synthStyle = synthContext.getStyle();
            Font font = synthStyle.getFont(synthContext);
            graphics.setFont(font);
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = jProgressBar.getBounds();
            int n15 = synthStyle.getGraphicsUtils(synthContext).computeStringWidth(synthContext, font, fontMetrics, jProgressBar.getString());
            Point point = new Point(rectangle.width / 2 - n15 / 2, (rectangle.height - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2);
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, jProgressBar.getString(), point.x, point.y, -1);
        }
    }

    public int getCacheHash(SynthContext synthContext, int n2, int n3, int n4, String string) {
        if (string.equals("paintProgressBarForeground")) {
            return -1;
        }
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        int n5 = jProgressBar.getOrientation();
        int n6 = super.getCacheHash(synthContext, n2, n3, n4, string);
        n6 = 31 * n6 + n5;
        return n6;
    }
}

