/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class TabbedPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.TabbedPanePainter";
    public static final int UNDEFINED = -1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int LEFT_RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int TOP_BOTTOM = 5;
    private static final String FOCUS_PLACEMENT_KEY = "JTabbedPane.focusPlacement";
    private static WeakHashMap<JComponent, Object> translucentTabbedPanes = new WeakHashMap();
    private static final String TRANSLUCENT_KEY = "Synthetica.childsAreTranslucent";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected TabbedPanePainter() {
    }

    public static TabbedPanePainter getInstance() {
        return TabbedPanePainter.getInstance(null);
    }

    public static TabbedPanePainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(TabbedPanePainter.getPainterClassName(synthContext, TabbedPanePainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = TabbedPanePainter.getInstance(synthContext, TabbedPanePainter.class, UI_KEY);
        }
        return (TabbedPanePainter)syntheticaComponentPainter;
    }

    public static void reinitialize() {
        for (JComponent jComponent : translucentTabbedPanes.keySet()) {
            jComponent.putClientProperty(TRANSLUCENT_KEY, false);
        }
        translucentTabbedPanes = new WeakHashMap();
    }

    public void paintTabbedPaneBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintTabbedPaneBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        int n6 = jTabbedPane.getTabPlacement();
        String string = this.getContentBorderImagePath(jTabbedPane, new SyntheticaState(synthContext.getComponentState()), n6);
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.contentBorder.image.sourceInsets", (Component)jTabbedPane, false);
        Insets insets2 = (Insets)insets.clone();
        ImagePainter imagePainter = new ImagePainter(jTabbedPane, null, -1, -1, -1, -1, graphics, n2, n3, n4, n5, string, insets, insets2, 0, 0, this.flipOnRTL(jTabbedPane), false);
        imagePainter.drawCenter();
    }

    public void paintTabbedPaneContentBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        graphics.setColor(SyntheticaLookAndFeel.getColor("Synthetica.tabbedPane.hideBorderColor", jTabbedPane));
        this.modifyChildOpacity(synthContext);
        this.paintTabbedPaneContentBorder(jTabbedPane, new SyntheticaState(synthContext.getComponentState()), jTabbedPane.getTabPlacement(), true, graphics, n2, n3, n4, n5);
    }

    public void paintTabbedPaneContentBorder(JComponent jComponent, SyntheticaState syntheticaState, int n2, boolean bl, Graphics graphics, int n3, int n4, int n5, int n6) {
        this.paintTabbedPaneContentBorder(jComponent, syntheticaState, n2, bl, 0, graphics, n3, n4, n5, n6);
    }

    public void paintTabbedPaneContentBorder(JComponent jComponent, SyntheticaState syntheticaState, int n2, boolean bl, int n3, Graphics graphics, int n4, int n5, int n6, int n7) {
        String string = this.getContentBorderImagePath(jComponent, syntheticaState, n2);
        UIKey uIKey = new UIKey("tabbedPane.contentBorder.image", syntheticaState, -1, n2, -1);
        Insets insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "sourceInsets", true, 1);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets2 = (Insets)insets.clone();
        int n8 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.contentBorder.horizontalTiled", jComponent, false) ? 1 : 0;
        int n9 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.contentBorder.verticalTiled", jComponent, false) ? 1 : 0;
        ImagePainter imagePainter = new ImagePainter(jComponent, null, -1, -1, -1, -1, graphics, n4, n5, n6, n7, string, insets, insets2, n8, n9, this.flipOnRTL(jComponent), false);
        imagePainter.drawBorder();
        if (bl && jComponent instanceof JTabbedPane && !SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.paintOverContentBorder.disabled", jComponent)) {
            this.drawContentBorderLine4SelectedTab((JTabbedPane)jComponent, n2, n3, graphics, n4, n5, n6, n7);
        }
    }

    private String getContentBorderImagePath(JComponent jComponent, SyntheticaState syntheticaState, int n2) {
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        if (n2 == 2 && !bl) {
            n2 = 4;
        } else if (n2 == 4 && !bl) {
            n2 = 2;
        }
        UIKey uIKey = new UIKey("tabbedPane.contentBorder.image", syntheticaState, -1, n2, -1);
        return (String)UIKey.findProperty(jComponent, uIKey.get(), null, true, 1);
    }

    protected void modifyChildOpacity(SynthContext synthContext) {
        boolean bl;
        JComponent jComponent = synthContext.getComponent();
        boolean bl2 = bl = jComponent.getClientProperty(TRANSLUCENT_KEY) == null ? false : (Boolean)jComponent.getClientProperty(TRANSLUCENT_KEY);
        if (!(SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.keepOpacity", jComponent) || bl || jComponent.getParent().getClass().getName().equals("org.flexdock.view.Viewport"))) {
            Component[] componentArray;
            jComponent.putClientProperty(TRANSLUCENT_KEY, Boolean.TRUE);
            translucentTabbedPanes.put(jComponent, null);
            Component[] componentArray2 = componentArray = jComponent.getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Component component = componentArray2[n3];
                if (component instanceof Container && !(component instanceof Window) && !(component instanceof JRootPane)) {
                    this.setComponentsTranslucent((Container)component);
                }
                ++n3;
            }
        }
    }

    private void setComponentsTranslucent(Container container) {
        Component[] componentArray;
        StyleFactory styleFactory = (StyleFactory)SynthLookAndFeel.getStyleFactory();
        boolean bl = false;
        boolean bl2 = false;
        if (container instanceof JComponent) {
            bl = ((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepOpacity") == null ? false : (Boolean)((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepOpacity");
            boolean bl3 = bl2 = ((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepChildrenOpacity") == null ? false : (Boolean)((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepChildrenOpacity");
        }
        if ((container instanceof JPanel || container instanceof JScrollPane || container instanceof JViewport) && !bl) {
            styleFactory.getComponentPropertyStore().storeComponentProperty(container, "SYCP_OPAQUE");
            if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                ((JComponent)container).setDoubleBuffered(false);
            }
            ((JComponent)container).setOpaque(false);
        } else if (container instanceof JComponent && !bl && ((componentArray = (Component[])container) instanceof JRadioButton || componentArray instanceof JCheckBox || componentArray instanceof JTextArea && !(componentArray.getParent() instanceof JViewport)) && (componentArray.getBackground() == null || componentArray.getBackground() instanceof ColorUIResource)) {
            styleFactory.getComponentPropertyStore().storeComponentProperty((Component)componentArray, "SYCP_OPAQUE");
            if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                componentArray.setDoubleBuffered(false);
            }
            componentArray.setOpaque(false);
        }
        if (bl2) {
            return;
        }
        Component[] componentArray2 = componentArray = container.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray2[n3];
            if (component instanceof Container && !(component instanceof Window) && !(component instanceof JRootPane)) {
                this.setComponentsTranslucent((Container)component);
            }
            ++n3;
        }
    }

    public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        this.paintTabbedPaneTabAreaBackground(jTabbedPane, new SyntheticaPainterState(synthContext), jTabbedPane.getTabPlacement(), 0, graphics, n2, n3, n4, n5);
    }

    public void paintTabbedPaneTabAreaBackground(JComponent jComponent, SyntheticaState syntheticaState, int n2, int n3, Graphics graphics, int n4, int n5, int n6, int n7) {
        Insets insets;
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        if (n2 == 2 && !bl) {
            n2 = 4;
        } else if (n2 == 4 && !bl) {
            n2 = 2;
        }
        UIKey uIKey = new UIKey("tabbedPane.tabArea.background.image", syntheticaState, -1, n2, -1);
        Insets insets2 = insets = SyntheticaLookAndFeel.getInsets(uIKey.get("insets"), jComponent);
        String string = SyntheticaLookAndFeel.getString(uIKey.get(), jComponent);
        if (string != null) {
            int n8 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabArea.background.horizontalTiled", jComponent, false) ? 1 : 0;
            int n9 = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabArea.background.verticalTiled", jComponent, false) ? 1 : 0;
            ImagePainter imagePainter = new ImagePainter(jComponent, null, -1, -1, -1, -1, graphics, n4, n5, n6, n7, string, insets, insets2, n8, n9, this.flipOnRTL(jComponent), false);
            imagePainter.setAngle(n3);
            imagePainter.draw();
        }
    }

    public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", jTabbedPane) && jTabbedPane.getSelectedIndex() == n6 && jTabbedPane.hasFocus()) {
            JButton jButton = new JButton();
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(jButton, Region.BUTTON);
            synthContext = new SynthContext(jButton, Region.BUTTON, synthStyle, 256);
            synthStyle.getPainter(synthContext).paintButtonBorder(synthContext, graphics, n2, n3, n4, n5);
        }
    }

    public void paintTabbedPaneTab(JComponent jComponent, SyntheticaState syntheticaState, int n2, int n3, int n4, int n5, Graphics graphics, int n6, int n7, int n8, int n9) {
        ImagePainter imagePainter;
        int n10;
        int n11;
        Color color = (Color)jComponent.getClientProperty("Synthetica.background");
        Float f2 = (Float)jComponent.getClientProperty("Synthetica.background.alpha");
        String string = "Synthetica.tabbedPane.tab." + n2 + ".background";
        Color color2 = (Color)jComponent.getClientProperty(string);
        if (color2 == null && jComponent instanceof JTabbedPane && !(((JTabbedPane)jComponent).getBackgroundAt(n2) instanceof UIResource)) {
            color2 = ((JTabbedPane)jComponent).getBackgroundAt(n2);
        }
        if (color2 != null) {
            jComponent.putClientProperty("Synthetica.background", color2);
            if (jComponent.getClientProperty(String.valueOf(string) + ".alpha") != null) {
                jComponent.putClientProperty("Synthetica.background.alpha", jComponent.getClientProperty(String.valueOf(string) + ".alpha"));
            }
        }
        String string2 = String.valueOf(n3) + "/" + n2;
        String string3 = null;
        Insets insets = null;
        String string4 = "tabbedPane.tab";
        if (syntheticaState.isSet(SyntheticaState.State.HOVER) && !syntheticaState.isSet(SyntheticaState.State.SELECTED) && !syntheticaState.isSet(SyntheticaState.State.DISABLED)) {
            string4 = String.valueOf(string4) + ".hover";
        } else if (syntheticaState.isSet(SyntheticaState.State.SELECTED)) {
            string4 = String.valueOf(string4) + ".selected";
        } else if (syntheticaState.isSet(SyntheticaState.State.DISABLED)) {
            string4 = String.valueOf(string4) + ".disabled";
        }
        if (n3 == 1) {
            string4 = String.valueOf(string4) + ".top";
        } else if (n3 == 2) {
            string4 = String.valueOf(string4) + ".left";
        } else if (n3 == 3) {
            string4 = String.valueOf(string4) + ".bottom";
        } else if (n3 == 4) {
            string4 = String.valueOf(string4) + ".right";
        }
        String string5 = SyntheticaLookAndFeel.getStyleName(jComponent);
        string3 = SyntheticaLookAndFeel.getString(string4, null, string5, true);
        insets = SyntheticaLookAndFeel.getInsets(string4, "insets", string5, true);
        if (string3 == null) {
            if (syntheticaState.isSet(SyntheticaState.State.SELECTED)) {
                string3 = this.getTabImagePath(jComponent, n3, n4, ".selected");
                if (string3 == null) {
                    string3 = n3 == 1 || n3 == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.x.image.selected", jComponent) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.y.image.selected", jComponent);
                }
            } else if (syntheticaState.isSet(SyntheticaState.State.DISABLED)) {
                string3 = this.getTabImagePath(jComponent, n3, n4, ".disabled");
            } else {
                if (syntheticaState.isSet(SyntheticaState.State.HOVER)) {
                    string3 = this.getTabImagePath(jComponent, n3, n4, ".hover");
                }
                if (string3 == null) {
                    string3 = this.getTabImagePath(jComponent, n3, n4, null);
                }
            }
        }
        Insets insets2 = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.noneSelected.background.insets", jComponent);
        if (!syntheticaState.isSet(SyntheticaState.State.SELECTED) && insets2 != null) {
            if (n3 == 1) {
                n7 += insets2.top;
            } else if (n3 == 3) {
                n9 -= insets2.bottom;
            } else if (n3 == 2) {
                n6 += insets2.left;
            } else if (n3 == 4) {
                if (n5 == 0) {
                    n8 -= insets2.right;
                } else {
                    n9 -= insets2.right;
                }
            }
        }
        if (n3 == 3) {
            insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
        }
        if (n3 == 4) {
            insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets3 = (Insets)insets.clone();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.removeDoubleBorder", jComponent)) {
            if (!(n3 != 1 && n3 != 3 || n4 != 0 && n4 != -1)) {
                insets3.right = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderXCorrection", jComponent, 0);
            } else if (n3 == 2 && (n4 == 4 || n4 == -1) && n5 != 0) {
                insets3.right = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderYCorrection", jComponent, 0);
            } else if (n3 == 4 && (n4 == 3 || n4 == -1) && n5 != 0) {
                insets3.right = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderYCorrection", jComponent, 0);
            } else if (!(n3 != 2 && n3 != 4 || n4 != 3 && n4 != -1)) {
                insets3.bottom = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderYCorrection", jComponent, 0);
            }
        }
        if (n3 == 1) {
            insets3.bottom = 0;
        } else if (n3 == 2) {
            if (n5 == 0) {
                insets3.right = 0;
            } else {
                insets3.bottom = 0;
            }
        } else if (n3 == 3) {
            insets3.top = 0;
        } else if (n3 == 4) {
            if (n5 == 0) {
                insets3.left = 0;
            } else {
                insets3.bottom = 0;
            }
        }
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbePane.tab.imageClippingEnabled", jComponent, SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.imageClippingEnabled", jComponent, true));
        if (syntheticaState.isSet(SyntheticaState.State.HOVER) && !syntheticaState.isSet(SyntheticaState.State.DISABLED) && !syntheticaState.isSet(SyntheticaState.State.SELECTED) && SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.red", jComponent, Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            n11 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.red", jComponent);
            n10 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.green", jComponent);
            int n12 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.blue", jComponent);
            Insets insets4 = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.hover.insets", jComponent);
            if (insets4 == null) {
                insets4 = new Insets(0, 0, 0, 0);
            }
            imagePainter = new ImagePainter(jComponent, n11, n10, n12, insets4, graphics, n6, n7, n8, n9, string3, insets, bl ? insets3 : insets, 0, 0, this.flipOnRTL(jComponent), false);
        } else {
            n11 = 0;
            n10 = 0;
            int n13 = 0;
            if (syntheticaState.isSet(SyntheticaState.State.HOVER)) {
                n10 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.animation.cycles", jComponent, 1);
                n11 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.animation.delay", jComponent, 50);
                n13 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.animation.type", jComponent, 1);
            } else {
                n10 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.animation.cycles", jComponent, 1);
                n11 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.animation.delay", jComponent, 50);
                n13 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.animation.type", jComponent, 2);
            }
            imagePainter = new ImagePainter(jComponent, string2, n10, n11, n13, syntheticaState.getState(), graphics, n6, n7, n8, n9, string3, insets, bl ? insets3 : insets, 0, 0, this.flipOnRTL(jComponent), false);
        }
        imagePainter.setAngle(n5);
        if (!bl) {
            imagePainter.draw();
        } else {
            if (n3 != 3) {
                imagePainter.drawTopLeft();
                imagePainter.drawTopCenter();
                imagePainter.drawTopRight();
            }
            if (n3 != 4 || n5 != 0) {
                imagePainter.drawLeft();
            }
            if (n3 != 1) {
                imagePainter.drawBottomLeft();
                imagePainter.drawBottomCenter();
                imagePainter.drawBottomRight();
            }
            if (n3 != 2 || n5 != 0) {
                imagePainter.drawRight();
            }
            imagePainter.drawCenter();
        }
        jComponent.putClientProperty("Synthetica.background", color);
        jComponent.putClientProperty("Synthetica.background.alpha", f2);
        if (syntheticaState.isSet(SyntheticaState.State.FOCUSED)) {
            int n14 = n11 = jComponent.getClientProperty(FOCUS_PLACEMENT_KEY) == null ? -1 : (Integer)jComponent.getClientProperty(FOCUS_PLACEMENT_KEY);
            if (n11 != -1) {
                n3 = n11;
            }
            String string6 = "";
            if (n3 == 1) {
                string6 = "focus.tabbedPane.tab.top";
            } else if (n3 == 3) {
                string6 = "focus.tabbedPane.tab.bottom";
            } else if (n3 == 2) {
                string6 = "focus.tabbedPane.tab.left";
            } else if (n3 == 4) {
                string6 = "focus.tabbedPane.tab.right";
            }
            FocusPainter.paintFocus(string6, jComponent, syntheticaState.getState(), string2, n5, graphics, n6, n7, n8, n9);
        }
    }

    private String getTabImagePath(JComponent jComponent, int n2, int n3, String string) {
        String string2 = null;
        if (string == null) {
            string = "";
        }
        string2 = n3 == 0 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.left.image" + string, jComponent) : (n3 == 1 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.right.image" + string, jComponent) : (n3 == 2 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.leftRight.image" + string, jComponent) : (n3 == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.top.image" + string, jComponent) : (n3 == 4 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.bottom.image" + string, jComponent) : (n3 == 5 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.topBottom.image" + string, jComponent) : (n2 == 1 || n2 == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.middle.image" + string, jComponent) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.center.image" + string, jComponent)))))));
        return string2;
    }

    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        int n8 = jTabbedPane.getTabPlacement();
        int n9 = this.getTabPosition(jTabbedPane, n6);
        SyntheticaState syntheticaState = new SyntheticaState(synthContext.getComponentState());
        Integer n10 = (Integer)jTabbedPane.getClientProperty("Synthetica.MOUSE_OVER");
        int n11 = n7 = n10 == null ? -1 : n10;
        if (n7 == n6) {
            syntheticaState.setState(SyntheticaState.State.HOVER);
        }
        if (!jTabbedPane.isEnabledAt(n6)) {
            syntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        this.paintTabbedPaneTab(jTabbedPane, syntheticaState, n6, n8, n9, 0, graphics, n2, n3, n4, n5);
    }

    protected int getTabPosition(JTabbedPane jTabbedPane, int n2) {
        if (n2 < 0) {
            return -1;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (jTabbedPane.getTabPlacement() == 1 || jTabbedPane.getTabPlacement() == 3) {
            TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Rectangle rectangle = (Rectangle)object;
                    Rectangle rectangle2 = (Rectangle)object2;
                    if (rectangle.x > rectangle2.x) {
                        return 1;
                    }
                    if (rectangle.x < rectangle2.x) {
                        return -1;
                    }
                    return 0;
                }
            });
            TreeMap<Object, Integer> treeMap2 = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Rectangle rectangle = (Rectangle)object;
                    Rectangle rectangle2 = (Rectangle)object2;
                    if (rectangle.x + rectangle.width < rectangle2.x + rectangle2.width) {
                        return 1;
                    }
                    if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                        return -1;
                    }
                    return 0;
                }
            });
            int n3 = 0;
            while (n3 < jTabbedPane.getTabCount()) {
                treeMap.put(jTabbedPane.getBoundsAt(n3), new Integer(n3));
                ++n3;
            }
            if (treeMap.headMap(jTabbedPane.getBoundsAt(n2)).size() == 0) {
                bl = true;
            }
            n3 = 0;
            while (n3 < jTabbedPane.getTabCount()) {
                treeMap2.put(jTabbedPane.getBoundsAt(n3), new Integer(n3));
                ++n3;
            }
            if (treeMap2.headMap(jTabbedPane.getBoundsAt(n2)).size() == 0) {
                bl2 = true;
            }
            if (bl && bl2) {
                return 2;
            }
            if (bl) {
                return 0;
            }
            if (bl2) {
                return 1;
            }
        } else {
            TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Rectangle rectangle = (Rectangle)object;
                    Rectangle rectangle2 = (Rectangle)object2;
                    if (rectangle.y > rectangle2.y) {
                        return 1;
                    }
                    if (rectangle.y < rectangle2.y) {
                        return -1;
                    }
                    return 0;
                }
            });
            TreeMap<Object, Integer> treeMap3 = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Rectangle rectangle = (Rectangle)object;
                    Rectangle rectangle2 = (Rectangle)object2;
                    if (rectangle.y + rectangle.height < rectangle2.y + rectangle2.height) {
                        return 1;
                    }
                    if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                        return -1;
                    }
                    return 0;
                }
            });
            int n4 = 0;
            while (n4 < jTabbedPane.getTabCount()) {
                treeMap.put(jTabbedPane.getBoundsAt(n4), new Integer(n4));
                ++n4;
            }
            if (treeMap.headMap(jTabbedPane.getBoundsAt(n2)).size() == 0) {
                bl3 = true;
            }
            n4 = 0;
            while (n4 < jTabbedPane.getTabCount()) {
                treeMap3.put(jTabbedPane.getBoundsAt(n4), new Integer(n4));
                ++n4;
            }
            if (treeMap3.headMap(jTabbedPane.getBoundsAt(n2)).size() == 0) {
                bl4 = true;
            }
            if (bl3 && bl4) {
                return 5;
            }
            if (bl3) {
                return 3;
            }
            if (bl4) {
                return 4;
            }
        }
        return -1;
    }

    private void drawContentBorderLine4SelectedTab(JTabbedPane jTabbedPane, int n2, int n3, Graphics graphics, int n4, int n5, int n6, int n7) {
        int n8;
        String string;
        if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane) != null && !SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane) && this.getSelectedRun(jTabbedPane) != 0) {
            return;
        }
        if (n2 == 1 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.top", jTabbedPane) != null) {
            string = SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.top", jTabbedPane);
        } else if (n2 == 3 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.bottom", jTabbedPane) != null) {
            string = SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.bottom", jTabbedPane);
        } else if (n2 == 2 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.left", jTabbedPane) != null) {
            string = SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.left", jTabbedPane);
        } else if (n2 == 4 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.right", jTabbedPane) != null) {
            string = SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.right", jTabbedPane);
        } else {
            int n9 = this.getTabPosition(jTabbedPane, jTabbedPane.getSelectedIndex());
            string = this.getTabImagePath(jTabbedPane, n2, n9, ".selected");
            if (string == null) {
                string = n2 == 1 || n2 == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.x.image.selected", jTabbedPane) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.y.image.selected", jTabbedPane);
            }
        }
        if (string == null) {
            return;
        }
        Image image = imgCache.get(string);
        if (image == null) {
            image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
            imgCache.put(string, image);
        }
        int n10 = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.removeDoubleBorder", jTabbedPane)) {
            n8 = 0;
            int n11 = this.getTabPosition(jTabbedPane, jTabbedPane.getSelectedIndex());
            if ((n2 == 1 || n2 == 3) && n11 == 1) {
                n8 = 1;
            } else if (n3 != 0 && n2 == 4 && n11 == 4) {
                n8 = 1;
            } else if (n3 != 0 && n2 == 2 && n11 == 3) {
                n8 = 1;
            }
            if (n8 == 0) {
                n10 = 1;
            }
        }
        if ((n8 = jTabbedPane.getSelectedIndex()) == -1) {
            return;
        }
        Rectangle rectangle = (Rectangle)jTabbedPane.getClientProperty("JTabbedPane.visibleSelectedTabRect");
        if (rectangle == null) {
            rectangle = jTabbedPane.getBoundsAt(n8);
        }
        String string2 = "tabbedPane.tab.selected";
        if (n2 == 1) {
            string2 = String.valueOf(string2) + ".top";
        } else if (n2 == 2) {
            string2 = String.valueOf(string2) + ".left";
        } else if (n2 == 3) {
            string2 = String.valueOf(string2) + ".bottom";
        } else if (n2 == 4) {
            string2 = String.valueOf(string2) + ".right";
        }
        Insets insets = SyntheticaLookAndFeel.getInsets(string2, "insets", SyntheticaLookAndFeel.getStyleName(jTabbedPane), true);
        insets = (Insets)insets.clone();
        if (rectangle.width < insets.left + insets.right || rectangle.height < insets.top + insets.bottom) {
            return;
        }
        if (n2 == 3) {
            insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
        } else if (n2 == 4) {
            insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        Insets insets2 = new Insets(0, 0, 0, 0);
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.useFillAsContentBorder", jTabbedPane, true);
        if (n2 == 1) {
            insets.top = image.getHeight(null) + (bl ? -insets.bottom - 1 : 0);
            insets2.left = insets.left;
            insets2.right = insets.right - n10;
            n4 = rectangle.x;
            n6 = rectangle.width + n10;
            n7 = 1;
        } else if (n2 == 3) {
            insets.bottom = image.getHeight(null) + (bl ? -insets.top - 1 : 0);
            insets2.left = insets.left;
            insets2.right = insets.right - n10;
            n4 = rectangle.x;
            n5 = n5 + n7 - 1;
            n6 = rectangle.width + n10;
            n7 = 1;
        } else if (n2 == 2) {
            if (n3 == 0) {
                insets.left = image.getWidth(null) + (bl ? -insets.right - 1 : 0);
                insets2.top = insets.top;
                insets2.bottom = insets.bottom - n10;
            } else {
                insets.top = image.getHeight(null) + (bl ? -insets.bottom - 1 : 0);
                insets2.left = insets.left;
                insets2.right = insets.right - n10;
            }
            n4 = rectangle.x + rectangle.width;
            n5 = n3 == 0 ? rectangle.y : rectangle.y - n10;
            n6 = n3 == 0 ? 1 : rectangle.height + n10;
            n7 = n3 == 0 ? rectangle.height + n10 : 1;
        } else if (n2 == 4) {
            if (n3 == 0) {
                insets.right = image.getWidth(null) + (bl ? -insets.left - 1 : 0);
                insets2.top = insets.top;
                insets2.bottom = insets.bottom - n10;
            } else {
                insets.top = image.getHeight(null) + (bl ? -insets.bottom - 1 : 0);
                insets2.left = insets.left;
                insets2.right = insets.right - n10;
            }
            n4 = rectangle.x - 1;
            n5 = rectangle.y;
            n6 = n3 == 0 ? 1 : rectangle.height + n10;
            n7 = n3 == 0 ? rectangle.height + n10 : 1;
        }
        ImagePainter imagePainter = new ImagePainter(jTabbedPane, null, -1, -1, -1, -1, graphics, n4, n5, n6, n7, string, insets, insets2, 0, 0, this.flipOnRTL(jTabbedPane), false);
        imagePainter.setAngle(n3);
        if (n3 != 0 || n2 == 1 || n2 == 3) {
            imagePainter.drawLeft();
            imagePainter.drawRight();
        } else {
            imagePainter.drawTopCenter();
            imagePainter.drawBottomCenter();
        }
        imagePainter.drawCenter();
    }

    public boolean paintTabbedPaneTabText(SynthContext synthContext, Graphics graphics, String string, int n2, int n3, int n4) {
        return true;
    }

    protected boolean flipOnRTL(JComponent jComponent) {
        return jComponent.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT && SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.horizontalFlipOnRTL.enabled", jComponent);
    }

    protected int getSelectedRun(JTabbedPane jTabbedPane) {
        if (!(jTabbedPane.getUI() instanceof BasicTabbedPaneUI)) {
            return -1;
        }
        BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
        int n2 = jTabbedPane.getSelectedIndex();
        int n3 = jTabbedPane.getTabCount();
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            try {
                Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                Method method = clazz.getDeclaredMethod("getRunForTab", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)basicTabbedPaneUI, n3, n2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return -1;
    }

    public Cacheable.ScaleType getCacheScaleType(String string) {
        if (string.equals("paintTabbedPaneBorder") || string.equals("paintTabbedPaneBackground") || string.equals("paintTabbedPaneContentBorder") || string.equals("paintTabbedPaneContentBackground")) {
            return Cacheable.ScaleType.NINE_SQUARE;
        }
        return super.getCacheScaleType(string);
    }

    public int getCacheHash(SynthContext synthContext, int n2, int n3, int n4, String string) {
        if (string.equals("paintTabbedPaneBorder") || string.equals("paintTabbedPaneBackground") || string.equals("paintTabbedPaneContentBorder") || string.equals("paintTabbedPaneContentBackground")) {
            return -1;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        int n5 = super.getCacheHash(synthContext, n2, n3, n4, string);
        if (string.equals("paintTabbedPaneTabBackground") || string.equals("paintTabbedPaneTabBorder")) {
            n5 = n5 * 31 + jTabbedPane.getTabPlacement();
            n5 = n5 * 31 + this.getTabPosition(jTabbedPane, n4);
            Integer n6 = (Integer)jTabbedPane.getClientProperty("Synthetica.MOUSE_OVER");
            n5 = n5 * 31 + (n6 == null ? 1000 : n6);
        }
        return n5;
    }
}

