/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util.java2d;

import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class DropShadow {
    private boolean highQuality = true;
    private BufferedImage shadow = null;
    private BufferedImage originalImage = null;
    private float angle = 45.0f;
    private int distance = -5;
    private int shadowSize = 5;
    private float shadowOpacity = 0.8f;
    private Color shadowColor = new Color(0);
    private int distance_x = 0;
    private int distance_y = 0;

    protected DropShadow() {
        this.computeShadowPosition();
    }

    public DropShadow(BufferedImage bufferedImage) {
        this();
        this.setImage(bufferedImage);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.originalImage = bufferedImage;
        this.refreshShadow();
    }

    public BufferedImage getImage() {
        return this.originalImage;
    }

    public boolean getHighQuality() {
        return this.highQuality;
    }

    public void setQuality(boolean bl) {
        this.highQuality = bl;
        this.refreshShadow();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f2) {
        this.angle = f2;
        this.computeShadowPosition();
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int n2) {
        this.distance = n2;
        this.computeShadowPosition();
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        this.refreshShadow();
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float f2) {
        this.shadowOpacity = f2;
        this.refreshShadow();
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int n2) {
        this.shadowSize = n2;
        this.refreshShadow();
    }

    private void refreshShadow() {
        if (this.originalImage != null) {
            this.shadow = this.createDropShadow(this.originalImage);
        }
    }

    private void computeShadowPosition() {
        double d2 = Math.toRadians(this.angle);
        this.distance_x = (int)(Math.cos(d2) * (double)this.distance);
        this.distance_y = (int)(Math.sin(d2) * (double)this.distance);
    }

    private BufferedImage createDropShadow(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + this.shadowSize * 2, bufferedImage.getHeight() + this.shadowSize * 2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, this.shadowSize, this.shadowSize);
        graphics2D.dispose();
        if (this.highQuality) {
            BufferedImage bufferedImage3 = this.createShadowMask(bufferedImage2);
            Synthetica2DUtils.createBlurOp(this.shadowSize).filter(bufferedImage3, bufferedImage2);
        } else {
            this.applyShadow(bufferedImage2);
        }
        return bufferedImage2;
    }

    private void applyShadow(BufferedImage bufferedImage) {
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = this.shadowSize - 1 >> 1;
        int n8 = this.shadowSize - n7;
        int n9 = n7;
        int n10 = n5 - n8;
        int n11 = n7;
        int n12 = n6 - n8;
        int n13 = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] nArray = new int[this.shadowSize];
        int n14 = 0;
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n15 = n8 * n5;
        float f2 = this.shadowOpacity / (float)this.shadowSize;
        int n16 = 0;
        int n17 = 0;
        while (n16 < n6) {
            n4 = 0;
            n14 = 0;
            n3 = 0;
            while (n3 < this.shadowSize) {
                nArray[n3] = n2 = nArray2[n17] >>> 24;
                n4 += n2;
                ++n3;
                ++n17;
            }
            n17 -= n8;
            n3 = n9;
            while (n3 < n10) {
                n2 = (int)((float)n4 * f2);
                nArray2[n17] = n2 << 24 | n13;
                n4 -= nArray[n14];
                nArray[n14] = n2 = nArray2[n17 + n8] >>> 24;
                n4 += n2;
                if (++n14 >= this.shadowSize) {
                    n14 -= this.shadowSize;
                }
                ++n3;
                ++n17;
            }
            n17 = ++n16 * n5;
        }
        n16 = 0;
        n17 = 0;
        while (n16 < n5) {
            n4 = 0;
            n14 = 0;
            n3 = 0;
            while (n3 < this.shadowSize) {
                nArray[n3] = n2 = nArray2[n17] >>> 24;
                n4 += n2;
                ++n3;
                n17 += n5;
            }
            n17 -= n15;
            n3 = n11;
            while (n3 < n12) {
                n2 = (int)((float)n4 * f2);
                nArray2[n17] = n2 << 24 | n13;
                n4 -= nArray[n14];
                nArray[n14] = n2 = nArray2[n17 + n15] >>> 24;
                n4 += n2;
                if (++n14 >= this.shadowSize) {
                    n14 -= this.shadowSize;
                }
                ++n3;
                n17 += n5;
            }
            n17 = ++n16;
        }
    }

    private BufferedImage createShadowMask(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(5, this.shadowOpacity));
        graphics2D.setColor(this.shadowColor);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage2;
    }

    public void paintShadow(Graphics graphics, int n2, int n3) {
        if (this.shadow != null) {
            graphics.drawImage(this.shadow, n2 + this.distance_x, n3 + this.distance_y, null);
        }
    }

    public void paint(Graphics graphics, int n2, int n3) {
        this.paint(graphics, n2, n3, true);
    }

    public void paint(Graphics graphics, int n2, int n3, boolean bl) {
        if (bl) {
            this.paintShadow(graphics, n2, n3);
        }
        if (this.originalImage != null) {
            graphics.drawImage(this.originalImage, n2, n3, null);
        }
    }
}

