/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.HashCodeUtil;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingPolytope
extends Bounds {
    Vector4d[] planes;
    double[] mag;
    double[] pDotN;
    Point3d[] verts;
    int nVerts;
    Point3d centroid = new Point3d();
    Point3d[] boxVerts;
    boolean allocBoxVerts = false;

    public BoundingPolytope(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.boundId = 4;
        this.planes = new Vector4d[vector4dArray.length];
        this.mag = new double[vector4dArray.length];
        this.pDotN = new double[vector4dArray.length];
        for (int i2 = 0; i2 < vector4dArray.length; ++i2) {
            this.mag[i2] = Math.sqrt(vector4dArray[i2].x * vector4dArray[i2].x + vector4dArray[i2].y * vector4dArray[i2].y + vector4dArray[i2].z * vector4dArray[i2].z);
            double d2 = 1.0 / this.mag[i2];
            this.planes[i2] = new Vector4d(vector4dArray[i2].x * d2, vector4dArray[i2].y * d2, vector4dArray[i2].z * d2, vector4dArray[i2].w * d2);
        }
        this.computeAllVerts();
    }

    public BoundingPolytope() {
        this.boundId = 4;
        this.planes = new Vector4d[6];
        this.mag = new double[this.planes.length];
        this.pDotN = new double[this.planes.length];
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.computeAllVerts();
    }

    public BoundingPolytope(Bounds bounds) {
        this.boundId = 4;
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = bounds.boundsIsEmpty;
        this.boundsIsInfinite = bounds.boundsIsInfinite;
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(boundingSphere.center.x + boundingSphere.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, boundingSphere.center.x - boundingSphere.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(boundingSphere.center.y + boundingSphere.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, boundingSphere.center.y - boundingSphere.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(boundingSphere.center.z + boundingSphere.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, boundingSphere.center.z - boundingSphere.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.planes = new Vector4d[6];
            this.pDotN = new double[this.planes.length];
            this.mag = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -boundingBox.upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, boundingBox.lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -boundingBox.upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, boundingBox.lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -boundingBox.upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, boundingBox.lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (bounds.boundId == 4) {
            int n2;
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.planes = new Vector4d[boundingPolytope.planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = boundingPolytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (n2 = 0; n2 < this.planes.length; ++n2) {
                this.planes[n2] = new Vector4d(boundingPolytope.planes[n2]);
                this.mag[n2] = boundingPolytope.mag[n2];
                this.pDotN[n2] = boundingPolytope.pDotN[n2];
            }
            for (n2 = 0; n2 < this.verts.length; ++n2) {
                this.verts[n2] = new Point3d(boundingPolytope.verts[n2]);
            }
            this.centroid = boundingPolytope.centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope0"));
        }
    }

    public BoundingPolytope(Bounds[] boundsArray) {
        Bounds bounds;
        int n2;
        this.boundId = 4;
        if (boundsArray == null || boundsArray.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        for (n2 = 0; boundsArray[n2] == null && n2 < boundsArray.length; ++n2) {
        }
        if (n2 >= boundsArray.length) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = boundsArray[n2].boundsIsEmpty;
        this.boundsIsInfinite = boundsArray[n2].boundsIsInfinite;
        if (boundsArray[n2].boundId == 2) {
            bounds = (BoundingSphere)boundsArray[n2];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(bounds.center.x + bounds.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, bounds.center.x - bounds.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(bounds.center.y + bounds.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, bounds.center.y - bounds.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(bounds.center.z + bounds.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, bounds.center.z - bounds.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsArray[n2].boundId == 1) {
            bounds = (BoundingBox)boundsArray[n2];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -((BoundingBox)bounds).upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, ((BoundingBox)bounds).lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -((BoundingBox)bounds).upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, ((BoundingBox)bounds).lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -((BoundingBox)bounds).upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, ((BoundingBox)bounds).lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsArray[n2].boundId == 4) {
            bounds = (BoundingPolytope)boundsArray[n2];
            this.planes = new Vector4d[((BoundingPolytope)bounds).planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = ((BoundingPolytope)bounds).nVerts;
            this.verts = new Point3d[this.nVerts];
            for (n2 = 0; n2 < this.planes.length; ++n2) {
                this.planes[n2] = new Vector4d(((BoundingPolytope)bounds).planes[n2]);
                this.pDotN[n2] = ((BoundingPolytope)bounds).pDotN[n2];
                this.mag[n2] = ((BoundingPolytope)bounds).mag[n2];
            }
            for (n2 = 0; n2 < this.verts.length; ++n2) {
                this.verts[n2] = new Point3d(((BoundingPolytope)bounds).verts[n2]);
            }
            this.centroid = ((BoundingPolytope)bounds).centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope1"));
        }
        ++n2;
        while (n2 < boundsArray.length) {
            this.combine(boundsArray[n2]);
            ++n2;
        }
    }

    public void setPlanes(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.planes = new Vector4d[vector4dArray.length];
        this.pDotN = new double[vector4dArray.length];
        this.mag = new double[vector4dArray.length];
        this.boundsIsEmpty = false;
        if (vector4dArray.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        for (int i2 = 0; i2 < vector4dArray.length; ++i2) {
            this.mag[i2] = Math.sqrt(vector4dArray[i2].x * vector4dArray[i2].x + vector4dArray[i2].y * vector4dArray[i2].y + vector4dArray[i2].z * vector4dArray[i2].z);
            double d2 = 1.0 / this.mag[i2];
            this.planes[i2] = new Vector4d(vector4dArray[i2].x * d2, vector4dArray[i2].y * d2, vector4dArray[i2].z * d2, vector4dArray[i2].w * d2);
        }
        this.computeAllVerts();
    }

    public void getPlanes(Vector4d[] vector4dArray) {
        for (int i2 = 0; i2 < vector4dArray.length; ++i2) {
            vector4dArray[i2].x = this.planes[i2].x * this.mag[i2];
            vector4dArray[i2].y = this.planes[i2].y * this.mag[i2];
            vector4dArray[i2].z = this.planes[i2].z * this.mag[i2];
            vector4dArray[i2].w = this.planes[i2].w * this.mag[i2];
        }
    }

    public int getNumPlanes() {
        return this.planes.length;
    }

    public void set(Bounds bounds) {
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            for (int i2 = 0; i2 < this.planes.length; ++i2) {
                this.planes[i2].w = -(boundingSphere.center.x * this.planes[i2].x + boundingSphere.center.y * this.planes[i2].y + boundingSphere.center.z * this.planes[i2].z + boundingSphere.radius);
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
            this.computeAllVerts();
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            for (int i3 = 0; i3 < this.planes.length; ++i3) {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9 = boundingBox.upper.x * this.planes[i3].x;
                double d10 = boundingBox.upper.y * this.planes[i3].y;
                double d11 = boundingBox.upper.z * this.planes[i3].z;
                double d12 = boundingBox.lower.x * this.planes[i3].x;
                double d13 = boundingBox.lower.y * this.planes[i3].y;
                double d14 = boundingBox.lower.z * this.planes[i3].z;
                this.planes[i3].w = -(d9 + d10 + d11);
                double d15 = d9 + d10 + d14;
                if (d8 + this.planes[i3].w > 0.0) {
                    this.planes[i3].w = -d15;
                }
                d15 = d9 + d13 + d11;
                if (d7 + this.planes[i3].w > 0.0) {
                    this.planes[i3].w = -d15;
                }
                d15 = d9 + d13 + d14;
                if (d6 + this.planes[i3].w > 0.0) {
                    this.planes[i3].w = -d15;
                }
                d15 = d12 + d10 + d11;
                if (d5 + this.planes[i3].w > 0.0) {
                    this.planes[i3].w = -d15;
                }
                d15 = d12 + d10 + d14;
                if (d4 + this.planes[i3].w > 0.0) {
                    this.planes[i3].w = -d15;
                }
                d15 = d12 + d13 + d11;
                if (d3 + this.planes[i3].w > 0.0) {
                    this.planes[i3].w = -d15;
                }
                d15 = d12 + d13 + d14;
                if (!(d2 + this.planes[i3].w > 0.0)) continue;
                this.planes[i3].w = -d15;
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
            this.computeAllVerts();
        } else if (bounds.boundId == 4) {
            int n2;
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.planes.length != boundingPolytope.planes.length) {
                this.planes = new Vector4d[boundingPolytope.planes.length];
                for (n2 = 0; n2 < boundingPolytope.planes.length; ++n2) {
                    this.planes[n2] = new Vector4d();
                }
                this.mag = new double[boundingPolytope.planes.length];
                this.pDotN = new double[boundingPolytope.planes.length];
            }
            for (int i4 = 0; i4 < boundingPolytope.planes.length; ++i4) {
                this.planes[i4].x = boundingPolytope.planes[i4].x;
                this.planes[i4].y = boundingPolytope.planes[i4].y;
                this.planes[i4].z = boundingPolytope.planes[i4].z;
                this.planes[i4].w = boundingPolytope.planes[i4].w;
                this.mag[i4] = boundingPolytope.mag[i4];
            }
            this.nVerts = boundingPolytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (n2 = 0; n2 < this.nVerts; ++n2) {
                this.verts[n2] = new Point3d(boundingPolytope.verts[n2]);
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope2"));
        }
    }

    public Object clone() {
        return new BoundingPolytope(this.planes);
    }

    public boolean equals(Object object) {
        try {
            BoundingPolytope boundingPolytope = (BoundingPolytope)object;
            if (this.planes.length != boundingPolytope.planes.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.planes.length; ++i2) {
                if (this.planes[i2].equals(boundingPolytope.planes[i2])) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l2 = 1L;
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.planes[i2].x);
            l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.planes[i2].y);
            l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.planes[i2].z);
            l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.planes[i2].w);
        }
        return (int)(l2 ^ l2 >> 32);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        this.boundsIsEmpty = bounds.boundsIsEmpty;
        this.boundsIsInfinite = bounds.boundsIsInfinite;
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            for (int i2 = 0; i2 < this.planes.length; ++i2) {
                double d2 = boundingSphere.radius + boundingSphere.center.x * this.planes[i2].x + boundingSphere.center.y * this.planes[i2].y + boundingSphere.center.z * this.planes[i2].z + this.planes[i2].w;
                if (!(d2 > 0.0)) continue;
                this.planes[i2].w += -d2;
            }
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (!this.allocBoxVerts) {
                this.boxVerts = new Point3d[8];
                for (int i3 = 0; i3 < 8; ++i3) {
                    this.boxVerts[i3] = new Point3d();
                }
                this.allocBoxVerts = true;
            }
            this.boxVerts[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            this.boxVerts[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
            this.boxVerts[2].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
            this.boxVerts[3].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
            this.boxVerts[4].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
            this.boxVerts[5].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
            this.boxVerts[6].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
            this.boxVerts[7].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
            this.combine(this.boxVerts);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.combine(boundingPolytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope3"));
        }
        this.computeAllVerts();
    }

    public void combine(Bounds[] boundsArray) {
        int n2;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (n2 = 0; n2 < boundsArray.length && (boundsArray[n2] == null || boundsArray[n2].boundsIsEmpty); ++n2) {
        }
        if (n2 >= boundsArray.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsArray[n2++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (n2 < boundsArray.length) {
            if (boundsArray[n2] != null && !boundsArray[n2].boundsIsEmpty) {
                int n3;
                Bounds bounds;
                if (boundsArray[n2].boundsIsInfinite) {
                    this.set(boundsArray[n2]);
                    break;
                }
                if (boundsArray[n2].boundId == 2) {
                    bounds = (BoundingSphere)boundsArray[n2];
                    for (n3 = 0; n3 < this.planes.length; ++n3) {
                        double d2 = bounds.radius + bounds.center.x * this.planes[n3].x + bounds.center.y * this.planes[n3].y + bounds.center.z * this.planes[n3].z + this.planes[n3].w;
                        if (!(d2 > 0.0)) continue;
                        this.planes[n3].w += -d2;
                    }
                } else if (boundsArray[n2].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n2];
                    if (!this.allocBoxVerts) {
                        this.boxVerts = new Point3d[8];
                        for (n3 = 0; n3 < 8; ++n3) {
                            this.boxVerts[n3] = new Point3d();
                        }
                        this.allocBoxVerts = true;
                    }
                    this.boxVerts[0].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[1].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[2].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[3].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[4].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z);
                    this.boxVerts[5].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z);
                    this.boxVerts[6].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z);
                    this.boxVerts[7].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z);
                    this.combine(this.boxVerts);
                } else if (boundsArray[n2] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n2];
                    this.combine(((BoundingPolytope)bounds).verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope4"));
                }
            }
            this.computeAllVerts();
            ++n2;
        }
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = 1;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point3d.x, point3d.y, point3d.z);
            for (int i2 = 0; i2 < this.planes.length; ++i2) {
                this.pDotN[i2] = 0.0;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point3d.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point3d.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point3d.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point3d.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point3d.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point3d.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point3d.x;
            this.centroid.y = point3d.y;
            this.centroid.z = point3d.z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        } else {
            for (int i3 = 0; i3 < this.planes.length; ++i3) {
                double d2 = point3d.x * this.planes[i3].x + point3d.y * this.planes[i3].y + point3d.z * this.planes[i3].z + this.planes[i3].w;
                if (!(d2 > 0.0)) continue;
                this.planes[i3].w += -d2;
            }
            this.computeAllVerts();
        }
    }

    public void combine(Point3d[] point3dArray) {
        int n2;
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = point3dArray.length;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point3dArray[0].x, point3dArray[0].y, point3dArray[0].z);
            for (n2 = 0; n2 < this.planes.length; ++n2) {
                this.pDotN[n2] = 0.0;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point3dArray[0].x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point3dArray[0].x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point3dArray[0].y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point3dArray[0].y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point3dArray[0].z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point3dArray[0].z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point3dArray[0].x;
            this.centroid.y = point3dArray[0].y;
            this.centroid.z = point3dArray[0].z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        }
        for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            for (n2 = 0; n2 < this.planes.length; ++n2) {
                double d2 = point3dArray[i2].x * this.planes[n2].x + point3dArray[i2].y * this.planes[n2].y + point3dArray[i2].z * this.planes[n2].z + this.planes[n2].w;
                if (!(d2 > 0.0)) continue;
                this.planes[n2].w += -d2;
            }
        }
        this.computeAllVerts();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = new BoundingSphere((BoundingSphere)bounds);
            boundingSphere.transform(transform3D);
            this.set(boundingSphere);
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = new BoundingBox((BoundingBox)bounds);
            boundingBox.transform(transform3D);
            this.set(boundingBox);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = new BoundingPolytope((BoundingPolytope)bounds);
            boundingPolytope.transform(transform3D);
            this.set(boundingPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope5"));
        }
    }

    public void transform(Transform3D transform3D) {
        int n2;
        if (this.boundsIsInfinite) {
            return;
        }
        Transform3D transform3D2 = new Transform3D(transform3D);
        transform3D2.invert();
        transform3D2.transpose();
        for (n2 = 0; n2 < this.planes.length; ++n2) {
            this.planes[n2].x *= this.mag[n2];
            this.planes[n2].y *= this.mag[n2];
            this.planes[n2].z *= this.mag[n2];
            this.planes[n2].w *= this.mag[n2];
            transform3D2.transform(this.planes[n2]);
        }
        for (n2 = 0; n2 < this.planes.length; ++n2) {
            this.mag[n2] = Math.sqrt(this.planes[n2].x * this.planes[n2].x + this.planes[n2].y * this.planes[n2].y + this.planes[n2].z * this.planes[n2].z);
            double d2 = 1.0 / this.mag[n2];
            this.planes[n2] = new Vector4d(this.planes[n2].x * d2, this.planes[n2].y * d2, this.planes[n2].z * d2, this.planes[n2].w * d2);
        }
        for (n2 = 0; n2 < this.verts.length; ++n2) {
            transform3D.transform(this.verts[n2]);
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point3d2.x = point3d.x;
            point3d2.y = point3d.y;
            point3d2.z = point3d.z;
            return true;
        }
        double d2 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d3 = vector3d.x * d2;
        double d4 = vector3d.y * d2;
        double d5 = vector3d.z * d2;
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = this.planes[i2].x * d3 + this.planes[i2].y * d4 + this.planes[i2].z * d5;
            double d11 = -(this.planes[i2].x * point3d.x + this.planes[i2].y * point3d.y + this.planes[i2].z * point3d.z + this.planes[i2].w);
            if (d10 == 0.0 || !((d9 = d11 / d10) >= 0.0) || !this.pointInPolytope(d8 = point3d.x + d3 * d9, d7 = point3d.y + d4 * d9, d6 = point3d.z + d5 * d9)) continue;
            point3d2.x = d8;
            point3d2.y = d7;
            point3d2.z = d6;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d2 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d3 = vector3d.x * d2;
        double d4 = vector3d.y * d2;
        double d5 = vector3d.z * d2;
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = this.planes[i2].x * d3 + this.planes[i2].y * d4 + this.planes[i2].z * d5;
            double d11 = -(this.planes[i2].x * point3d.x + this.planes[i2].y * point3d.y + this.planes[i2].z * point3d.z + this.planes[i2].w);
            if (d10 == 0.0 || !((d9 = d11 / d10) >= 0.0) || !this.pointInPolytope(d8 = point3d.x + d3 * d9, d7 = point3d.y + d4 * d9, d6 = point3d.z + d5 * d9)) continue;
            point4d.x = d8;
            point4d.y = d7;
            point4d.z = d6;
            point4d.w = d9;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            if (!(point3d.x * this.planes[i2].x + point3d.y * this.planes[i2].y + point3d.z * this.planes[i2].z + this.planes[i2].w > 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Point3d point3d3 = new Point3d();
        point3d3.x = point3d2.x - point3d.x;
        point3d3.y = point3d2.y - point3d.y;
        point3d3.z = point3d2.z - point3d.z;
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = this.planes[i2].x * point3d3.x + this.planes[i2].y * point3d3.y + this.planes[i2].z * point3d3.z;
            double d7 = -(this.planes[i2].x * point3d.x + this.planes[i2].y * point3d.y + this.planes[i2].z * point3d.z + this.planes[i2].w);
            if (d6 == 0.0 || !((d5 = d7 / d6) >= 0.0) || !this.pointInPolytope(d4 = point3d.x + point3d3.x * d5, d3 = point3d.y + point3d3.y * d5, d2 = point3d.z + point3d3.z * d5) || !(d5 <= 1.0)) continue;
            point4d.x = d4;
            point4d.y = d3;
            point4d.z = d2;
            point4d.w = d5;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = this.planes[i2].x * vector3d.x + this.planes[i2].y * vector3d.y + this.planes[i2].z * vector3d.z;
            double d7 = -(this.planes[i2].x * point3d.x + this.planes[i2].y * point3d.y + this.planes[i2].z * point3d.z + this.planes[i2].w);
            if (d6 == 0.0 || !((d5 = d7 / d6) >= 0.0) || !this.pointInPolytope(d4 = point3d.x + vector3d.x * d5, d3 = point3d.y + vector3d.y * d5, d2 = point3d.z + vector3d.z * d5)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty || this.nVerts <= 0;
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            if (!(point3d.x * this.planes[i2].x + point3d.y * this.planes[i2].y + point3d.z * this.planes[i2].z + this.planes[i2].w > 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || bounds.boundsIsInfinite) {
            return true;
        }
        if (bounds.boundId == 2) {
            return this.intersect_ptope_sphere(this, (BoundingSphere)bounds);
        }
        if (bounds.boundId == 1) {
            return this.intersect_ptope_abox(this, (BoundingBox)bounds);
        }
        if (bounds.boundId == 4) {
            return this.intersect_ptope_ptope(this, (BoundingPolytope)bounds);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i2 = 0; i2 < boundsArray.length; ++i2) {
            if (boundsArray[i2] != null && !boundsArray[i2].boundsIsEmpty && (this.boundsIsInfinite || boundsArray[i2].boundsIsInfinite)) {
                return true;
            }
            if (boundsArray[i2].boundId == 2) {
                BoundingSphere boundingSphere = (BoundingSphere)boundsArray[i2];
                double d2 = boundingSphere.radius;
                d2 *= d2;
                double d3 = boundingSphere.center.distanceSquared(boundingSphere.center);
                if (!(d3 < d2)) continue;
                return true;
            }
            if (boundsArray[i2].boundId == 1) {
                if (!this.intersect(boundsArray[i2])) continue;
                return true;
            }
            if (boundsArray[i2].boundId == 4) {
                if (!this.intersect(boundsArray[i2])) continue;
                return true;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope7"));
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingPolytope boundingPolytope) {
        if (bounds == null || this.boundsIsEmpty || bounds.boundsIsEmpty) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        if (this.boundsIsInfinite && !bounds.boundsIsInfinite) {
            boundingPolytope.set(bounds);
            return true;
        }
        if (!this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingPolytope.set(this);
            return true;
        }
        if (this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingPolytope.set(this);
            return true;
        }
        BoundingBox boundingBox = new BoundingBox();
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.intersect(boundingSphere)) {
                BoundingBox boundingBox2 = new BoundingBox(boundingSphere);
                BoundingBox boundingBox3 = new BoundingBox(this);
                boundingBox3.intersect((Bounds)boundingBox2, boundingBox);
                boundingPolytope.set(boundingBox);
                return true;
            }
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox4 = (BoundingBox)bounds;
            if (this.intersect(boundingBox4)) {
                BoundingBox boundingBox5 = new BoundingBox(this);
                boundingBox5.intersect((Bounds)boundingBox4, boundingBox);
                boundingPolytope.set(boundingBox);
                return true;
            }
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope2 = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope2)) {
                int n2;
                Vector4d[] vector4dArray = new Vector4d[this.planes.length + boundingPolytope2.planes.length];
                for (n2 = 0; n2 < this.planes.length; ++n2) {
                    vector4dArray[n2] = new Vector4d(this.planes[n2]);
                }
                for (n2 = 0; n2 < boundingPolytope2.planes.length; ++n2) {
                    vector4dArray[this.planes.length + n2] = new Vector4d(boundingPolytope2.planes[n2]);
                }
                BoundingPolytope boundingPolytope3 = new BoundingPolytope(vector4dArray);
                boundingPolytope.set(boundingPolytope3);
                return true;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
        }
        boundingPolytope.boundsIsEmpty = true;
        boundingPolytope.boundsIsInfinite = false;
        boundingPolytope.computeAllVerts();
        return false;
    }

    public boolean intersect(Bounds[] boundsArray, BoundingPolytope boundingPolytope) {
        int n2;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        for (n2 = 0; boundsArray[n2] == null && n2 < boundsArray.length; ++n2) {
        }
        if (n2 >= boundsArray.length) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        boolean bl = false;
        BoundingBox boundingBox = new BoundingBox();
        for (n2 = 0; n2 < boundsArray.length; ++n2) {
            if (boundsArray[n2] != null && !boundsArray[n2].boundsIsEmpty) {
                Bounds bounds;
                Vector4d[] vector4dArray;
                Bounds bounds2;
                if (boundsArray[n2].boundId == 2) {
                    bounds2 = (BoundingSphere)boundsArray[n2];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new BoundingBox(bounds2);
                        bounds = new BoundingBox(this);
                        bounds.intersect((Bounds)vector4dArray, boundingBox);
                        if (bl) {
                            boundingPolytope.combine(boundingBox);
                        } else {
                            boundingPolytope.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n2].boundId == 1) {
                    bounds2 = (BoundingBox)boundsArray[n2];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new BoundingBox(this);
                        vector4dArray.intersect(bounds2, boundingBox);
                        if (bl) {
                            boundingPolytope.combine(boundingBox);
                        } else {
                            boundingPolytope.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n2].boundId == 4) {
                    bounds2 = (BoundingPolytope)boundsArray[n2];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new Vector4d[this.planes.length + ((BoundingPolytope)bounds2).planes.length];
                        for (n2 = 0; n2 < this.planes.length; ++n2) {
                            vector4dArray[n2] = new Vector4d(this.planes[n2]);
                        }
                        for (n2 = 0; n2 < ((BoundingPolytope)bounds2).planes.length; ++n2) {
                            vector4dArray[this.planes.length + n2] = new Vector4d(((BoundingPolytope)bounds2).planes[n2]);
                        }
                        bounds = new BoundingPolytope(vector4dArray);
                        if (bl) {
                            boundingPolytope.combine(bounds);
                        } else {
                            boundingPolytope.set(bounds);
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
                }
            }
            if (boundingPolytope.boundsIsInfinite) break;
        }
        if (!bl) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        boolean bl = false;
        double d2 = Double.MAX_VALUE;
        int n2 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < boundsArray.length; ++i2) {
            int n3;
            boolean bl2;
            double d6;
            Bounds bounds;
            if (boundsArray[i2] == null || !this.intersect(boundsArray[i2])) continue;
            if (boundsArray[i2] instanceof BoundingSphere) {
                bounds = (BoundingSphere)boundsArray[i2];
                d6 = Math.sqrt((this.centroid.x - bounds.center.x) * (this.centroid.x - bounds.center.x) + (this.centroid.y - bounds.center.y) * (this.centroid.y - bounds.center.y) + (this.centroid.z - bounds.center.z) * (this.centroid.z - bounds.center.z));
                bl2 = true;
                for (n3 = 0; n3 < this.planes.length; ++n3) {
                    double d7;
                    if (!(bounds.center.x * this.planes[n3].x + bounds.center.y * this.planes[n3].y + bounds.center.z * this.planes[n3].z + this.planes[i2].w > 0.0) || !((d7 = bounds.center.x * this.planes[n3].x + bounds.center.y * this.planes[n3].y + bounds.center.z * this.planes[n3].z + this.planes[n3].w) > bounds.radius)) continue;
                    bl2 = false;
                }
                if (bl2) {
                    if (!bl) {
                        n2 = i2;
                        d2 = d6;
                        bl = true;
                        continue;
                    }
                    if (!(d6 < d2)) continue;
                    n2 = i2;
                    d2 = d6;
                    continue;
                }
                if (bl || !(d6 < d2)) continue;
                n2 = i2;
                d2 = d6;
                continue;
            }
            if (boundsArray[i2] instanceof BoundingBox) {
                bounds = (BoundingBox)boundsArray[i2];
                d3 = (((BoundingBox)bounds).upper.x + ((BoundingBox)bounds).lower.x) / 2.0;
                d4 = (((BoundingBox)bounds).upper.y + ((BoundingBox)bounds).lower.y) / 2.0;
                d5 = (((BoundingBox)bounds).upper.z + ((BoundingBox)bounds).lower.z) / 2.0;
                d6 = Math.sqrt((this.centroid.x - d3) * (this.centroid.x - d3) + (this.centroid.y - d4) * (this.centroid.y - d4) + (this.centroid.z - d5) * (this.centroid.z - d5));
                bl2 = true;
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (bl2) {
                    if (!bl) {
                        n2 = i2;
                        d2 = d6;
                        bl = true;
                        continue;
                    }
                    if (!(d6 < d2)) continue;
                    n2 = i2;
                    d2 = d6;
                    continue;
                }
                if (bl || !(d6 < d2)) continue;
                n2 = i2;
                d2 = d6;
                continue;
            }
            if (boundsArray[i2] instanceof BoundingPolytope) {
                bounds = (BoundingPolytope)boundsArray[i2];
                d6 = Math.sqrt((this.centroid.x - ((BoundingPolytope)bounds).centroid.x) * (this.centroid.x - ((BoundingPolytope)bounds).centroid.x) + (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) * (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) + (this.centroid.z - ((BoundingPolytope)bounds).centroid.z) * (this.centroid.z - ((BoundingPolytope)bounds).centroid.z));
                bl2 = true;
                for (n3 = 0; n3 < ((BoundingPolytope)bounds).nVerts; ++n3) {
                    if (this.pointInPolytope(((BoundingPolytope)bounds).verts[n3].x, ((BoundingPolytope)bounds).verts[n3].y, ((BoundingPolytope)bounds).verts[n3].z)) continue;
                    bl2 = false;
                }
                if (bl2) {
                    if (!bl) {
                        n2 = i2;
                        d2 = d6;
                        bl = true;
                        continue;
                    }
                    if (!(d6 < d2)) continue;
                    n2 = i2;
                    d2 = d6;
                    continue;
                }
                if (bl || !(d6 < d2)) continue;
                n2 = i2;
                d2 = d6;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope10"));
        }
        return boundsArray[n2];
    }

    public String toString() {
        String string = new String("BoundingPolytope:\n Num Planes =" + this.planes.length);
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            string = string + "\n" + this.mag[i2] * this.planes[i2].x + " " + this.mag[i2] * this.planes[i2].y + " " + this.mag[i2] * this.planes[i2].z + " " + this.mag[i2] * this.planes[i2].w;
        }
        return string;
    }

    private void computeVertex(int n2, int n3, int n4) {
        double d2 = this.planes[n2].x * this.planes[n3].y * this.planes[n4].z + this.planes[n2].y * this.planes[n3].z * this.planes[n4].x + this.planes[n2].z * this.planes[n3].x * this.planes[n4].y - this.planes[n2].z * this.planes[n3].y * this.planes[n4].x - this.planes[n2].y * this.planes[n3].x * this.planes[n4].z - this.planes[n2].x * this.planes[n3].z * this.planes[n4].y;
        if (d2 * d2 < 1.0E-6) {
            return;
        }
        d2 = 1.0 / d2;
        double d3 = (this.planes[n3].y * this.planes[n4].z - this.planes[n3].z * this.planes[n4].y) * this.pDotN[n2];
        double d4 = (this.planes[n3].z * this.planes[n4].x - this.planes[n3].x * this.planes[n4].z) * this.pDotN[n2];
        double d5 = (this.planes[n3].x * this.planes[n4].y - this.planes[n3].y * this.planes[n4].x) * this.pDotN[n2];
        d3 += (this.planes[n4].y * this.planes[n2].z - this.planes[n4].z * this.planes[n2].y) * this.pDotN[n3];
        d4 += (this.planes[n4].z * this.planes[n2].x - this.planes[n4].x * this.planes[n2].z) * this.pDotN[n3];
        d5 += (this.planes[n4].x * this.planes[n2].y - this.planes[n4].y * this.planes[n2].x) * this.pDotN[n3];
        d3 += (this.planes[n2].y * this.planes[n3].z - this.planes[n2].z * this.planes[n3].y) * this.pDotN[n4];
        d4 += (this.planes[n2].z * this.planes[n3].x - this.planes[n2].x * this.planes[n3].z) * this.pDotN[n4];
        d5 += (this.planes[n2].x * this.planes[n3].y - this.planes[n2].y * this.planes[n3].x) * this.pDotN[n4];
        if (this.pointInPolytope(d3 *= d2, d4 *= d2, d5 *= d2)) {
            if (this.nVerts >= this.verts.length) {
                Point3d[] point3dArray = new Point3d[this.nVerts << 1];
                for (int i2 = 0; i2 < this.nVerts; ++i2) {
                    point3dArray[i2] = this.verts[i2];
                }
                this.verts = point3dArray;
            }
            this.verts[this.nVerts++] = new Point3d(d3, d4, d5);
        }
    }

    private void computeAllVerts() {
        int n2;
        this.nVerts = 0;
        if (this.boundsIsEmpty) {
            this.verts = null;
            return;
        }
        this.verts = new Point3d[this.planes.length * this.planes.length];
        for (n2 = 0; n2 < this.planes.length; ++n2) {
            this.pDotN[n2] = -this.planes[n2].x * this.planes[n2].w * this.planes[n2].x - this.planes[n2].y * this.planes[n2].w * this.planes[n2].y - this.planes[n2].z * this.planes[n2].w * this.planes[n2].z;
        }
        for (int i2 = 0; i2 < this.planes.length - 2; ++i2) {
            for (int i3 = i2 + 1; i3 < this.planes.length - 1; ++i3) {
                for (int i4 = i3 + 1; i4 < this.planes.length; ++i4) {
                    this.computeVertex(i2, i3, i4);
                }
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Point3d[] point3dArray = new Point3d[this.nVerts];
        for (n2 = 0; n2 < this.nVerts; ++n2) {
            d4 += this.verts[n2].x;
            d3 += this.verts[n2].y;
            d2 += this.verts[n2].z;
            point3dArray[n2] = this.verts[n2];
        }
        this.verts = point3dArray;
        this.centroid.x = d4 / (double)this.nVerts;
        this.centroid.y = d3 / (double)this.nVerts;
        this.centroid.z = d2 / (double)this.nVerts;
        this.checkBoundsIsEmpty();
    }

    private boolean pointInPolytope(double d2, double d3, double d4) {
        for (int i2 = 0; i2 < this.planes.length; ++i2) {
            if (!(d2 * this.planes[i2].x + d3 * this.planes[i2].y + d4 * this.planes[i2].z + this.planes[i2].w > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private void checkBoundsIsEmpty() {
        this.boundsIsEmpty = this.planes.length < 4;
    }

    private void initEmptyPolytope() {
        this.planes = new Vector4d[6];
        this.pDotN = new double[6];
        this.mag = new double[6];
        this.verts = new Point3d[this.planes.length * this.planes.length];
        this.nVerts = 0;
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.checkBoundsIsEmpty();
    }

    Point3d getCenter() {
        return this.centroid;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (boundingPolytope.planes.length != this.planes.length) {
                int n2;
                boundingPolytope.planes = new Vector4d[this.planes.length];
                for (n2 = 0; n2 < boundingPolytope.planes.length; ++n2) {
                    boundingPolytope.planes[n2] = new Vector4d();
                }
                boundingPolytope.mag = new double[this.planes.length];
                boundingPolytope.pDotN = new double[this.planes.length];
                boundingPolytope.verts = new Point3d[this.nVerts];
                boundingPolytope.nVerts = this.nVerts;
                for (n2 = 0; n2 < this.nVerts; ++n2) {
                    boundingPolytope.verts[n2] = new Point3d(this.verts[n2]);
                }
            }
            for (int i2 = 0; i2 < this.planes.length; ++i2) {
                boundingPolytope.planes[i2].x = this.planes[i2].x;
                boundingPolytope.planes[i2].y = this.planes[i2].y;
                boundingPolytope.planes[i2].z = this.planes[i2].z;
                boundingPolytope.planes[i2].w = this.planes[i2].w;
                boundingPolytope.mag[i2] = this.mag[i2];
            }
            boundingPolytope.boundsIsEmpty = this.boundsIsEmpty;
            boundingPolytope.boundsIsInfinite = this.boundsIsInfinite;
            return boundingPolytope;
        }
        return (Bounds)this.clone();
    }

    int getPickType() {
        return 8;
    }
}

