/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.HashCodeUtil;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingSphere
extends Bounds {
    Point3d center;
    double radius;
    Point3d[] boxVerts;
    boolean allocBoxVerts = false;
    private BoundingBox tmpBox = null;
    private BoundingPolytope tmpPolytope = null;

    public BoundingSphere(Point3d point3d, double d2) {
        this.center = new Point3d(point3d);
        this.radius = d2;
        this.boundId = 2;
        this.updateBoundsStates();
    }

    public BoundingSphere() {
        this.boundId = 2;
        this.center = new Point3d();
        this.radius = 1.0;
    }

    public BoundingSphere(Bounds bounds) {
        this.boundId = 2;
        if (bounds == null) {
            this.center = new Point3d();
            this.radius = -1.0;
        } else if (bounds.boundsIsInfinite) {
            this.center = new Point3d();
            this.radius = Double.POSITIVE_INFINITY;
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.center = new Point3d();
            this.center.x = (boundingBox.upper.x + boundingBox.lower.x) / 2.0;
            this.center.y = (boundingBox.upper.y + boundingBox.lower.y) / 2.0;
            this.center.z = (boundingBox.upper.z + boundingBox.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((boundingBox.upper.x - boundingBox.lower.x) * (boundingBox.upper.x - boundingBox.lower.x) + (boundingBox.upper.y - boundingBox.lower.y) * (boundingBox.upper.y - boundingBox.lower.y) + (boundingBox.upper.z - boundingBox.lower.z) * (boundingBox.upper.z - boundingBox.lower.z));
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.center = new Point3d(boundingSphere.center);
            this.radius = boundingSphere.radius;
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.center = new Point3d();
            this.center.x = boundingPolytope.centroid.x;
            this.center.y = boundingPolytope.centroid.y;
            this.center.z = boundingPolytope.centroid.z;
            this.radius = Math.sqrt((boundingPolytope.verts[0].x - this.center.x) * (boundingPolytope.verts[0].x - this.center.x) + (boundingPolytope.verts[0].y - this.center.y) * (boundingPolytope.verts[0].y - this.center.y) + (boundingPolytope.verts[0].z - this.center.z) * (boundingPolytope.verts[0].z - this.center.z));
            for (int i2 = 1; i2 < boundingPolytope.nVerts; ++i2) {
                double d2 = (boundingPolytope.verts[i2].x - this.center.x) * (boundingPolytope.verts[i2].x - this.center.x) + (boundingPolytope.verts[i2].y - this.center.y) * (boundingPolytope.verts[i2].y - this.center.y) + (boundingPolytope.verts[i2].z - this.center.z) * (boundingPolytope.verts[i2].z - this.center.z);
                double d3 = this.radius * this.radius;
                if (!(d2 > d3)) continue;
                double d4 = Math.sqrt(d2);
                this.radius = (this.radius + d4) * 0.5;
                double d5 = d4 - this.radius;
                double d6 = d5 / d4;
                this.center.x += (boundingPolytope.verts[i2].x - this.center.x) * d6;
                this.center.y += (boundingPolytope.verts[i2].y - this.center.y) * d6;
                this.center.z += (boundingPolytope.verts[i2].z - this.center.z) * d6;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
        }
        this.updateBoundsStates();
    }

    public BoundingSphere(Bounds[] boundsArray) {
        int n2;
        this.boundId = 2;
        this.center = new Point3d();
        if (boundsArray == null || boundsArray.length <= 0) {
            this.radius = -1.0;
            this.updateBoundsStates();
            return;
        }
        for (n2 = 0; boundsArray[n2] == null && n2 < boundsArray.length; ++n2) {
        }
        if (n2 >= boundsArray.length) {
            this.radius = -1.0;
            this.updateBoundsStates();
            return;
        }
        this.set(boundsArray[n2++]);
        if (this.boundsIsInfinite) {
            return;
        }
        while (n2 < boundsArray.length) {
            if (boundsArray[n2] != null && !boundsArray[n2].boundsIsEmpty) {
                Bounds bounds;
                if (boundsArray[n2].boundsIsInfinite) {
                    this.radius = Double.POSITIVE_INFINITY;
                    break;
                }
                if (boundsArray[n2].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n2];
                    if (!this.allocBoxVerts) {
                        this.boxVerts = new Point3d[8];
                        for (int i2 = 0; i2 < 8; ++i2) {
                            this.boxVerts[i2] = new Point3d();
                        }
                        this.allocBoxVerts = true;
                    }
                    this.boxVerts[0].set(bounds.lower.x, bounds.lower.y, bounds.lower.z);
                    this.boxVerts[1].set(bounds.lower.x, bounds.upper.y, bounds.lower.z);
                    this.boxVerts[2].set(bounds.upper.x, bounds.lower.y, bounds.lower.z);
                    this.boxVerts[3].set(bounds.upper.x, bounds.upper.y, bounds.lower.z);
                    this.boxVerts[4].set(bounds.lower.x, bounds.lower.y, bounds.upper.z);
                    this.boxVerts[5].set(bounds.lower.x, bounds.upper.y, bounds.upper.z);
                    this.boxVerts[6].set(bounds.upper.x, bounds.lower.y, bounds.upper.z);
                    this.boxVerts[7].set(bounds.upper.x, bounds.upper.y, bounds.upper.z);
                    this.combine(this.boxVerts);
                } else if (boundsArray[n2].boundId == 2) {
                    double d2;
                    double d3;
                    bounds = (BoundingSphere)boundsArray[n2];
                    double d4 = Math.sqrt((this.center.x - ((BoundingSphere)bounds).center.x) * (this.center.x - ((BoundingSphere)bounds).center.x) + (this.center.y - ((BoundingSphere)bounds).center.y) * (this.center.y - ((BoundingSphere)bounds).center.y) + (this.center.z - ((BoundingSphere)bounds).center.z) * (this.center.z - ((BoundingSphere)bounds).center.z));
                    if (this.radius > ((BoundingSphere)bounds).radius) {
                        if (d4 + ((BoundingSphere)bounds).radius > this.radius) {
                            d3 = 0.5 * (this.radius - ((BoundingSphere)bounds).radius + d4);
                            d2 = d3 / d4;
                            this.radius = d3 + ((BoundingSphere)bounds).radius;
                            this.center.x = ((BoundingSphere)bounds).center.x + (this.center.x - ((BoundingSphere)bounds).center.x) * d2;
                            this.center.y = ((BoundingSphere)bounds).center.y + (this.center.y - ((BoundingSphere)bounds).center.y) * d2;
                            this.center.z = ((BoundingSphere)bounds).center.z + (this.center.z - ((BoundingSphere)bounds).center.z) * d2;
                        }
                    } else if (d4 + this.radius <= ((BoundingSphere)bounds).radius) {
                        this.center.x = ((BoundingSphere)bounds).center.x;
                        this.center.y = ((BoundingSphere)bounds).center.y;
                        this.center.z = ((BoundingSphere)bounds).center.z;
                        this.radius = ((BoundingSphere)bounds).radius;
                    } else {
                        d3 = 0.5 * (((BoundingSphere)bounds).radius - this.radius + d4);
                        d2 = d3 / d4;
                        this.radius = d3 + this.radius;
                        this.center.x += (((BoundingSphere)bounds).center.x - this.center.x) * d2;
                        this.center.y += (((BoundingSphere)bounds).center.y - this.center.y) * d2;
                        this.center.z += (((BoundingSphere)bounds).center.z - this.center.z) * d2;
                    }
                } else if (boundsArray[n2].boundId == 4) {
                    bounds = (BoundingPolytope)boundsArray[n2];
                    this.combine(((BoundingPolytope)bounds).verts);
                } else if (boundsArray[n2] != null) {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
                }
            }
            ++n2;
        }
        this.updateBoundsStates();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        this.radius = d2;
        this.updateBoundsStates();
    }

    public void getCenter(Point3d point3d) {
        point3d.x = this.center.x;
        point3d.y = this.center.y;
        point3d.z = this.center.z;
    }

    public void setCenter(Point3d point3d) {
        this.center.x = point3d.x;
        this.center.y = point3d.y;
        this.center.z = point3d.z;
        this.checkBoundsIsNaN();
    }

    public void set(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.center.x = 0.0;
            this.center.y = 0.0;
            this.center.z = 0.0;
            this.radius = -1.0;
        } else if (bounds.boundsIsInfinite) {
            this.center.x = 0.0;
            this.center.y = 0.0;
            this.center.z = 0.0;
            this.radius = Double.POSITIVE_INFINITY;
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.center.x = (boundingBox.upper.x + boundingBox.lower.x) / 2.0;
            this.center.y = (boundingBox.upper.y + boundingBox.lower.y) / 2.0;
            this.center.z = (boundingBox.upper.z + boundingBox.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((boundingBox.upper.x - boundingBox.lower.x) * (boundingBox.upper.x - boundingBox.lower.x) + (boundingBox.upper.y - boundingBox.lower.y) * (boundingBox.upper.y - boundingBox.lower.y) + (boundingBox.upper.z - boundingBox.lower.z) * (boundingBox.upper.z - boundingBox.lower.z));
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.radius = boundingSphere.radius;
            this.center.x = boundingSphere.center.x;
            this.center.y = boundingSphere.center.y;
            this.center.z = boundingSphere.center.z;
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.center.x = boundingPolytope.centroid.x;
            this.center.y = boundingPolytope.centroid.y;
            this.center.z = boundingPolytope.centroid.z;
            this.radius = Math.sqrt((boundingPolytope.verts[0].x - this.center.x) * (boundingPolytope.verts[0].x - this.center.x) + (boundingPolytope.verts[0].y - this.center.y) * (boundingPolytope.verts[0].y - this.center.y) + (boundingPolytope.verts[0].z - this.center.z) * (boundingPolytope.verts[0].z - this.center.z));
            for (int i2 = 1; i2 < boundingPolytope.nVerts; ++i2) {
                double d2 = (boundingPolytope.verts[i2].x - this.center.x) * (boundingPolytope.verts[i2].x - this.center.x) + (boundingPolytope.verts[i2].y - this.center.y) * (boundingPolytope.verts[i2].y - this.center.y) + (boundingPolytope.verts[i2].z - this.center.z) * (boundingPolytope.verts[i2].z - this.center.z);
                double d3 = this.radius * this.radius;
                if (!(d2 > d3)) continue;
                double d4 = Math.sqrt(d2);
                this.radius = (this.radius + d4) * 0.5;
                double d5 = d4 - this.radius;
                double d6 = d5 / d4;
                this.center.x += (boundingPolytope.verts[i2].x - this.center.x) * d6;
                this.center.y += (boundingPolytope.verts[i2].y - this.center.y) * d6;
                this.center.z += (boundingPolytope.verts[i2].z - this.center.z) * d6;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere2"));
        }
        this.updateBoundsStates();
    }

    public Object clone() {
        return new BoundingSphere(this.center, this.radius);
    }

    public boolean equals(Object object) {
        try {
            BoundingSphere boundingSphere = (BoundingSphere)object;
            return this.center.equals(boundingSphere.center) && this.radius == boundingSphere.radius;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.radius);
        l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.center.x);
        l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.center.y);
        l2 = 31L * l2 + HashCodeUtil.doubleToLongBits(this.center.z);
        return (int)(l2 ^ l2 >> 32);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        if (bounds.boundId == 1) {
            double d2;
            BoundingBox boundingBox = (BoundingBox)bounds;
            double d3 = boundingBox.upper.x - this.center.x;
            double d4 = boundingBox.lower.x - this.center.x;
            double d5 = d3 * d3 > d4 * d4 ? boundingBox.upper.x : boundingBox.lower.x;
            d3 = boundingBox.upper.y - this.center.y;
            d4 = boundingBox.lower.y - this.center.y;
            double d6 = d3 * d3 > d4 * d4 ? boundingBox.upper.y : boundingBox.lower.y;
            double d7 = Math.sqrt((d5 - this.center.x) * (d5 - this.center.x) + (d6 - this.center.y) * (d6 - this.center.y) + ((d2 = (d3 = boundingBox.upper.z - this.center.z) * d3 > (d4 = boundingBox.lower.z - this.center.z) * d4 ? boundingBox.upper.z : boundingBox.lower.z) - this.center.z) * (d2 - this.center.z));
            if (d7 > this.radius) {
                this.radius = (d7 + this.radius) * 0.5;
                double d8 = d7 - this.radius;
                this.center.x = (this.radius * this.center.x + d8 * d5) / d7;
                this.center.y = (this.radius * this.center.y + d8 * d6) / d7;
                this.center.z = (this.radius * this.center.z + d8 * d2) / d7;
                this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
                this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            }
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d9 = Math.sqrt((this.center.x - boundingSphere.center.x) * (this.center.x - boundingSphere.center.x) + (this.center.y - boundingSphere.center.y) * (this.center.y - boundingSphere.center.y) + (this.center.z - boundingSphere.center.z) * (this.center.z - boundingSphere.center.z));
            if (this.radius > boundingSphere.radius) {
                if (d9 + boundingSphere.radius > this.radius) {
                    double d10 = 0.5 * (this.radius - boundingSphere.radius + d9);
                    double d11 = d10 / d9;
                    this.radius = d10 + boundingSphere.radius;
                    this.center.x = boundingSphere.center.x + (this.center.x - boundingSphere.center.x) * d11;
                    this.center.y = boundingSphere.center.y + (this.center.y - boundingSphere.center.y) * d11;
                    this.center.z = boundingSphere.center.z + (this.center.z - boundingSphere.center.z) * d11;
                }
            } else if (d9 + this.radius <= boundingSphere.radius) {
                this.center.x = boundingSphere.center.x;
                this.center.y = boundingSphere.center.y;
                this.center.z = boundingSphere.center.z;
                this.radius = boundingSphere.radius;
            } else {
                double d12 = 0.5 * (boundingSphere.radius - this.radius + d9);
                double d13 = d12 / d9;
                this.radius = d12 + this.radius;
                this.center.x += (boundingSphere.center.x - this.center.x) * d13;
                this.center.y += (boundingSphere.center.y - this.center.y) * d13;
                this.center.z += (boundingSphere.center.z - this.center.z) * d13;
            }
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.combine(boundingPolytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere3"));
        }
        this.updateBoundsStates();
    }

    private void combinePoint(double d2, double d3, double d4) {
        double d5 = Math.sqrt((d2 - this.center.x) * (d2 - this.center.x) + (d3 - this.center.y) * (d3 - this.center.y) + (d4 - this.center.z) * (d4 - this.center.z));
        if (d5 > this.radius) {
            this.radius = (d5 + this.radius) * 0.5;
            double d6 = d5 - this.radius;
            this.center.x = (this.radius * this.center.x + d6 * d2) / d5;
            this.center.y = (this.radius * this.center.y + d6 * d3) / d5;
            this.center.z = (this.radius * this.center.z + d6 * d4) / d5;
        }
    }

    public void combine(Bounds[] boundsArray) {
        int n2;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (n2 = 0; n2 < boundsArray.length && (boundsArray[n2] == null || boundsArray[n2].boundsIsEmpty); ++n2) {
        }
        if (n2 >= boundsArray.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsArray[n2++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (n2 < boundsArray.length) {
            if (boundsArray[n2] != null && !boundsArray[n2].boundsIsEmpty) {
                double d2;
                if (boundsArray[n2].boundsIsInfinite) {
                    this.center.x = 0.0;
                    this.center.y = 0.0;
                    this.center.z = 0.0;
                    this.radius = Double.POSITIVE_INFINITY;
                    break;
                }
                if (boundsArray[n2].boundId == 1) {
                    double d3;
                    BoundingBox boundingBox = (BoundingBox)boundsArray[n2];
                    double d4 = boundingBox.upper.x - this.center.x;
                    double d5 = boundingBox.lower.x - this.center.x;
                    double d6 = d4 * d4 > d5 * d5 ? boundingBox.upper.x : boundingBox.lower.x;
                    d4 = boundingBox.upper.y - this.center.y;
                    d5 = boundingBox.lower.y - this.center.y;
                    double d7 = d4 * d4 > d5 * d5 ? boundingBox.upper.y : boundingBox.lower.y;
                    d2 = Math.sqrt((d6 - this.center.x) * (d6 - this.center.x) + (d7 - this.center.y) * (d7 - this.center.y) + ((d3 = (d4 = boundingBox.upper.z - this.center.z) * d4 > (d5 = boundingBox.lower.z - this.center.z) * d5 ? boundingBox.upper.z : boundingBox.lower.z) - this.center.z) * (d3 - this.center.z));
                    if (d2 > this.radius) {
                        this.radius = (d2 + this.radius) * 0.5;
                        double d8 = d2 - this.radius;
                        this.center.x = (this.radius * this.center.x + d8 * d6) / d2;
                        this.center.y = (this.radius * this.center.y + d8 * d7) / d2;
                        this.center.z = (this.radius * this.center.z + d8 * d3) / d2;
                        this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
                        this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
                        this.combinePoint(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
                    }
                } else if (boundsArray[n2].boundId == 2) {
                    double d9;
                    double d10;
                    BoundingSphere boundingSphere = (BoundingSphere)boundsArray[n2];
                    d2 = Math.sqrt((this.center.x - boundingSphere.center.x) * (this.center.x - boundingSphere.center.x) + (this.center.y - boundingSphere.center.y) * (this.center.y - boundingSphere.center.y) + (this.center.z - boundingSphere.center.z) * (this.center.z - boundingSphere.center.z));
                    if (this.radius > boundingSphere.radius) {
                        if (d2 + boundingSphere.radius > this.radius) {
                            d10 = 0.5 * (this.radius - boundingSphere.radius + d2);
                            d9 = d10 / d2;
                            this.radius = d10 + boundingSphere.radius;
                            this.center.x = boundingSphere.center.x + (this.center.x - boundingSphere.center.x) * d9;
                            this.center.y = boundingSphere.center.y + (this.center.y - boundingSphere.center.y) * d9;
                            this.center.z = boundingSphere.center.z + (this.center.z - boundingSphere.center.z) * d9;
                        }
                    } else if (d2 + this.radius <= boundingSphere.radius) {
                        this.center.x = boundingSphere.center.x;
                        this.center.y = boundingSphere.center.y;
                        this.center.z = boundingSphere.center.z;
                        this.radius = boundingSphere.radius;
                    } else {
                        d10 = 0.5 * (boundingSphere.radius - this.radius + d2);
                        d9 = d10 / d2;
                        this.radius = d10 + this.radius;
                        this.center.x += (boundingSphere.center.x - this.center.x) * d9;
                        this.center.y += (boundingSphere.center.y - this.center.y) * d9;
                        this.center.z += (boundingSphere.center.z - this.center.z) * d9;
                    }
                } else if (boundsArray[n2].boundId == 4) {
                    BoundingPolytope boundingPolytope = (BoundingPolytope)boundsArray[n2];
                    this.combine(boundingPolytope.verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere4"));
                }
            }
            ++n2;
        }
        this.updateBoundsStates();
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.radius = 0.0;
            this.center.x = point3d.x;
            this.center.y = point3d.y;
            this.center.z = point3d.z;
        } else {
            double d2 = Math.sqrt((point3d.x - this.center.x) * (point3d.x - this.center.x) + (point3d.y - this.center.y) * (point3d.y - this.center.y) + (point3d.z - this.center.z) * (point3d.z - this.center.z));
            if (d2 > this.radius) {
                this.radius = (d2 + this.radius) * 0.5;
                double d3 = d2 - this.radius;
                this.center.x = (this.radius * this.center.x + d3 * point3d.x) / d2;
                this.center.y = (this.radius * this.center.y + d3 * point3d.y) / d2;
                this.center.z = (this.radius * this.center.z + d3 * point3d.z) / d2;
            }
        }
        this.updateBoundsStates();
    }

    public void combine(Point3d[] point3dArray) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.center.x = point3dArray[0].x;
            this.center.y = point3dArray[0].y;
            this.center.z = point3dArray[0].z;
            this.radius = 0.0;
        }
        for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            double d2 = (point3dArray[i2].x - this.center.x) * (point3dArray[i2].x - this.center.x) + (point3dArray[i2].y - this.center.y) * (point3dArray[i2].y - this.center.y) + (point3dArray[i2].z - this.center.z) * (point3dArray[i2].z - this.center.z);
            double d3 = this.radius * this.radius;
            if (!(d2 > d3)) continue;
            double d4 = Math.sqrt(d2);
            this.radius = (this.radius + d4) * 0.5;
            double d5 = d4 - this.radius;
            this.center.x = (this.radius * this.center.x + d5 * point3dArray[i2].x) / d4;
            this.center.y = (this.radius * this.center.y + d5 * point3dArray[i2].y) / d4;
            this.center.z = (this.radius * this.center.z + d5 * point3dArray[i2].z) / d4;
        }
        this.updateBoundsStates();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.center.z = 0.0;
            this.center.y = 0.0;
            this.center.x = 0.0;
            this.radius = -1.0;
            this.updateBoundsStates();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.center.z = 0.0;
            this.center.y = 0.0;
            this.center.x = 0.0;
            this.radius = Double.POSITIVE_INFINITY;
            this.updateBoundsStates();
            return;
        }
        if (bounds.boundId == 1) {
            if (this.tmpBox == null) {
                this.tmpBox = new BoundingBox((BoundingBox)bounds);
            } else {
                this.tmpBox.set((BoundingBox)bounds);
            }
            this.tmpBox.transform(transform3D);
            this.set(this.tmpBox);
        } else if (bounds.boundId == 2) {
            transform3D.transform(((BoundingSphere)bounds).center, this.center);
            double d2 = transform3D.getDistanceScale();
            this.radius = ((BoundingSphere)bounds).radius * d2;
            if (Double.isNaN(this.radius)) {
                this.center.z = 0.0;
                this.center.y = 0.0;
                this.center.x = 0.0;
                this.radius = -1.0;
                this.updateBoundsStates();
                return;
            }
        } else if (bounds.boundId == 4) {
            if (this.tmpPolytope == null) {
                this.tmpPolytope = new BoundingPolytope((BoundingPolytope)bounds);
            } else {
                this.tmpPolytope.set((BoundingPolytope)bounds);
            }
            this.tmpPolytope.transform(transform3D);
            this.set(this.tmpPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere5"));
        }
    }

    public void transform(Transform3D transform3D) {
        if (this.boundsIsInfinite) {
            return;
        }
        transform3D.transform(this.center);
        double d2 = transform3D.getDistanceScale();
        this.radius *= d2;
        if (Double.isNaN(this.radius)) {
            this.center.z = 0.0;
            this.center.y = 0.0;
            this.center.x = 0.0;
            this.radius = -1.0;
            this.updateBoundsStates();
            return;
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d2 = new Point3d();
        point3d2.x = this.center.x - point3d.x;
        point3d2.y = this.center.y - point3d.y;
        point3d2.z = this.center.z - point3d.z;
        double d2 = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
        double d3 = this.radius * this.radius;
        if (d2 < d3) {
            return true;
        }
        double d4 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        vector3d2.x = vector3d.x * d4;
        vector3d2.y = vector3d.y * d4;
        vector3d2.z = vector3d.z * d4;
        double d5 = point3d2.x * vector3d2.x + point3d2.y * vector3d2.y + point3d2.z * vector3d2.z;
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = d3 - d2 + d5 * d5;
        if (d6 > 0.0) {
            double d7 = d5 - Math.sqrt(d6);
            point4d.x = point3d.x + vector3d2.x * d7;
            point4d.y = point3d.y + vector3d2.y * d7;
            point4d.z = point3d.z + vector3d2.z * d7;
            point4d.w = d7;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d2 = point3d.x - this.center.x;
        double d3 = point3d.y - this.center.y;
        double d4 = point3d.z - this.center.z;
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        if (d5 > this.radius * this.radius) {
            return false;
        }
        point4d.x = point3d.x;
        point4d.y = point3d.y;
        point4d.z = point3d.z;
        point4d.w = Math.sqrt(d5);
        return true;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        double d2;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Vector3d vector3d = new Vector3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        point3d3.x = this.center.x - point3d.x;
        point3d3.y = this.center.y - point3d.y;
        point3d3.z = this.center.z - point3d.z;
        vector3d2.x = point3d2.x - point3d.x;
        vector3d2.y = point3d2.y - point3d.y;
        vector3d2.z = point3d2.z - point3d.z;
        double d3 = 1.0 / Math.sqrt(vector3d2.x * vector3d2.x + vector3d2.y * vector3d2.y + vector3d2.z * vector3d2.z);
        vector3d.x = vector3d2.x * d3;
        vector3d.y = vector3d2.y * d3;
        vector3d.z = vector3d2.z * d3;
        double d4 = point3d3.x * point3d3.x + point3d3.y * point3d3.y + point3d3.z * point3d3.z;
        double d5 = this.radius * this.radius;
        if (d4 < d5) {
            return true;
        }
        double d6 = point3d3.x * vector3d.x + point3d3.y * vector3d.y + point3d3.z * vector3d.z;
        if (d6 <= 0.0) {
            return false;
        }
        double d7 = d5 - d4 + d6 * d6;
        if (d7 > 0.0 && (d2 = d6 - Math.sqrt(d7)) * d2 <= (point3d2.x - point3d.x) * (point3d2.x - point3d.x) + (point3d2.y - point3d.y) * (point3d2.y - point3d.y) + (point3d2.z - point3d.z) * (point3d2.z - point3d.z)) {
            point4d.x = point3d.x + vector3d.x * d2;
            point4d.y = point3d.y + vector3d.x * d2;
            point4d.z = point3d.z + vector3d.x * d2;
            point4d.w = d2;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d2 = new Point3d();
        point3d2.x = this.center.x - point3d.x;
        point3d2.y = this.center.y - point3d.y;
        point3d2.z = this.center.z - point3d.z;
        double d2 = point3d2.x * point3d2.x + point3d2.y * point3d2.y + point3d2.z * point3d2.z;
        double d3 = this.radius * this.radius;
        if (d2 < d3) {
            return true;
        }
        double d4 = Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        vector3d2.x = vector3d.x / d4;
        vector3d2.y = vector3d.y / d4;
        vector3d2.z = vector3d.z / d4;
        double d5 = point3d2.x * vector3d2.x + point3d2.y * vector3d2.y + point3d2.z * vector3d2.z;
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = d3 - d2 + d5 * d5;
        return d6 > 0.0;
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point3d2.x = point3d.x;
            point3d2.y = point3d.y;
            point3d2.z = point3d.z;
            return true;
        }
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        point3d4.x = this.center.x - point3d.x;
        point3d4.y = this.center.y - point3d.y;
        point3d4.z = this.center.z - point3d.z;
        double d2 = point3d4.x * point3d4.x + point3d4.y * point3d4.y + point3d4.z * point3d4.z;
        double d3 = this.radius * this.radius;
        if (d2 < d3) {
            return true;
        }
        double d4 = Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        point3d3.x = vector3d.x / d4;
        point3d3.y = vector3d.y / d4;
        point3d3.z = vector3d.z / d4;
        double d5 = point3d4.x * point3d3.x + point3d4.y * point3d3.y + point3d4.z * point3d3.z;
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = d3 - d2 + d5 * d5;
        if (d6 > 0.0) {
            double d7 = d5 - Math.sqrt(d6);
            point3d2.x = point3d.x + vector3d.x * d7;
            point3d2.y = point3d.y + vector3d.y * d7;
            point3d2.z = point3d.z + vector3d.z * d7;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        double d2 = point3d.x - this.center.x;
        double d3 = point3d.y - this.center.y;
        double d4 = point3d.z - this.center.z;
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        return !(d5 > this.radius * this.radius);
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || bounds.boundsIsInfinite) {
            return true;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            double d2 = 0.0;
            double d3 = this.radius * this.radius;
            if (this.center.x < boundingBox.lower.x) {
                d2 = (this.center.x - boundingBox.lower.x) * (this.center.x - boundingBox.lower.x);
            } else if (this.center.x > boundingBox.upper.x) {
                d2 = (this.center.x - boundingBox.upper.x) * (this.center.x - boundingBox.upper.x);
            }
            if (this.center.y < boundingBox.lower.y) {
                d2 += (this.center.y - boundingBox.lower.y) * (this.center.y - boundingBox.lower.y);
            } else if (this.center.y > boundingBox.upper.y) {
                d2 += (this.center.y - boundingBox.upper.y) * (this.center.y - boundingBox.upper.y);
            }
            if (this.center.z < boundingBox.lower.z) {
                d2 += (this.center.z - boundingBox.lower.z) * (this.center.z - boundingBox.lower.z);
            } else if (this.center.z > boundingBox.upper.z) {
                d2 += (this.center.z - boundingBox.upper.z) * (this.center.z - boundingBox.upper.z);
            }
            return d2 <= d3;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d4 = this.radius + boundingSphere.radius;
            d4 *= d4;
            double d5 = this.center.distanceSquared(boundingSphere.center);
            return d5 <= d4;
        }
        if (bounds.boundId == 4) {
            return this.intersect_ptope_sphere((BoundingPolytope)bounds, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i2 = 0; i2 < boundsArray.length; ++i2) {
            if (boundsArray[i2] == null || boundsArray[i2].boundsIsEmpty) continue;
            if (this.boundsIsInfinite || boundsArray[i2].boundsIsInfinite) {
                return true;
            }
            if (boundsArray[i2].boundId == 1) {
                if (!this.intersect(boundsArray[i2])) continue;
                return true;
            }
            if (boundsArray[i2].boundId == 2) {
                BoundingSphere boundingSphere = (BoundingSphere)boundsArray[i2];
                double d2 = this.radius + boundingSphere.radius;
                d2 *= d2;
                double d3 = this.center.distanceSquared(boundingSphere.center);
                if (!(d3 <= d2)) continue;
                return true;
            }
            if (boundsArray[i2].boundId == 4) {
                if (!this.intersect(boundsArray[i2])) continue;
                return true;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere7"));
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingSphere boundingSphere) {
        if (bounds == null || this.boundsIsEmpty || bounds.boundsIsEmpty) {
            boundingSphere.center.z = 0.0;
            boundingSphere.center.y = 0.0;
            boundingSphere.center.x = 0.0;
            boundingSphere.radius = -1.0;
            boundingSphere.updateBoundsStates();
            return false;
        }
        if (this.boundsIsInfinite && !bounds.boundsIsInfinite) {
            boundingSphere.set(bounds);
            return true;
        }
        if (!this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingSphere.set(this);
            return true;
        }
        if (this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingSphere.set(this);
            return true;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = new BoundingBox();
            BoundingBox boundingBox2 = (BoundingBox)bounds;
            if (this.intersect(boundingBox2)) {
                BoundingBox boundingBox3 = new BoundingBox(this);
                boundingBox3.intersect((Bounds)boundingBox2, boundingBox);
                boundingSphere.set(boundingBox);
                return true;
            }
            boundingSphere.center.z = 0.0;
            boundingSphere.center.y = 0.0;
            boundingSphere.center.x = 0.0;
            boundingSphere.radius = -1.0;
            boundingSphere.updateBoundsStates();
            return false;
        }
        if (bounds.boundId == 2) {
            boolean bl;
            BoundingSphere boundingSphere2 = (BoundingSphere)bounds;
            double d2 = Math.sqrt((this.center.x - boundingSphere2.center.x) * (this.center.x - boundingSphere2.center.x) + (this.center.y - boundingSphere2.center.y) * (this.center.y - boundingSphere2.center.y) + (this.center.z - boundingSphere2.center.z) * (this.center.z - boundingSphere2.center.z));
            if (d2 > this.radius + boundingSphere2.radius) {
                boundingSphere.center.z = 0.0;
                boundingSphere.center.y = 0.0;
                boundingSphere.center.x = 0.0;
                boundingSphere.radius = -1.0;
                bl = false;
            } else if (d2 + this.radius <= boundingSphere2.radius) {
                boundingSphere.center.x = this.center.x;
                boundingSphere.center.y = this.center.y;
                boundingSphere.center.z = this.center.z;
                boundingSphere.radius = this.radius;
                bl = true;
            } else if (d2 + boundingSphere2.radius <= this.radius) {
                boundingSphere.center.x = boundingSphere2.center.x;
                boundingSphere.center.y = boundingSphere2.center.y;
                boundingSphere.center.z = boundingSphere2.center.z;
                boundingSphere.radius = boundingSphere2.radius;
                bl = true;
            } else {
                double d3 = (d2 * d2 + this.radius * this.radius - boundingSphere2.radius * boundingSphere2.radius) / (2.0 * d2);
                boundingSphere.radius = Math.sqrt(this.radius * this.radius - d3 * d3);
                double d4 = d3 / d2;
                boundingSphere.center.x = this.center.x + (boundingSphere2.center.x - this.center.x) * d4;
                boundingSphere.center.y = this.center.y + (boundingSphere2.center.y - this.center.y) * d4;
                boundingSphere.center.z = this.center.z + (boundingSphere2.center.z - this.center.z) * d4;
                bl = true;
            }
            boundingSphere.updateBoundsStates();
            return bl;
        }
        if (bounds.boundId == 4) {
            BoundingBox boundingBox = new BoundingBox();
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope)) {
                BoundingBox boundingBox4 = new BoundingBox(this);
                BoundingBox boundingBox5 = new BoundingBox(boundingPolytope);
                boundingBox4.intersect((Bounds)boundingBox5, boundingBox);
                boundingSphere.set(boundingBox);
                return true;
            }
            boundingSphere.center.z = 0.0;
            boundingSphere.center.y = 0.0;
            boundingSphere.center.x = 0.0;
            boundingSphere.radius = -1.0;
            boundingSphere.updateBoundsStates();
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere8"));
    }

    public boolean intersect(Bounds[] boundsArray, BoundingSphere boundingSphere) {
        int n2;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingSphere.center.z = 0.0;
            boundingSphere.center.y = 0.0;
            boundingSphere.center.x = 0.0;
            boundingSphere.radius = -1.0;
            boundingSphere.updateBoundsStates();
            return false;
        }
        for (n2 = 0; boundsArray[n2] == null && n2 < boundsArray.length; ++n2) {
        }
        if (n2 >= boundsArray.length) {
            boundingSphere.center.z = 0.0;
            boundingSphere.center.y = 0.0;
            boundingSphere.center.x = 0.0;
            boundingSphere.radius = -1.0;
            boundingSphere.updateBoundsStates();
            return false;
        }
        boolean bl = false;
        Point3d point3d = new Point3d();
        BoundingBox boundingBox = new BoundingBox();
        for (n2 = 0; n2 < boundsArray.length; ++n2) {
            BoundingBox boundingBox2;
            Bounds bounds;
            if (boundsArray[n2] == null || boundsArray[n2].boundsIsEmpty) continue;
            if (boundsArray[n2].boundId == 1) {
                bounds = (BoundingBox)boundsArray[n2];
                if (!this.intersect(bounds)) continue;
                boundingBox2 = new BoundingBox(this);
                boundingBox2.intersect(bounds, boundingBox);
                if (bl) {
                    boundingSphere.combine(boundingBox);
                    continue;
                }
                boundingSphere.set(boundingBox);
                bl = true;
                continue;
            }
            if (boundsArray[n2].boundId == 2) {
                bounds = (BoundingSphere)boundsArray[n2];
                double d2 = Math.sqrt((this.center.x - ((BoundingSphere)bounds).center.x) * (this.center.x - ((BoundingSphere)bounds).center.x) + (this.center.y - ((BoundingSphere)bounds).center.y) * (this.center.y - ((BoundingSphere)bounds).center.y) + (this.center.z - ((BoundingSphere)bounds).center.z) * (this.center.z - ((BoundingSphere)bounds).center.z));
                if (d2 > this.radius + ((BoundingSphere)bounds).radius) continue;
                if (d2 + this.radius <= ((BoundingSphere)bounds).radius) {
                    if (bl) {
                        boundingSphere.combine(this);
                        continue;
                    }
                    boundingSphere.center.x = this.center.x;
                    boundingSphere.center.y = this.center.y;
                    boundingSphere.center.z = this.center.z;
                    boundingSphere.radius = this.radius;
                    bl = true;
                    boundingSphere.updateBoundsStates();
                    continue;
                }
                if (d2 + ((BoundingSphere)bounds).radius <= this.radius) {
                    if (bl) {
                        boundingSphere.combine(bounds);
                        continue;
                    }
                    boundingSphere.center.x = this.center.x;
                    boundingSphere.center.y = this.center.y;
                    boundingSphere.center.z = this.center.z;
                    boundingSphere.radius = ((BoundingSphere)bounds).radius;
                    bl = true;
                    boundingSphere.updateBoundsStates();
                    continue;
                }
                double d3 = (d2 * d2 + this.radius * this.radius - ((BoundingSphere)bounds).radius * ((BoundingSphere)bounds).radius) / (2.0 * d2);
                double d4 = Math.sqrt(this.radius * this.radius - d3 * d3);
                double d5 = d3 / d2;
                point3d.x = this.center.x + (((BoundingSphere)bounds).center.x - this.center.x) * d5;
                point3d.y = this.center.y + (((BoundingSphere)bounds).center.y - this.center.y) * d5;
                point3d.z = this.center.z + (((BoundingSphere)bounds).center.z - this.center.z) * d5;
                if (bl) {
                    BoundingSphere boundingSphere2 = new BoundingSphere(point3d, d4);
                    boundingSphere.combine(boundingSphere2);
                    continue;
                }
                boundingSphere.setRadius(d4);
                boundingSphere.setCenter(point3d);
                bl = true;
                continue;
            }
            if (boundsArray[n2].boundId == 4) {
                bounds = (BoundingPolytope)boundsArray[n2];
                if (!this.intersect(bounds)) continue;
                boundingBox2 = new BoundingBox(this);
                BoundingBox boundingBox3 = new BoundingBox(bounds);
                boundingBox2.intersect((Bounds)boundingBox3, boundingBox);
                if (bl) {
                    boundingSphere.combine(boundingBox);
                    continue;
                }
                boundingSphere.set(boundingBox);
                bl = true;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere9"));
        }
        if (!bl) {
            boundingSphere.center.z = 0.0;
            boundingSphere.center.y = 0.0;
            boundingSphere.center.x = 0.0;
            boundingSphere.radius = -1.0;
            boundingSphere.updateBoundsStates();
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        double d5 = Double.MAX_VALUE;
        int n2 = 0;
        for (int i2 = 0; i2 < boundsArray.length; ++i2) {
            double d6;
            Bounds bounds;
            if (boundsArray[i2] == null || !this.intersect(boundsArray[i2])) continue;
            bl2 = true;
            if (boundsArray[i2].boundId == 1) {
                bounds = (BoundingBox)boundsArray[i2];
                d2 = (bounds.upper.x + bounds.lower.x) / 2.0;
                d3 = (bounds.upper.y + bounds.lower.y) / 2.0;
                d4 = (bounds.upper.z + bounds.lower.z) / 2.0;
                d6 = Math.sqrt((this.center.x - d2) * (this.center.x - d2) + (this.center.y - d3) * (this.center.y - d3) + (this.center.z - d4) * (this.center.z - d4));
                double d7 = (this.center.x - bounds.lower.x) * (this.center.x - bounds.lower.x) > (this.center.x - bounds.upper.x) * (this.center.x - bounds.upper.x) ? (this.center.x - bounds.lower.x) * (this.center.x - bounds.lower.x) : (this.center.x - bounds.upper.x) * (this.center.x - bounds.upper.x);
                d7 = (this.center.y - bounds.lower.y) * (this.center.y - bounds.lower.y) > (this.center.y - bounds.upper.y) * (this.center.y - bounds.upper.y) ? (d7 += (this.center.y - bounds.lower.y) * (this.center.y - bounds.lower.y)) : (d7 += (this.center.y - bounds.upper.y) * (this.center.y - bounds.upper.y));
                d7 = (this.center.z - bounds.lower.z) * (this.center.z - bounds.lower.z) > (this.center.z - bounds.upper.z) * (this.center.z - bounds.upper.z) ? (d7 += (this.center.z - bounds.lower.z) * (this.center.z - bounds.lower.z)) : (d7 += (this.center.z - bounds.upper.z) * (this.center.z - bounds.upper.z));
                double d8 = this.radius * this.radius;
                if (d7 <= d8) {
                    if (!bl) {
                        n2 = i2;
                        d5 = d6;
                        bl = true;
                        continue;
                    }
                    if (!(d6 < d5)) continue;
                    n2 = i2;
                    d5 = d6;
                    continue;
                }
                if (bl || !(d6 < d5)) continue;
                n2 = i2;
                d5 = d6;
                continue;
            }
            if (boundsArray[i2].boundId == 2) {
                bounds = (BoundingSphere)boundsArray[i2];
                d6 = Math.sqrt((this.center.x - ((BoundingSphere)bounds).center.x) * (this.center.x - ((BoundingSphere)bounds).center.x) + (this.center.y - ((BoundingSphere)bounds).center.y) * (this.center.y - ((BoundingSphere)bounds).center.y) + (this.center.z - ((BoundingSphere)bounds).center.z) * (this.center.z - ((BoundingSphere)bounds).center.z));
                if (d6 + ((BoundingSphere)bounds).radius <= this.radius) {
                    if (!bl) {
                        n2 = i2;
                        d5 = d6;
                        bl = true;
                        continue;
                    }
                    if (!(d6 < d5)) continue;
                    n2 = i2;
                    d5 = d6;
                    continue;
                }
                if (bl || !(d6 < d5)) continue;
                n2 = i2;
                d5 = d6;
                continue;
            }
            if (boundsArray[i2].boundId == 4) {
                bounds = (BoundingPolytope)boundsArray[i2];
                d6 = Math.sqrt((this.center.x - ((BoundingPolytope)bounds).centroid.x) * (this.center.x - ((BoundingPolytope)bounds).centroid.x) + (this.center.y - ((BoundingPolytope)bounds).centroid.y) * (this.center.y - ((BoundingPolytope)bounds).centroid.y) + (this.center.z - ((BoundingPolytope)bounds).centroid.z) * (this.center.z - ((BoundingPolytope)bounds).centroid.z));
                boolean bl3 = true;
                for (int i3 = 0; i3 < ((BoundingPolytope)bounds).nVerts; ++i3) {
                    double d9 = ((BoundingPolytope)bounds).verts[i3].x - this.center.x;
                    double d10 = ((BoundingPolytope)bounds).verts[i3].y - this.center.y;
                    double d11 = ((BoundingPolytope)bounds).verts[i3].z - this.center.z;
                    double d12 = d9 * d9 + d10 * d10 + d11 * d11;
                    if (!(d12 > this.radius * this.radius)) continue;
                    bl3 = false;
                }
                if (bl3) {
                    if (!bl) {
                        n2 = i2;
                        d5 = d6;
                        bl = true;
                        continue;
                    }
                    if (!(d6 < d5)) continue;
                    n2 = i2;
                    d5 = d6;
                    continue;
                }
                if (bl || !(d6 < d5)) continue;
                n2 = i2;
                d5 = d6;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere10"));
        }
        if (bl2) {
            return boundsArray[n2];
        }
        return null;
    }

    boolean intersect(CachedFrustum cachedFrustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            double d2 = cachedFrustum.clipPlanes[i2].x * this.center.x + cachedFrustum.clipPlanes[i2].y * this.center.y + cachedFrustum.clipPlanes[i2].z * this.center.z + cachedFrustum.clipPlanes[i2].w;
            if (!(d2 < 0.0) || !(d2 + this.radius < 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Vector4d[] vector4dArray) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            double d2 = vector4dArray[i2].x * this.center.x + vector4dArray[i2].y * this.center.y + vector4dArray[i2].z * this.center.z + vector4dArray[i2].w;
            if (!(d2 < 0.0) || !(d2 + this.radius < 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String("Center=" + this.center + "  Radius=" + this.radius);
    }

    private void updateBoundsStates() {
        if (this.checkBoundsIsNaN()) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            return;
        }
        if (this.radius == Double.POSITIVE_INFINITY) {
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = true;
        } else {
            this.boundsIsInfinite = false;
            this.boundsIsEmpty = this.radius < 0.0;
        }
    }

    Point3d getCenter() {
        return this.center;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            boundingSphere.radius = this.radius;
            boundingSphere.center.x = this.center.x;
            boundingSphere.center.y = this.center.y;
            boundingSphere.center.z = this.center.z;
            boundingSphere.boundsIsEmpty = this.boundsIsEmpty;
            boundingSphere.boundsIsInfinite = this.boundsIsInfinite;
            return boundingSphere;
        }
        return (Bounds)this.clone();
    }

    boolean checkBoundsIsNaN() {
        return Double.isNaN(this.radius + this.center.x + this.center.y + this.center.z);
    }

    int getPickType() {
        return 7;
    }
}

