/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickShape;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphPath;

public class BranchGroup
extends Group {
    public static final int ALLOW_DETACH = 17;

    void createRetained() {
        this.retained = new BranchGroupRetained();
        this.retained.setSource(this);
    }

    public void compile() {
        if (this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup0"));
        }
        if (!this.isCompiled()) {
            this.checkForCycle();
            ((BranchGroupRetained)this.retained).compile();
        }
    }

    public void detach() {
        if (this.isLiveOrCompiled()) {
            Group group;
            if (!this.getCapability(17)) {
                throw new CapabilityNotSetException(J3dI18N.getString("BranchGroup1"));
            }
            if (((BranchGroupRetained)this.retained).parent != null && !(group = (Group)((BranchGroupRetained)this.retained).parent.source).getCapability(13)) {
                throw new CapabilityNotSetException(J3dI18N.getString("BranchGroup2"));
            }
        }
        ((BranchGroupRetained)this.retained).detach();
    }

    void validateModeFlagAndPickShape(int n2, int n3, PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup4"));
        }
        if (pickShape instanceof PickPoint && n2 == 2) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup5"));
        }
        if ((n3 & 0x20) != 0 && (n3 & 0x40) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup6"));
        }
        if (n2 == 1 && (n3 & 0x78) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup7"));
        }
        if (pickShape instanceof PickBounds && (n3 & 0x78) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("BranchGroup8"));
        }
    }

    public SceneGraphPath[] pickAll(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickAll(pickShape);
    }

    public PickInfo[] pickAll(int n2, int n3, PickShape pickShape) {
        this.validateModeFlagAndPickShape(n2, n3, pickShape);
        return ((BranchGroupRetained)this.retained).pickAll(n2, n3, pickShape);
    }

    public SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickAllSorted(pickShape);
    }

    public PickInfo[] pickAllSorted(int n2, int n3, PickShape pickShape) {
        this.validateModeFlagAndPickShape(n2, n3, pickShape);
        return ((BranchGroupRetained)this.retained).pickAllSorted(n2, n3, pickShape);
    }

    public SceneGraphPath pickClosest(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickClosest(pickShape);
    }

    public PickInfo pickClosest(int n2, int n3, PickShape pickShape) {
        this.validateModeFlagAndPickShape(n2, n3, pickShape);
        return ((BranchGroupRetained)this.retained).pickClosest(n2, n3, pickShape);
    }

    public SceneGraphPath pickAny(PickShape pickShape) {
        if (!this.isLive()) {
            throw new IllegalStateException(J3dI18N.getString("BranchGroup3"));
        }
        return ((BranchGroupRetained)this.retained).pickAny(pickShape);
    }

    public PickInfo pickAny(int n2, int n3, PickShape pickShape) {
        this.validateModeFlagAndPickShape(n2, n3, pickShape);
        return ((BranchGroupRetained)this.retained).pickAny(n2, n3, pickShape);
    }

    public Node cloneNode(boolean bl) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.duplicateNode(this, bl);
        return branchGroup;
    }
}

