/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class ConeSoundRetained
extends PointSoundRetained {
    Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    float[] backAttenuationDistance = null;
    float[] backAttenuationGain = null;
    float[] angularDistance = new float[]{0.0f, 1.5707964f};
    float[] angularGain = new float[]{1.0f, 0.0f};
    int filterType = -1;
    float[] frequencyCutoff = new float[]{-1.0f, -1.0f};

    ConeSoundRetained() {
        this.nodeType = 14;
    }

    void setDistanceGain(Point2f[] point2fArray, Point2f[] point2fArray2) {
        this.setDistanceGain(point2fArray);
        this.setBackDistanceGain(point2fArray2);
    }

    void setDistanceGain(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.setDistanceGain(fArray, fArray2);
        this.setBackDistanceGain(fArray3, fArray4);
    }

    void setBackDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        } else {
            int n2 = point2fArray.length;
            if (n2 == 0) {
                this.backAttenuationDistance = null;
                this.backAttenuationGain = null;
            } else {
                this.backAttenuationDistance = new float[n2];
                this.backAttenuationGain = new float[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.backAttenuationDistance[i2] = point2fArray[i2].x;
                    this.backAttenuationGain[i2] = point2fArray[i2].y;
                }
            }
        }
        this.dispatchAttribChange(256, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setBackDistanceGain(float[] fArray, float[] fArray2) {
        int n2;
        int n3 = 0;
        if (fArray == null || fArray2 == null) {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        } else {
            int n4 = fArray2.length;
            n3 = fArray.length;
            if (n3 == 0 || n4 == 0) {
                this.backAttenuationDistance = null;
                this.backAttenuationGain = null;
            } else {
                this.backAttenuationDistance = new float[n3];
                this.backAttenuationGain = new float[n3];
                System.arraycopy(fArray, 0, this.backAttenuationDistance, 0, n3);
                if (n3 <= n4) {
                    System.arraycopy(fArray2, 0, this.backAttenuationGain, 0, n3);
                } else {
                    System.arraycopy(fArray2, 0, this.backAttenuationGain, 0, n4);
                    for (n2 = n4; n2 < n3; ++n2) {
                        this.backAttenuationGain[n2] = fArray2[n4 - 1];
                    }
                }
            }
        }
        Point2f[] point2fArray = new Point2f[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            point2fArray[n2] = new Point2f(this.backAttenuationDistance[n2], this.backAttenuationGain[n2]);
        }
        this.dispatchAttribChange(256, point2fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getDistanceGain(Point2f[] point2fArray, Point2f[] point2fArray2) {
        this.getDistanceGain(point2fArray);
        this.getBackDistanceGain(point2fArray2);
    }

    void getDistanceGain(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.getDistanceGain(fArray, fArray2);
        this.getBackDistanceGain(fArray3, fArray4);
    }

    void getBackDistanceGain(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.backAttenuationDistance == null || this.backAttenuationGain == null) {
            return;
        }
        int n2 = this.backAttenuationDistance.length;
        int n3 = point2fArray.length;
        if (n2 < n3) {
            n2 = n3;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            point2fArray[i2].x = this.backAttenuationDistance[i2];
            point2fArray[i2].y = this.backAttenuationGain[i2];
        }
    }

    void getBackDistanceGain(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.backAttenuationDistance == null || this.backAttenuationGain == null) {
            return;
        }
        int n2 = this.backAttenuationDistance.length;
        int n3 = fArray.length;
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.backAttenuationDistance, 0, fArray, 0, n2);
        n2 = this.backAttenuationGain.length;
        int n4 = fArray2.length;
        if (n2 > n4) {
            n2 = n4;
        }
        System.arraycopy(this.backAttenuationGain, 0, fArray2, 0, n2);
    }

    void setDirection(Vector3f vector3f) {
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(vector3f, this.direction);
        } else {
            this.direction.set(vector3f);
        }
        this.dispatchAttribChange(512, new Vector3f(this.direction));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setDirection(float f2, float f3, float f4) {
        this.direction.x = f2;
        this.direction.y = f3;
        this.direction.z = f4;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction);
        }
        this.dispatchAttribChange(512, new Vector3f(this.direction));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void getDirection(Vector3f vector3f) {
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(this.direction, vector3f);
        } else {
            vector3f.set(this.direction);
        }
    }

    void getXformDirection(Vector3f vector3f) {
        vector3f.set(this.xformDirection);
    }

    void setAngularAttenuation(Point2f[] point2fArray) {
        int n2 = 0;
        this.filterType = -1;
        if (point2fArray == null) {
            this.angularDistance = null;
            this.angularGain = null;
        } else {
            n2 = point2fArray.length;
            if (n2 == 0) {
                this.angularDistance = null;
                this.angularGain = null;
            } else {
                this.angularDistance = new float[n2];
                this.angularGain = new float[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.angularDistance[i2] = point2fArray[i2].x;
                    this.angularGain[i2] = point2fArray[i2].y;
                }
            }
        }
        Point3f[] point3fArray = new Point3f[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            point3fArray[i3] = new Point3f(this.angularDistance[i3], this.angularGain[i3], -1.0f);
        }
        this.dispatchAttribChange(1024, point3fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAngularAttenuation(Point3f[] point3fArray) {
        if (point3fArray == null) {
            this.angularDistance = null;
            this.angularGain = null;
            this.frequencyCutoff = null;
            this.filterType = -1;
        } else {
            int n2 = point3fArray.length;
            if (n2 == 0) {
                this.angularDistance = null;
                this.angularGain = null;
                this.frequencyCutoff = null;
                this.filterType = -1;
            } else {
                this.angularDistance = new float[n2];
                this.angularGain = new float[n2];
                this.frequencyCutoff = new float[n2];
                this.filterType = 1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.angularDistance[i2] = point3fArray[i2].x;
                    this.angularGain[i2] = point3fArray[i2].y;
                    this.frequencyCutoff[i2] = point3fArray[i2].z;
                }
            }
        }
        this.dispatchAttribChange(1024, point3fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    void setAngularAttenuation(float[] fArray, float[] fArray2, float[] fArray3) {
        int n2;
        int n3 = 0;
        if (fArray == null || fArray2 == null || fArray3 == null) {
            this.angularDistance = null;
            this.angularGain = null;
            this.frequencyCutoff = null;
            this.filterType = -1;
        } else {
            n3 = fArray.length;
            int n4 = fArray2.length;
            if (n3 == 0 || n4 == 0) {
                this.angularDistance = null;
                this.angularGain = null;
                this.frequencyCutoff = null;
                this.filterType = -1;
            } else {
                int n5;
                n2 = fArray3.length;
                this.angularDistance = new float[n3];
                this.angularGain = new float[n3];
                this.frequencyCutoff = new float[n3];
                System.arraycopy(fArray, 0, this.angularDistance, 0, n3);
                if (n3 <= n4) {
                    System.arraycopy(fArray2, 0, this.angularGain, 0, n3);
                } else {
                    System.arraycopy(fArray2, 0, this.angularGain, 0, n4);
                    for (n5 = n4; n5 < n3; ++n5) {
                        this.angularGain[n5] = fArray2[n4 - 1];
                    }
                }
                if (n2 == 0) {
                    this.filterType = -1;
                } else {
                    this.filterType = 1;
                    if (n3 <= n2) {
                        System.arraycopy(fArray3, 0, this.frequencyCutoff, 0, n3);
                    } else {
                        System.arraycopy(fArray3, 0, this.frequencyCutoff, 0, n2);
                        for (n5 = n2; n5 < n3; ++n5) {
                            this.frequencyCutoff[n5] = fArray3[n2 - 1];
                        }
                    }
                }
            }
        }
        Point3f[] point3fArray = new Point3f[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            point3fArray[n2] = this.filterType != -1 ? new Point3f(this.angularDistance[n2], this.angularGain[n2], this.frequencyCutoff[n2]) : new Point3f(this.angularDistance[n2], this.angularGain[n2], -1.0f);
        }
        this.dispatchAttribChange(1024, point3fArray);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getAngularAttenuationLength() {
        if (this.angularDistance == null) {
            return 0;
        }
        return this.angularDistance.length;
    }

    void getAngularAttenuation(Point3f[] point3fArray) {
        if (this.angularDistance == null || this.angularGain == null) {
            return;
        }
        if (point3fArray == null) {
            return;
        }
        int n2 = this.angularDistance.length;
        if (point3fArray.length < n2) {
            n2 = point3fArray.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            point3fArray[i2].x = this.angularDistance[i2];
            point3fArray[i2].y = this.angularGain[i2];
            if (this.filterType == -1 || this.frequencyCutoff == null) {
                point3fArray[i2].z = -1.0f;
                continue;
            }
            if (this.filterType != 1) continue;
            point3fArray[i2].z = this.frequencyCutoff[i2];
        }
    }

    void getAngularAttenuation(float[] fArray, float[] fArray2, float[] fArray3) {
        if (fArray == null || fArray2 == null || fArray3 == null) {
            return;
        }
        if (this.angularDistance == null || this.angularGain == null) {
            return;
        }
        int n2 = this.angularDistance.length;
        if (fArray.length < n2) {
            n2 = fArray.length;
        }
        System.arraycopy(this.angularDistance, 0, fArray, 0, n2);
        int n3 = this.angularGain.length;
        if (fArray2.length < n3) {
            n3 = fArray2.length;
        }
        System.arraycopy(this.angularGain, 0, fArray2, 0, n3);
        int n4 = 0;
        if (this.frequencyCutoff == null || this.filterType == -1) {
            n4 = fArray3.length;
        } else {
            n4 = this.frequencyCutoff.length;
            if (fArray3.length < n4) {
                n4 = fArray3.length;
            }
        }
        if (this.filterType == -1 || this.frequencyCutoff == null) {
            for (int i2 = 0; i2 < n4; ++i2) {
                fArray3[i2] = -1.0f;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, fArray3, 0, n4);
        }
    }

    void updateMirrorObject(Object[] objectArray) {
        Object var2_2 = null;
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        SoundRetained[] soundRetainedArray = (SoundRetained[])objectArray[3];
        if (n2 == -1) {
            this.initMirrorObject((ConeSoundRetained)objectArray[2]);
            return;
        }
        if ((n2 & 0x200) != 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                ConeSoundRetained coneSoundRetained = (ConeSoundRetained)soundRetainedArray[i2];
                coneSoundRetained.direction = (Vector3f)objectArray[4];
                coneSoundRetained.getLastLocalToVworld().transform(coneSoundRetained.direction, coneSoundRetained.xformDirection);
                coneSoundRetained.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objectArray);
    }

    synchronized void initMirrorObject(ConeSoundRetained coneSoundRetained) {
        super.initMirrorObject(coneSoundRetained);
        coneSoundRetained.direction.set(this.direction);
        coneSoundRetained.xformDirection.set(this.xformDirection);
    }

    void updateTransformChange() {
        Transform3D transform3D = this.getLastLocalToVworld();
        super.updateTransformChange();
        transform3D.transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.direction);
    }
}

