/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.LOD;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.vecmath.Point3f;

public class DistanceLOD
extends LOD {
    private double[] distances;
    private Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    private Point3f center = new Point3f();
    private Point3f viewPosition = new Point3f();

    public DistanceLOD() {
        this.distances = new double[1];
        this.distances[0] = 0.0;
    }

    public DistanceLOD(float[] fArray) {
        this.distances = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.distances[i2] = fArray[i2];
        }
    }

    public DistanceLOD(float[] fArray, Point3f point3f) {
        this.distances = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.distances[i2] = fArray[i2];
        }
        this.position.set(point3f);
    }

    public void setPosition(Point3f point3f) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            ((NodeRetained)this.retained).staticTransform.transform.transform(point3f, this.position);
        } else {
            this.position.set(point3f);
        }
    }

    public void getPosition(Point3f point3f) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            Transform3D transform3D = ((NodeRetained)this.retained).staticTransform.getInvTransform();
            transform3D.transform(this.position, point3f);
        } else {
            point3f.set(this.position);
        }
    }

    public int numDistances() {
        return this.distances.length;
    }

    public double getDistance(int n2) {
        return this.distances[n2];
    }

    public void setDistance(int n2, double d2) {
        this.distances[n2] = d2;
    }

    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    public void processStimulus(Enumeration enumeration) {
        int n2;
        View view = this.getView();
        if (view == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        ViewPlatform viewPlatform = view.getViewPlatform();
        if (viewPlatform == null) {
            return;
        }
        double d2 = 0.0;
        int n3 = 0;
        Transform3D transform3D = new Transform3D();
        transform3D.set(((NodeRetained)this.retained).getCurrentLocalToVworld());
        transform3D.transform(this.position, this.center);
        this.viewPosition.x = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.x;
        this.viewPosition.y = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.y;
        this.viewPosition.z = (float)((ViewPlatformRetained)viewPlatform.retained).schedSphere.center.z;
        d2 = this.center.distance(this.viewPosition);
        d2 /= transform3D.getDistanceScale();
        int n4 = this.numSwitches();
        n3 = this.distances.length;
        if (d2 <= this.distances[0]) {
            n3 = 0;
        } else {
            for (n2 = 1; n2 < this.distances.length; ++n2) {
                if (!(d2 > this.distances[n2 - 1]) || !(d2 <= this.distances[n2])) continue;
                n3 = n2;
                break;
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            Switch switch_ = this.getSwitch(n2);
            if (((SwitchRetained)switch_.retained).getWhichChild() == n3) continue;
            switch_.setWhichChild(n3);
        }
        this.wakeupOn(this.wakeupFrame);
    }

    public Node cloneNode(boolean bl) {
        DistanceLOD distanceLOD = new DistanceLOD();
        distanceLOD.duplicateNode(this, bl);
        return distanceLOD;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        DistanceLOD distanceLOD = (DistanceLOD)node;
        int n2 = distanceLOD.numDistances();
        this.distances = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setDistance(i2, distanceLOD.getDistance(i2));
        }
        Point3f point3f = new Point3f();
        distanceLOD.getPosition(point3f);
        this.setPosition(point3f);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        transformGroupRetained.transform.transform(this.position, this.position);
    }
}

