/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public abstract class Fog
extends Leaf {
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 12;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 13;
    public static final int ALLOW_COLOR_READ = 14;
    public static final int ALLOW_COLOR_WRITE = 15;
    public static final int ALLOW_SCOPE_READ = 18;
    public static final int ALLOW_SCOPE_WRITE = 19;
    private static final int[] readCapabilities = new int[]{12, 14, 18};

    public Fog() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Fog(Color3f color3f) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((FogRetained)this.retained).initColor(color3f);
    }

    public Fog(float f2, float f3, float f4) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((FogRetained)this.retained).initColor(f2, f3, f4);
    }

    public void setColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog0"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setColor(color3f);
        } else {
            ((FogRetained)this.retained).initColor(color3f);
        }
    }

    public void setColor(float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog0"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setColor(f2, f3, f4);
        } else {
            ((FogRetained)this.retained).initColor(f2, f3, f4);
        }
    }

    public void getColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog2"));
        }
        ((FogRetained)this.retained).getColor(color3f);
    }

    public void setInfluencingBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog3"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setInfluencingBounds(bounds);
        } else {
            ((FogRetained)this.retained).initInfluencingBounds(bounds);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog4"));
        }
        return ((FogRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog3"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setInfluencingBoundingLeaf(boundingLeaf);
        } else {
            ((FogRetained)this.retained).initInfluencingBoundingLeaf(boundingLeaf);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog4"));
        }
        return ((FogRetained)this.retained).getInfluencingBoundingLeaf();
    }

    public void setScope(Group group, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog7"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setScope(group, n2);
        } else {
            ((FogRetained)this.retained).initScope(group, n2);
        }
    }

    public Group getScope(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog8"));
        }
        return ((FogRetained)this.retained).getScope(n2);
    }

    public void insertScope(Group group, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog9"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).insertScope(group, n2);
        } else {
            ((FogRetained)this.retained).initInsertScope(group, n2);
        }
    }

    public void removeScope(int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog10"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).removeScope(n2);
        } else {
            ((FogRetained)this.retained).initRemoveScope(n2);
        }
    }

    public Enumeration getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog11"));
        }
        return ((FogRetained)this.retained).getAllScopes();
    }

    public void addScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog12"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).addScope(group);
        } else {
            ((FogRetained)this.retained).initAddScope(group);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog11"));
        }
        return ((FogRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog8"));
        }
        return ((FogRetained)this.retained).indexOfScope(group);
    }

    public void removeScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog10"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).removeScope(group);
        } else {
            ((FogRetained)this.retained).initRemoveScope(group);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog10"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).removeAllScopes();
        } else {
            ((FogRetained)this.retained).initRemoveAllScopes();
        }
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        FogRetained fogRetained = (FogRetained)node.retained;
        FogRetained fogRetained2 = (FogRetained)this.retained;
        Color3f color3f = new Color3f();
        fogRetained.getColor(color3f);
        fogRetained2.initColor(color3f);
        fogRetained2.initInfluencingBounds(fogRetained.getInfluencingBounds());
        Enumeration enumeration = fogRetained.getAllScopes();
        while (enumeration.hasMoreElements()) {
            fogRetained2.initAddScope((Group)enumeration.nextElement());
        }
        fogRetained2.initInfluencingBoundingLeaf(fogRetained.getInfluencingBoundingLeaf());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        FogRetained fogRetained = (FogRetained)this.retained;
        BoundingLeaf boundingLeaf = fogRetained.getInfluencingBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            fogRetained.initInfluencingBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
        int n2 = fogRetained.numScopes();
        for (int i2 = 0; i2 < n2; ++i2) {
            fogRetained.initScope((Group)nodeReferenceTable.getNewObjectReference(fogRetained.getScope(i2)), i2);
        }
    }
}

