/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.media.j3d.J3dI18N;
import javax.vecmath.Point2f;

public class FontExtrusion {
    float length = 0.2f;
    Shape shape;
    Point2f[] pnts;
    double tessellationTolerance = 0.01;

    public FontExtrusion() {
        this.shape = null;
    }

    public FontExtrusion(Shape shape) {
        this.setExtrusionShape(shape);
    }

    public FontExtrusion(Shape shape, double d2) {
        this.tessellationTolerance = d2;
        this.setExtrusionShape(shape);
    }

    public void setExtrusionShape(Shape shape) {
        this.shape = shape;
        if (this.shape == null) {
            return;
        }
        PathIterator pathIterator = this.shape.getPathIterator(null, this.tessellationTolerance);
        ArrayList<Point2f> arrayList = new ArrayList<Point2f>();
        float[] fArray = new float[6];
        float f2 = 0.0f;
        int n2 = 0;
        int n3 = -1;
        while (!pathIterator.isDone()) {
            Point2f point2f = new Point2f();
            int n4 = pathIterator.currentSegment(fArray);
            if (n4 == 1) {
                point2f.x = fArray[0];
                point2f.y = fArray[1];
                if (n3 == -1) {
                    if (f2 < point2f.x) {
                        n3 = 0;
                    } else if (f2 > point2f.x) {
                        n3 = 1;
                    }
                }
                if (n3 == 0 && f2 > point2f.x || n3 == 1 && f2 < point2f.x) {
                    throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion0"));
                }
                f2 = point2f.x;
                ++n2;
                arrayList.add(point2f);
            } else if (n4 == 0) {
                if (n2 != 0) {
                    throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion3"));
                }
                point2f.x = fArray[0];
                point2f.y = fArray[1];
                f2 = point2f.x;
                ++n2;
                arrayList.add(point2f);
            }
            pathIterator.next();
        }
        int n5 = arrayList.size();
        this.pnts = new Point2f[n5];
        if (n3 == 0) {
            for (int i2 = 0; i2 < n5; ++i2) {
                this.pnts[i2] = (Point2f)arrayList.get(i2);
            }
        } else {
            for (int i3 = 0; i3 < n5; ++i3) {
                this.pnts[i3] = (Point2f)arrayList.get(n5 - i3 - 1);
            }
        }
        this.pnts[n5 - 1].y = 0.0f;
        if (this.pnts[0].x != 0.0f) {
            throw new IllegalArgumentException(J3dI18N.getString("FontExtrusion1"));
        }
        float f3 = this.pnts[0].x - this.pnts[n5 - 1].x;
        float f4 = this.pnts[0].y - this.pnts[n5 - 1].y;
        this.length = (float)Math.sqrt(f3 * f3 + f4 * f4);
    }

    public Shape getExtrusionShape() {
        return this.shape;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }
}

